/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model.nullspace;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.varint.VarIntNumber;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.model.nullspace.AbstractNullspaceColumnInspectorModifier;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import ch.javasoft.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullspaceVarIntColumnInspectorModifier
extends AbstractNullspaceColumnInspectorModifier<VarIntNumber, VarIntNumber[]> {
    public NullspaceVarIntColumnInspectorModifier(boolean convertNumericToBinaryOnMerge) {
        super(convertNumericToBinaryOnMerge);
    }

    @Override
    public int getHyperplaneSign(ColumnHome<VarIntNumber, ?> columnHome, EfmModel model, IBitSet binaryVals, int binarySize, VarIntNumber[] numericVals, IterationStateModel iteration) {
        int numericInd = this.getNumericIndex(model, binarySize, numericVals.length, iteration.getHyperplaneIndex());
        return numericVals[numericInd].signum();
    }

    @Override
    public IBitSet convertBinary(ColumnHome<VarIntNumber, ?> columnHome, EfmModel model, IBitSet binaryVals, int binarySize, VarIntNumber[] numericVals, IterationStepModel iteration, boolean clone) {
        int convertCount = this.getConvertSizeBinary(model, binarySize, numericVals.length, iteration);
        if (clone) {
            binaryVals = binaryVals.clone();
        }
        if (convertCount == 0) {
            return binaryVals;
        }
        int hyperInd = iteration.getCurrentState().getHyperplaneIndex();
        int i = 0;
        while (i < convertCount) {
            int signum;
            int numericInd = this.getNumericIndex(model, binarySize, numericVals.length, hyperInd + i);
            int n = signum = numericInd == -1 ? 0 : numericVals[numericInd].signum();
            if (signum < 0) {
                throw new IllegalStateException("pivot value is below zero: " + numericVals[numericInd]);
            }
            if (signum == 0) {
                binaryVals.set(hyperInd + i);
            }
            ++i;
        }
        return binaryVals;
    }

    @Override
    public VarIntNumber[] convertNumeric(ColumnHome<VarIntNumber, ?> columnHome, EfmModel model, IBitSet binaryVals, int binarySize, VarIntNumber[] numericVals, IterationStepModel iteration, boolean clone) {
        int convertCount = this.getConvertSizeNumeric(model, binarySize, numericVals.length, iteration);
        if (convertCount == 0 && !clone) {
            return numericVals;
        }
        Number[] newvals = Arrays.copyOfRange(numericVals, convertCount, numericVals.length);
        return (VarIntNumber[])columnHome.getNumberOperations().reduceVector(false, newvals);
    }

    @Override
    public VarIntNumber[] mergeNumeric(ColumnHome<VarIntNumber, ?> columnHome, EfmModel model, IBitSet binaryValsCol1, int binarySizeCol1, VarIntNumber[] numericValsCol1, IBitSet binaryValsCol2, int binarySizeCol2, VarIntNumber[] numericValsCol2, IterationStepModel iteration) {
        int hyperInd = iteration.getCurrentState().getHyperplaneIndex();
        int numerInd1 = this.getNumericIndex(model, binarySizeCol1, numericValsCol1.length, hyperInd);
        int numerInd2 = this.getNumericIndex(model, binarySizeCol2, numericValsCol2.length, hyperInd);
        VarIntNumber mulCol1 = numericValsCol2[numerInd2];
        VarIntNumber mulCol2 = numericValsCol1[numerInd1];
        NumberOperations<VarIntNumber> numOps = columnHome.getNumberOperations();
        VarIntNumber check = numOps.subtract(numOps.multiply(numericValsCol1[numerInd1], mulCol1), numOps.multiply(numericValsCol2[numerInd2], mulCol2));
        if (check.signum() != 0) {
            throw new IllegalArgumentException("combination of " + numericValsCol1[numerInd1] + " with " + numericValsCol2[numerInd2] + " is not zero: " + check);
        }
        return (VarIntNumber[])ColumnUtil.mergeNumeric((EfmModel)model, numOps, (Number)mulCol1, (Number[])numericValsCol1, (Number)mulCol2, (Number[])numericValsCol2, (boolean)this.convertNumericToBinaryOnMerge);
    }
}

