/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model.nullspace;

import ch.javasoft.math.NumberOperations;
import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.AbstractColumnToFluxDistributionConverter;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.metabolic.efm.model.nullspace.CannotReconstructFluxException;
import ch.javasoft.metabolic.efm.model.nullspace.LogPkg;
import ch.javasoft.metabolic.efm.output.CallbackGranularity;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.util.logging.LogFragmenter;
import ch.javasoft.util.logging.LogPrintWriter;
import ch.javasoft.util.numeric.Zero;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullspaceColumnToFluxDistributionConverter<N extends Number, Col extends Column>
extends AbstractColumnToFluxDistributionConverter<N, Col> {
    private static final Logger LOG = LogPkg.LOGGER;

    public NullspaceColumnToFluxDistributionConverter(ColumnHome<N, Col> columnHome) {
        super(columnHome);
    }

    @Override
    protected FluxDistribution createFluxDistributionFromColumn(LogFragmenter log, Config config, NetworkEfmModel model, Col column, CallbackGranularity granularity) {
        ReadableMatrix stoichMatrix = model.getStoichiometricMatrix(this.columnHome);
        NumberOperations numberOps = stoichMatrix.getNumberOperations();
        Zero zero = config.zero();
        int nonZeroCount = 0;
        int size = model.getReactionSorting().length;
        int boolSize = column.booleanSize();
        int numSize = column.numericSize();
        int[] colIndices = new int[size];
        int ii = 0;
        while (ii < size) {
            if (ii < boolSize && !column.get(ii) || ii >= boolSize && column.getNumericSignum(zero, numSize + ii - size) != 0) {
                colIndices[nonZeroCount] = model.getReactionSorting()[ii];
                ++nonZeroCount;
            }
            ++ii;
        }
        Object[] values = numberOps.newArray(size);
        Arrays.fill(values, numberOps.zero());
        if (granularity.isBinarySufficient()) {
            int i = 0;
            while (i < nonZeroCount) {
                values[colIndices[i]] = numberOps.one();
                ++i;
            }
        } else {
            Number[][] subStoichValues = numberOps.newArray(model.getMetabolicNetwork().getMetabolites().length(), nonZeroCount);
            int row = 0;
            while (row < subStoichValues.length) {
                int col = 0;
                while (col < subStoichValues[row].length) {
                    subStoichValues[row][col] = stoichMatrix.getNumberValueAt(row, colIndices[col]);
                    ++col;
                }
                ++row;
            }
            ReadableMatrix subStoichMatrix = stoichMatrix.newInstance(subStoichValues, true).toReadableMatrix(false);
            ReadableMatrix untypedFluxes = NullspaceColumnToFluxDistributionConverter.nullspace(subStoichMatrix, zero);
            ReadableMatrix fluxes = this.columnHome.convertMatrix(untypedFluxes, false, true);
            if (fluxes.getColumnCount() != 1) {
                if (log != null) {
                    log.cleanUp();
                }
                LOG.warning("uncompression failed for efm.");
                LOG.warning("sub-stoich-matrix for this efm:");
                LogPrintWriter logWriter = new LogPrintWriter(LOG, Level.INFO);
                subStoichMatrix.writeToMultiline(logWriter);
                logWriter.flush();
                throw new CannotReconstructFluxException((Column)column, fluxes);
            }
            int negCnt = 0;
            int posCnt = 0;
            int ii2 = 0;
            while (ii2 < fluxes.getRowCount()) {
                Object value = fluxes.getNumberValueAt(ii2, 0);
                values[colIndices[ii2]] = value;
                int sgn = numberOps.signum(value);
                if (sgn > 0) {
                    ++posCnt;
                } else if (sgn < 0) {
                    ++negCnt;
                }
                ++ii2;
            }
            if (posCnt > 0 && negCnt > 0 && size == boolSize) {
                throw new CannotReconstructFluxException("negative and positive fluxes: " + Arrays.toString(values), (Column)column, fluxes);
            }
            if (negCnt > posCnt) {
                ii2 = 0;
                while (ii2 < values.length) {
                    values[ii2] = numberOps.negate(values[ii2]);
                    ++ii2;
                }
            }
        }
        Number[] unexpanded = model.getReactionMapping().getUnexpandedFluxValues(this.columnHome, (Number[])values);
        return this.columnHome.createFluxDistribution(model.getMetabolicNetwork(), unexpanded);
    }

    private static <N extends Number> ReadableMatrix<N> nullspace(ReadableMatrix<N> subStoich, Zero zero) {
        if (subStoich instanceof DoubleMatrix) {
            return new Gauss(zero.mZeroPos).nullspace((DoubleMatrix)subStoich);
        }
        if (subStoich instanceof BigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().nullspace((BigIntegerRationalMatrix)subStoich);
        }
        if (subStoich instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().nullspace((ReadableBigIntegerRationalMatrix)subStoich);
        }
        throw new IllegalArgumentException("unsupported matrix type: " + subStoich.getClass());
    }
}

