/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.matrix;

import ch.javasoft.metabolic.efm.borndie.BornDieController;
import ch.javasoft.metabolic.efm.borndie.job.DefaultPairingJob;
import ch.javasoft.metabolic.efm.borndie.job.PairingJob;
import ch.javasoft.metabolic.efm.borndie.matrix.BornDieMatrix;
import ch.javasoft.metabolic.efm.borndie.matrix.CellStage;
import ch.javasoft.metabolic.efm.borndie.matrix.LogPkg;
import ch.javasoft.metabolic.efm.borndie.matrix.PairingRule;
import ch.javasoft.metabolic.efm.borndie.memory.FilteredSortablePosMemory;
import ch.javasoft.metabolic.efm.borndie.range.CellRange;
import ch.javasoft.metabolic.efm.borndie.range.DefaultCellRange;
import ch.javasoft.metabolic.efm.borndie.range.LowerTriangularMatrix;
import ch.javasoft.metabolic.efm.borndie.range.RectangularRange;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.DefaultMemoryPart;
import ch.javasoft.metabolic.efm.memory.IterableMemory;
import ch.javasoft.metabolic.efm.memory.MappedSortableMemory;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentBornDieMatrix<Col extends Column>
implements BornDieMatrix<Col> {
    private final Logger LOG = LogPkg.LOGGER;
    private final LowerTriangularMatrix tril;
    private final BornDieController<Col> controller;
    private final AtomicReferenceArray<AppendableMemory<Col>> appMemoriesByCell;
    private final AtomicReferenceArray<SortableMemory<Col>> sortMemoriesByCell;
    private final ConcurrentHashMap<PosMemKey, FilteredSortablePosMemory<Col>> posMemoriesByNegPos;
    private final AtomicInteger lowestBearingRow;
    private final AtomicIntegerArray bearingCellCountByRow;
    private final AtomicIntegerArray jobCountByCell;

    public ConcurrentBornDieMatrix(BornDieController<Col> controller, LowerTriangularMatrix tril) throws IOException {
        this.controller = controller;
        this.tril = tril;
        this.appMemoriesByCell = new AtomicReferenceArray(tril.getCellCount());
        this.sortMemoriesByCell = new AtomicReferenceArray(tril.getCellCount());
        this.posMemoriesByNegPos = new ConcurrentHashMap();
        this.lowestBearingRow = new AtomicInteger(-1);
        this.bearingCellCountByRow = new AtomicIntegerArray(tril.getRowCount());
        this.jobCountByCell = new AtomicIntegerArray(tril.getCellCount());
        int r = 0;
        while (r < tril.getRowCount()) {
            this.bearingCellCountByRow.set(r, tril.getRowWidth(r));
            int c = tril.getColumnFrom(r);
            while (c < tril.getColumnTo(r)) {
                DefaultMemoryPart part = new DefaultMemoryPart("b" + c + "-d" + r);
                int index = tril.cellToIndex(c, r);
                AppendableMemory<Col> mem = controller.getMemoryFactory().createConcurrentAppendableMemory(controller.getColumnHome(), controller.getModel(), c, part);
                this.appMemoriesByCell.set(index, mem);
                PairingRule rule = new PairingRule(tril, new DefaultCellRange(c, r));
                this.jobCountByCell.set(index, rule.getPartnerCells().getCellCount());
                ++c;
            }
            ++r;
        }
    }

    @Override
    public LowerTriangularMatrix getMatrixRange() {
        return this.tril;
    }

    @Override
    public int getIterationCount() {
        return this.tril.getLength() - 1;
    }

    @Override
    public CellStage getCellStage(int bornCol, int dieRow) {
        int refRow = this.lowestBearingRow.get();
        if (dieRow < refRow) {
            return CellStage.Done;
        }
        if (bornCol > refRow) {
            return CellStage.Accumulating;
        }
        return this.jobCountByCell.get(this.tril.cellToIndex(bornCol, dieRow)) == 0 ? CellStage.Collaborating : CellStage.Bearing;
    }

    private void checkExpectedStage(int bornCol, int dieRow, CellStage expected) {
        switch (expected) {
            case Accumulating: {
                if (bornCol <= this.lowestBearingRow.get()) {
                    throw this.createIllegalStageException(bornCol, dieRow, expected);
                }
                return;
            }
            case Done: {
                if (dieRow >= this.lowestBearingRow.get()) {
                    throw this.createIllegalStageException(bornCol, dieRow, expected);
                }
                return;
            }
        }
        if (!this.getCellStage(bornCol, dieRow).equals((Object)expected)) {
            throw this.createIllegalStageException(bornCol, dieRow, expected);
        }
    }

    private void checkActiveStage(int bornCol, int dieRow) {
        int refRow = this.lowestBearingRow.get();
        if (bornCol > refRow || dieRow < refRow) {
            throw new IllegalStateException("cell " + new DefaultCellRange(bornCol, dieRow) + " is not in an active stage: " + (Object)((Object)this.getCellStage(bornCol, dieRow)));
        }
    }

    private IllegalStateException createIllegalStageException(int bornCol, int dieRow, CellStage expected) {
        return new IllegalStateException("cell " + new DefaultCellRange(bornCol, dieRow) + " is not " + (Object)((Object)expected) + ": " + (Object)((Object)this.getCellStage(bornCol, dieRow)));
    }

    @Override
    public void schedulePairingJobs(int bornCol, int dieRow, int activeBornColumnFrom, int activeBornColumnTo) throws IOException, IllegalStateException, IllegalArgumentException {
        DefaultCellRange owner = new DefaultCellRange(bornCol, dieRow);
        RectangularRange partners = new PairingRule(this.tril, owner).getPartnerCells();
        if (partners.getCellCount() > 0) {
            if (this.isEmpty(bornCol, dieRow)) {
                this.notifyAllJobsEmpty(owner);
            } else {
                this.checkExpectedStage(bornCol, dieRow, CellStage.Bearing);
                int c = activeBornColumnFrom;
                while (c < activeBornColumnTo) {
                    int r = partners.getDieRowFrom();
                    while (r < partners.getDieRowTo()) {
                        DefaultCellRange partnerCell = new DefaultCellRange(c, r);
                        if (this.isEmpty(c, r)) {
                            this.notifyPairingJobCompleted(owner, partnerCell, 0, true);
                        } else {
                            DefaultPairingJob<Col> job = new DefaultPairingJob<Col>(this.controller, owner, partnerCell);
                            this.controller.addPairingJob(job);
                        }
                        ++r;
                    }
                    ++c;
                }
            }
        } else {
            throw new IllegalArgumentException("final row " + dieRow + " cannot schedule pairing jobs");
        }
    }

    @Override
    public void notifyPairingJobCompleted(PairingJob<Col> job) throws IOException {
        this.notifyPairingJobCompleted(job.getCellRangeNeg(), job.getCellRangePos(), job.getAppendedColumnCount(), false);
    }

    private void notifyPairingJobCompleted(CellRange owner, CellRange partner, int newCount, boolean empty) throws IOException {
        int negIndex = this.tril.cellToIndex(owner.getBornColumn(), owner.getDieRow());
        int left = this.jobCountByCell.decrementAndGet(negIndex);
        if (empty) {
            this.LOG.finest("job empty for cells {neg=" + owner + ", pos=" + partner + "}, owner jobs left:" + left);
        } else {
            this.LOG.finest("job completed for cells {neg=" + owner + ", pos=" + partner + "}, new modes=" + newCount + ", owner jobs left:" + left);
        }
        if (left == 0) {
            this.LOG.finest("all jobs completed for cell " + owner);
            this.notifyAllJobsCompleted(owner);
        }
    }

    private void notifyAllJobsEmpty(CellRange owner) throws IOException {
        if (this.jobCountByCell.getAndSet(this.tril.cellToIndex(owner.getBornColumn(), owner.getDieRow()), 0) > 0) {
            this.LOG.finest("all jobs empty for cell " + owner);
            this.notifyAllJobsCompleted(owner);
        }
    }

    private void notifyAllJobsCompleted(CellRange owner) throws IOException {
        int bornCol = owner.getBornColumn();
        int dieRow = owner.getDieRow();
        int left = this.bearingCellCountByRow.decrementAndGet(dieRow);
        if (left == 0) {
            this.LOG.finest("row " + dieRow + " completed bearing");
            this.notifyRowJobsCompleted(dieRow);
        } else {
            this.LOG.finest("row " + dieRow + " bearing left: " + left);
        }
        if (this.controller.getDebugger().doDebug()) {
            this.controller.getDebugger().notifyAllPairingJobsComplete(bornCol, dieRow, left);
        }
    }

    @Override
    public void notifyInitialColumnComplete() throws IOException {
        this.notifyRowJobsCompleted(-1);
    }

    private void notifyRowJobsCompleted(int dieRow) throws IOException {
        if (this.lowestBearingRow.get() == dieRow) {
            int index;
            int newBearingCol = this.lowestBearingRow.get() + 1;
            int r = this.tril.getRowFrom(newBearingCol);
            while (r < this.tril.getRowTo(newBearingCol)) {
                index = this.tril.cellToIndex(newBearingCol, r);
                AppendableMemory appMem = this.appMemoriesByCell.getAndSet(index, null);
                if (appMem != null && !this.sortMemoriesByCell.compareAndSet(index, null, appMem.toSortableMemory())) {
                    throw new RuntimeException("internal error: sortable memory aready set");
                }
                ++r;
            }
            int c = this.tril.getColumnFrom(dieRow);
            while (c < this.tril.getColumnTo(dieRow)) {
                index = this.tril.cellToIndex(c, dieRow);
                this.sortMemoriesByCell.set(index, null);
                ++c;
            }
            int newLowestDieRow = dieRow + 1;
            if (this.lowestBearingRow.compareAndSet(dieRow, newLowestDieRow)) {
                if (this.tril.isFinalRow(newLowestDieRow)) {
                    this.lowestBearingRow.incrementAndGet();
                    this.controller.terminate();
                } else {
                    this.controller.switchColumnToBearingStage(newBearingCol);
                    if (this.bearingCellCountByRow.get(newLowestDieRow) == 0) {
                        this.notifyRowJobsCompleted(newLowestDieRow);
                    }
                }
            }
        }
        if (dieRow >= 0) {
            this.controller.getDebugger().notifyRowPairingJobsComplete(dieRow);
        }
    }

    @Override
    public AppendableMemory<Col> getForAppending(int bornCol, int dieRow) throws IllegalStateException, IOException {
        this.checkExpectedStage(bornCol, dieRow, CellStage.Accumulating);
        return this.appMemoriesByCell.get(this.tril.cellToIndex(bornCol, dieRow));
    }

    @Override
    public SortableMemory<Col> getNegForGenerating(int bornCol, int dieRow) throws IllegalStateException, IOException {
        this.checkActiveStage(bornCol, dieRow);
        return new MappedSortableMemory(this.sortMemoriesByCell.get(this.tril.cellToIndex(bornCol, dieRow)));
    }

    @Override
    public SortableMemory<Col> getPosForGenerating(int bornCol, int dieRow, int partnerDieRow) throws IllegalStateException, IOException {
        this.checkActiveStage(bornCol, dieRow);
        PosMemKey key = new PosMemKey(bornCol, dieRow, partnerDieRow);
        FilteredSortablePosMemory<Col> mem = this.posMemoriesByNegPos.get(key);
        if (mem == null) {
            mem = new FilteredSortablePosMemory<Col>(this.controller, this.getNegForGenerating(bornCol, dieRow), partnerDieRow);
            this.posMemoriesByNegPos.put(key, mem);
        }
        return mem.clone();
    }

    @Override
    public IterableMemory<Col> getFinal(int bornCol) throws IllegalStateException, IOException {
        int dieRow = this.tril.getFinalRow();
        this.checkExpectedStage(bornCol, dieRow, CellStage.Done);
        return this.sortMemoriesByCell.get(this.tril.cellToIndex(bornCol, dieRow));
    }

    @Override
    public int getColumnCount(int bornCol, int dieRow) throws IOException {
        CellStage stage = this.getCellStage(bornCol, dieRow);
        switch (stage) {
            case Accumulating: {
                return this.getForAppending(bornCol, dieRow).getColumnCount();
            }
            case Bearing: 
            case Collaborating: {
                SortableMemory<Col> mem = this.getNegForGenerating(bornCol, dieRow);
                return mem.getColumnCount();
            }
            case Done: {
                return this.tril.isFinalRow(dieRow) ? this.getFinal(bornCol).getColumnCount() : 0;
            }
        }
        throw new IllegalStateException("unknown cell stage: " + (Object)((Object)stage));
    }

    @Override
    public boolean isEmpty(int bornCol, int dieRow) throws IOException {
        return this.getColumnCount(bornCol, dieRow) == 0;
    }

    public String toString() {
        int it = this.getIterationCount();
        StringBuilder sb = new StringBuilder(String.valueOf(it) + "x" + it);
        try {
            int row = 0;
            while (row <= it) {
                int col = 0;
                while (col <= row) {
                    CellStage stage = this.getCellStage(col, row);
                    if (col > 0) {
                        sb.append(' ');
                    }
                    sb.append(String.valueOf(stage.toChar()) + "[" + row + ", " + col + "]=" + this.getColumnCount(col, row));
                    ++col;
                }
                sb.append('\n');
                ++row;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            sb.append(ex);
        }
        return sb.toString();
    }

    private static class PosMemKey {
        private final int negBornCol;
        private final int negDieRow;
        private final int posDieRow;

        public PosMemKey(int negBornCol, int negDieRow, int posDieRow) {
            this.negBornCol = negBornCol;
            this.negDieRow = negDieRow;
            this.posDieRow = posDieRow;
        }

        public int hashCode() {
            return this.negBornCol ^ this.negDieRow ^ this.posDieRow;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PosMemKey) {
                PosMemKey other = (PosMemKey)obj;
                return this.negBornCol == other.negBornCol && this.negDieRow == other.negDieRow && this.posDieRow == other.posDieRow;
            }
            return false;
        }

        public String toString() {
            return "[neg-born-col=" + this.negBornCol + ", neg-die-row=" + this.negDieRow + ", pos-die-row=" + this.posDieRow + "]";
        }
    }
}

