/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.job;

import ch.javasoft.metabolic.efm.adj.AdjEnum;
import ch.javasoft.metabolic.efm.borndie.BornDieController;
import ch.javasoft.metabolic.efm.borndie.job.PairingJob;
import ch.javasoft.metabolic.efm.borndie.matrix.BornDieMatrix;
import ch.javasoft.metabolic.efm.borndie.memory.ColumnDemuxAppendableMemory;
import ch.javasoft.metabolic.efm.borndie.range.CellRange;
import ch.javasoft.metabolic.efm.borndie.range.DefaultColumnRange;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPairingJob<Col extends Column>
implements PairingJob<Col> {
    private final BornDieController<Col> controller;
    private final CellRange neg;
    private final CellRange pos;
    private SortableMemory<Col> memNeg;
    private SortableMemory<Col> memPos;
    private ColumnDemuxAppendableMemory<Col> memApp;

    public DefaultPairingJob(BornDieController<Col> controller, CellRange neg, CellRange pos) {
        this.controller = controller;
        this.neg = neg;
        this.pos = pos;
    }

    public BornDieMatrix<Col> getBornDieMatrix() {
        return this.controller.getMatrix();
    }

    @Override
    public CellRange getCellRangeNeg() {
        return this.neg;
    }

    @Override
    public CellRange getCellRangePos() {
        return this.pos;
    }

    @Override
    public int getIteration() {
        return this.getCellRangeNeg().getDieRow() + 1;
    }

    @Override
    public ColumnDemuxAppendableMemory<Col> getMemoryForAppending() throws IOException {
        if (this.memApp == null) {
            CellRange neg = this.getCellRangeNeg();
            this.memApp = new DefaultColumnRange(neg.getDieRow() + 1, neg.getDieRow() + 1, this.controller.getIterationCount() + 1).getForAppending((BornDieController)this.controller);
        }
        return this.memApp;
    }

    @Override
    public SortableMemory<Col> getMemoryNeg() throws IOException {
        if (this.memNeg == null) {
            BornDieMatrix<Col> matrix = this.getBornDieMatrix();
            CellRange neg = this.getCellRangeNeg();
            this.memNeg = neg.getNegForGenerating(matrix);
        }
        return this.memNeg;
    }

    @Override
    public SortableMemory<Col> getMemoryPos() throws IOException {
        if (this.memPos == null) {
            BornDieMatrix<Col> matrix = this.getBornDieMatrix();
            this.memPos = this.pos.getPosForGenerating(matrix, this.getCellRangeNeg().getDieRow());
        }
        return this.memPos;
    }

    @Override
    public int getAppendedColumnCount() {
        return this.memApp == null ? 0 : this.memApp.getAppendedColumnCount();
    }

    public int getColumnCountNeg() {
        try {
            return this.getMemoryNeg().getColumnCount();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getColumnCountPos() {
        try {
            return this.getMemoryPos().getColumnCount();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        try {
            SortableMemory<Col> memPos = this.getMemoryPos();
            if (memPos.getColumnCount() > 0) {
                Config config = this.controller.getConfig();
                NetworkEfmModel model = this.controller.getModel();
                AdjEnum adjEnum = config.getAdjMethodFactory().createAdjEnumFromConfig();
                adjEnum.initialize(this.controller.getColumnHome(), config, model);
                AdjEnumModel<Col> adjModel = new AdjEnumModel<Col>(model, this.getIteration(), memPos, null, this.getMemoryNeg(), this.getMemoryForAppending());
                adjEnum.adjacentPairs(this.controller.getColumnHome(), adjModel);
            }
            this.controller.getMatrix().notifyPairingJobCompleted(this);
            if (this.controller.getDebugger().doDebug()) {
                this.controller.getDebugger().notifyPairingComplete(this);
            }
        }
        catch (Exception e) {
            this.controller.handleJobException(this, e);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{neg=" + this.getCellRangeNeg() + "(" + this.getColumnCountNeg() + "), pos=" + this.getCellRangePos() + "(" + this.getColumnCountPos() + "), new=" + this.getAppendedColumnCount() + "}";
    }
}

