/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.debug;

import ch.javasoft.metabolic.efm.borndie.BornDieController;
import ch.javasoft.metabolic.efm.borndie.matrix.BornDieMatrix;
import ch.javasoft.metabolic.efm.borndie.matrix.CellStage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class DebuggerTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private final BornDieController controller;
    private static final long serialVersionUID = 1L;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;

    public DebuggerTableCellRenderer(BornDieController controller) {
        this.controller = controller;
        this.setOpaque(true);
        this.setBorder(DebuggerTableCellRenderer.getNoFocusBorder());
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setFont(table.getFont());
        if (column > row) {
            this.setBackground(Color.GRAY);
        } else {
            BornDieMatrix matrix = this.controller.getMatrix();
            if (matrix != null) {
                CellStage stage = matrix.getCellStage(column, row);
                this.setBackground(stage.toColor());
                if (matrix.getMatrixRange().isFinalRow(row)) {
                    if (stage.isAfter(CellStage.Accumulating)) {
                        this.setFont(table.getFont().deriveFont(1));
                    }
                } else {
                    this.setFont(table.getFont().deriveFont(2));
                }
            }
        }
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    super.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(col);
                }
            }
        } else {
            this.setBorder(DebuggerTableCellRenderer.getNoFocusBorder());
        }
        this.setValue(value);
        return this;
    }

    public boolean isOpaque() {
        boolean colorMatch;
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean bl = colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    public void repaint() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }

    public static class UIResource
    extends DefaultTableCellRenderer
    implements javax.swing.plaf.UIResource {
        private static final long serialVersionUID = 1L;
    }
}

