/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.adj.incore.AbstractSearchAdjacencyEnumerator;
import ch.javasoft.metabolic.efm.adj.incore.tree.AbstractRoot;
import ch.javasoft.metabolic.efm.adj.incore.tree.DefaultTreeFactory;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.column.AdjCandidates;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import java.io.IOException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternTreeSearchAdjacencyEnumerator
extends AbstractSearchAdjacencyEnumerator {
    public static final String NAME = "pattern-tree-search";
    private Node<Void> nodeZer;
    private Node<Void> nodePos;
    private Node<Void> nodeNeg;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void adjacentPairs(Queue<ColumnPair> adjacentPairs, SortableMemory<Column> zerCols, SortableMemory<Column> posCols, SortableMemory<Column> negCols) throws IOException {
        DefaultTreeFactory fac = new DefaultTreeFactory(this.mModel);
        this.nodePos = fac.createNode(posCols, AbstractRoot.calculateXorBitOrder(posCols), -1, 0, posCols.getColumnCount());
        this.nodeNeg = fac.createNode(negCols, AbstractRoot.calculateXorBitOrder(negCols), -1, 0, negCols.getColumnCount());
        this.nodeZer = fac.createNode(zerCols, AbstractRoot.calculateXorBitOrder(zerCols), -1, 0, zerCols.getColumnCount());
        super.adjacentPairs(adjacentPairs, zerCols, posCols, negCols);
        this.nodePos = null;
        this.nodeNeg = null;
        this.nodeZer = null;
    }

    @Override
    protected void filterAdjacentPairs(SortableMemory<Column> zerCols, SortableMemory<Column> posCols, SortableMemory<Column> negCols, AdjCandidates<Column> candidates) throws IOException {
        IBitSet filter = candidates.getIntersection(0);
        if ((filter = this.nodeZer.filterAdjacentPairs(filter, zerCols, candidates)) != null) {
            filter = this.nodePos.filterAdjacentPairs(filter, posCols, candidates);
        }
        if (filter != null) {
            filter = this.nodeNeg.filterAdjacentPairs(filter, negCols, candidates);
        }
    }
}

