/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.concurrent.SemaphoreConcurrentToken;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.progress.ProgressAggregator;
import ch.javasoft.metabolic.efm.tree.AdjacencyPrecondition;
import ch.javasoft.metabolic.efm.tree.BitPatternTree;
import ch.javasoft.metabolic.efm.tree.TreeMemAdjEnum;
import ch.javasoft.metabolic.efm.tree.TreePairTraverser;
import ch.javasoft.metabolic.efm.tree.concurrent.ConcurrentTreePairTraverser;
import ch.javasoft.metabolic.efm.tree.impl.MinCardinalityAdjacencyPrecondition;
import ch.javasoft.metabolic.efm.tree.incore.IncoreBitPatternTree;
import ch.javasoft.metabolic.efm.tree.search.DefaultSearchAdjacencyFilter;
import ch.javasoft.metabolic.efm.util.PreconditionUtil;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchInCoreAdjEnum
extends TreeMemAdjEnum<ConcurrentToken> {
    public static final String NAME = "search-incore";

    protected SearchInCoreAdjEnum(String name) {
        super(name);
    }

    public SearchInCoreAdjEnum() {
        this(NAME);
    }

    @Override
    protected <Col extends Column, N extends Number> ConcurrentToken createToken(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel, BitPatternTree posTree, BitPatternTree negTree, ProgressAggregator progress) throws IOException {
        SemaphoreConcurrentToken token;
        SemaphoreConcurrentToken semaphoreConcurrentToken = token = progress == null ? new SemaphoreConcurrentToken(this.getEfmModel()) : new SemaphoreConcurrentToken(this.getEfmModel(), progress);
        if (token.tryAcquirePermit()) {
            return token;
        }
        throw new RuntimeException("internal error: could not acquire permit to start main thread");
    }

    @Override
    protected <Col extends Column, N extends Number> void releaseToken(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel, BitPatternTree posTree, BitPatternTree negTree, ConcurrentToken token) {
        token.releasePermit();
        try {
            token.waitForChildThreads();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected <Col extends Column, N extends Number> TreePairTraverser<ConcurrentToken> createTreeTraverser(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, BitPatternTree posTree, BitPatternTree negTree, AdjacencyPrecondition<ConcurrentToken> precondition) throws IOException {
        AdjacencyPrecondition<ConcurrentToken> precond = new MinCardinalityAdjacencyPrecondition(this.getEfmModel());
        if (precondition != null) {
            precond = PreconditionUtil.and(precondition, precond);
        }
        int[] selectiveBits = SearchInCoreAdjEnum.calculateBitOrder(iterationModel.getMemoryPos(), iterationModel.getMemoryNeg());
        BitPatternTree zerTree = this.createTree(Thread.currentThread(), columnHome, iterationModel, BitPatternTree.Kind.Zero, selectiveBits, iterationModel.getMemoryZero());
        return new ConcurrentTreePairTraverser<ConcurrentToken>(this.getEfmModel(), precond, new DefaultSearchAdjacencyFilter(posTree, negTree, zerTree), iterationModel, posTree, negTree);
    }

    @Override
    protected <Col extends Column, N extends Number> BitPatternTree createTree(Thread treeOwner, ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel, BitPatternTree.Kind kind, int[] selectiveBits, SortableMemory<Col> columns) throws IOException {
        return new IncoreBitPatternTree(treeOwner, columnHome, this.getEfmModel(), itModel, kind, selectiveBits, columns);
    }
}

