/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic;

import ch.javasoft.metabolic.AnnotateableMetabolicNetwork;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Annotation {
    ModelName(String.class),
    Version(String.class),
    Date(Date.class),
    Organism(String.class),
    BiomassReaction(Reaction.class);

    private final Class annotationClass;

    private Annotation(Class annotationClass) {
        this.annotationClass = annotationClass;
    }

    public String getMnetName() {
        char[] chars = this.name().toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return String.valueOf(chars);
    }

    public Class<?> getAnnotationClass() {
        return this.annotationClass;
    }

    public void addAnnotation(AnnotateableMetabolicNetwork network, Object value) {
        this.checkValue(value);
        network.addAnnotation(network, this.name(), value);
    }

    public Object getAnnotation(MetabolicNetwork network) {
        Object value = network.getAnnotation(network, this.name());
        return value;
    }

    public void checkValue(Object value) throws IllegalArgumentException {
        if (value != null && !this.getAnnotationClass().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("illegal value type, expected " + this.getAnnotationClass().getName() + " but found " + value.getClass().getName() + ": " + value);
        }
    }
}

