/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase.util;

import ch.javasoft.jbase.Table;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableList<E>
extends AbstractList<E>
implements RandomAccess {
    private final Table<E> table;

    public TableList(Table<E> table) {
        this.table = table;
    }

    @Override
    public boolean add(E e) {
        try {
            this.table.add(e);
            return true;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void add(int index, E element) {
        try {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index " + index + " < 0");
            }
            if (index > this.table.size()) {
                throw new IndexOutOfBoundsException("index " + index + " > table size " + this.table.size());
            }
            if (index == this.table.size()) {
                this.add(element);
            } else {
                int i = this.table.size() - 1;
                while (i >= index) {
                    E e = this.table.get(i);
                    if (i == this.table.size()) {
                        this.table.add(e);
                    } else {
                        this.table.set(i + 1, e);
                    }
                    --i;
                }
                this.table.set(index, element);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        try {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index " + index + " < 0");
            }
            if (index > this.table.size()) {
                throw new IndexOutOfBoundsException("index " + index + " > table size " + this.table.size());
            }
            if (index == this.table.size()) {
                this.addAll(c);
            } else {
                E e;
                int tblSize = this.table.size();
                int colSize = c.size();
                int i = 0;
                while (i < colSize) {
                    e = this.table.get(tblSize - colSize + i);
                    this.table.add(e);
                    ++i;
                }
                i = tblSize - colSize;
                while (i >= index) {
                    e = this.table.get(i);
                    this.table.set(i + colSize, e);
                    --i;
                }
                for (E e2 : c) {
                    this.table.set(index, e2);
                    ++index;
                }
            }
            return true;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void clear() {
        try {
            this.table.removeAll();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        LinkedList clone = new LinkedList(c);
        try {
            int i = 0;
            while (i < this.table.size()) {
                E e = this.table.get(i);
                Iterator it = clone.iterator();
                while (it.hasNext()) {
                    if (!e.equals(it.next())) continue;
                    it.remove();
                }
                ++i;
            }
            return clone.isEmpty();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public E get(int index) {
        try {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index " + index + " < 0");
            }
            if (index >= this.table.size()) {
                throw new IndexOutOfBoundsException("index " + index + " >= table size " + this.table.size());
            }
            return this.table.get(index);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int indexOf(Object o) {
        try {
            int i = 0;
            while (i < this.table.size()) {
                E e = this.table.get(i);
                if (e.equals(o)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        try {
            int i = this.table.size() - 1;
            while (i >= 0) {
                E e = this.table.get(i);
                if (e.equals(o)) {
                    return i;
                }
                --i;
            }
            return -1;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public E remove(int index) {
        E entity = this.get(index);
        this.remove(index);
        return entity;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean any = false;
        for (Object e : c) {
            any |= this.remove(e);
        }
        return any;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        try {
            boolean modified = false;
            int i = 0;
            while (i < this.table.size()) {
                E e = this.table.get(i);
                boolean keep = false;
                for (Object ec : c) {
                    if (!e.equals(ec)) continue;
                    keep = true;
                    break;
                }
                if (!keep) {
                    this.table.remove(i);
                    modified = true;
                }
                ++i;
            }
            return modified;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public E set(int index, E element) {
        try {
            E prev = this.table.get(index);
            this.table.set(index, element);
            return prev;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int size() {
        try {
            return this.table.size();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (this.size() > a.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        int i = 0;
        while (i < a.length) {
            a[i] = this.get(i);
            ++i;
        }
        return a;
    }
}

