"use strict";
// Copyright (c) Dou Du
// Distributed under the terms of the Modified BSD License.
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("@jupyter-widgets/base");
const version_1 = require("./version");
// Import the CSS
require("../css/widget.css");
// Import the underscore.js
const _ = __importStar(require("underscore"));
const jquery_1 = __importDefault(require("jquery"));
class JmolModel extends base_1.DOMWidgetModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: JmolModel.model_name, _model_module: JmolModel.model_module, _model_module_version: JmolModel.model_module_version, _view_name: JmolModel.view_name, _view_module: JmolModel.view_module, _view_module_version: JmolModel.view_module_version, value: 'Hello World Dou' });
    }
    initialize() {
        base_1.DOMWidgetModel.prototype.initialize.apply(this, arguments);
        this.attributes['jmol_window_id'] = _.uniqueId('jmol_window');
        this.attributes['jmol_app_id'] = _.uniqueId('jmol_app');
    }
}
exports.JmolModel = JmolModel;
JmolModel.serializers = Object.assign({}, base_1.DOMWidgetModel.serializers);
JmolModel.model_name = 'JmolModel';
JmolModel.model_module = version_1.MODULE_NAME;
JmolModel.model_module_version = version_1.MODULE_VERSION;
JmolModel.view_name = 'JmolView'; // Set to null if no view
JmolModel.view_module = version_1.MODULE_NAME; // Set to null if no view
JmolModel.view_module_version = version_1.MODULE_VERSION;
class JmolView extends base_1.DOMWidgetView {
    constructor() {
        super(...arguments);
        this.template = _.template("<div id='jsmolapp' style='border:3px solid red; height: " + 500 +
            "px; width: " + 500 + "px; margin:0 auto;'>");
        this._jmolradio = document.createElement('div');
        this.jsmolwindowID = this.model.get('jmol_window_id');
        this.jsmolappID = this.model.get('jmol_app_id');
    }
    createDiv() {
        const jsmolwindowID = this.model.get('jmol_window_id');
        console.log(jsmolwindowID + "&*&*&*&*&*&*");
        const divstyle = jquery_1.default("<div id='" + jsmolwindowID + "' style='border:1px solid red; height: " +
            500 + "px; width: " + 500 + "px; margin:0 auto;'>");
        return (divstyle);
    }
    initialize() {
        const url = "https://chemapps.stolaf.edu/jmol/jsmol/JSmol.min.js";
        const script = document.createElement('script');
        script.src = url;
        script.async = false;
        script.onload = () => this.createView();
        document.querySelector("head").appendChild(script);
    }
    createView() {
        var that = this;
        window.set_measure = (a, b, c, d, e) => {
            console.log("The distance is:" + e);
            that.model.set('measure_distance', Number(e));
            that.touch();
        };
        window.set_pickcallback = (a, b, c) => {
            console.log("The picked atomno:" + c);
            that.model.set('atomno', Number(c));
            that.touch();
        };
        jquery_1.default(document).ready(() => __awaiter(this, void 0, void 0, function* () {
            var Info = {
                addSelectionOptions: false,
                debug: false,
                j2sPath: "https://chemapps.stolaf.edu/jmol/jsmol/j2s",
                readyFunction: null,
                script: "background black; frank off; cartoon on; spacefill off; wireframe off; backbone 1.5; color backbone chains",
                serverURL: "https://chemapps.stolaf.edu/jmol/jsmol/php/jsmol.php",
                src: null,
                use: "HTML5",
                height: "100%",
                width: "100%",
                MeasureCallback: "set_measure",
            };
            let jmol_html = yield Jmol.getAppletHtml(that.jsmolappID, Info);
            jquery_1.default("#" + that.jsmolwindowID).html(jmol_html);
            jquery_1.default("#" + that.jsmolappID + "_canvas2d").mouseleave(() => {
                let orientation = Jmol.scriptEcho(eval(that.jsmolappID), "show orientation");
                that.model.set('_current_orientation', orientation);
                that.touch();
            });
            jquery_1.default("#" + that.jsmolappID + "_canvas2d").mousedown(() => {
                Jmol.script(eval(that.jsmolappID), "isosurface off");
            });
            jquery_1.default("#" + that.jsmolappID + "_canvas2d").mouseup(() => {
                Jmol.script(eval(that.jsmolappID), "isosurface on");
            });
            Jmol.script(eval(that.jsmolappID), "load https://files.rcsb.org/view/1zaa.pdb;");
            Jmol.script(eval(that.jsmolappID), 'set pickCallback "set_pickcallback"');
            let jscript = ['spin on', 'spin off', 'unitcell on', 'unitcell off'];
            that._jmolradio.innerHTML = Jmol.jmolRadioGroup(eval(that.jsmolappID), jscript);
        }));
    }
    render() {
        //  this.el.classList.add('custom-widget');
        //  this.$el.html(this.template);
        this.$el.append(this.createDiv());
        this.createView();
        const hr = document.createElement('hr');
        this.$el.append(hr);
        this.$el.append(this._jmolradio);
        this.model.on('change:script', this._script_changed, this);
        this.model.on('change:structure', this._structure_changed, this);
        //  this.model.on('change:value', this._value_changed, this);
    }
    _script_changed() {
        Jmol.script(eval(this.jsmolappID), this.model.get('script'));
    }
    _structure_changed() {
        const href = window.location.href;
        const base_url = href.substring(0, href.indexOf('/lab'));
        const jsmolappID = this.model.get('jmol_app_id');
        const the_script = "load " + base_url + '/files' + this.model.get('structure');
        Jmol.script(eval(jsmolappID), the_script);
    }
}
exports.JmolView = JmolView;
//# sourceMappingURL=widget.js.map