# Sublime CLI

![MIT license](https://img.shields.io/badge/License-MIT-blue.svg) ![Python version](https://img.shields.io/badge/python-3.7+-blue.svg) ![PyPI version](https://badge.fury.io/py/sublime-cli.svg) [![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2Fsublime-security%2Fsublime-cli.svg?type=shield)](https://app.fossa.com/projects/git%2Bgithub.com%2Fsublime-security%2Fsublime-cli?ref=badge_shield)

The Sublime CLI lets you interact with the Sublime Analysis API right from the terminal. The CLI can also be used as a Python module for programmatic implementations.

**With the CLI/Python module, you can:**

- Analyze and query raw messages (EMLs and MSGs), MBOX files, and [Message Data Models (MDMs)](https://docs.sublimesecurity.com/docs/mdm)
- Write your own detection rules and queries
- Detect many different types of phishing attacks like executive impersonation and lookalike domains
- Triage reported phish

## Installation

Sublime CLI is available for Windows, macOS, and Linux. Refer to the [Quickstart](https://docs.sublimesecurity.com/docs/cli-quickstart) documentation for installation instructions.

## Documentation

For a full reference, see the [CLI reference docs](https://docs.sublimesecurity.com/docs/cli).
