import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
export declare const NEW_RELIC_LAYERS_ACCOUNT_ID = "451483290750";
export interface FunctionProps extends lambda.FunctionProps {
    readonly stage: string;
    readonly withBaseEnvironment?: boolean;
    readonly withBaseTags?: boolean;
}
export interface FunctionNewRelicProps extends FunctionProps {
    readonly newRelicLayerName: string;
    readonly newRelicLayerVersion: number;
    readonly newRelicAccountId: string;
    readonly newRelicwithExtensionSendLogs?: boolean;
}
export interface NewRelicProps {
    readonly handler: string;
    readonly newRelicLayerName: string;
    readonly newRelicLayerVersion: number;
    readonly newRelicAccountId: string;
    readonly newRelicwithExtensionSendLogs?: boolean;
}
export declare function getNewRelicLayer(scope: Construct, functionName: string, layerName: string, layerVersion: number, region: string): lambda.ILayerVersion;
export declare function addNewRelicLayer(scope: Construct, lambdaFunction: lambda.Function, props: NewRelicProps): void;
export declare class Function extends lambda.Function {
    readonly stage: string;
    constructor(scope: Construct, id: string, props: FunctionProps);
    addBaseTags(): void;
    addBaseEnvironment(): void;
}
export declare class NewRelicFunction extends Function {
    constructor(scope: Construct, id: string, props: FunctionNewRelicProps);
}
