import aiohttp, asyncio, sys, datetime

# https://discord.com/developers/docs/resources/user

# https://github.com/kyb3r/pycord/blob/dev/pycord/api/http.py

# https://cdn.discordapp.com/avatars/746807014658801704/ed8582aa1e1e0f9b873d06951d3a37fc.webp?size=1024

# Generated by https://quicktype.io

from typing import List, Any


class TextChannel:
    id: str
    guild_id: str
    name: str
    type: int
    position: int
    permission_overwrites: List[Any]
    rate_limit_per_user: int
    nsfw: bool
    topic: str
    last_message_id: str
    parent_id: str
    default_auto_archive_duration: int

    def __init__(
        self,
        id: str,
        guild_id: str,
        name: str,
        type: int,
        position: int,
        permission_overwrites: List[Any],
        rate_limit_per_user: int,
        nsfw: bool,
        topic: str,
        last_message_id: str,
        parent_id: str,
        default_auto_archive_duration: int,
    ) -> None:
        self.id = id
        self.guild_id = guild_id
        self.name = name
        self.type = type
        self.position = position
        self.permission_overwrites = permission_overwrites
        self.rate_limit_per_user = rate_limit_per_user
        self.nsfw = nsfw
        self.topic = topic
        self.last_message_id = last_message_id
        self.parent_id = parent_id
        self.default_auto_archive_duration = default_auto_archive_duration
        self.DISCORD_EPOCH = 1420070400000

    def snowflake_time(self, id: int) -> datetime.datetime:
        timestamp = ((id >> 22) + self.DISCORD_EPOCH) / 1000
        return datetime.datetime.utcfromtimestamp(timestamp).replace(
            tzinfo=datetime.timezone.utc
        )

    def __repr__(self) -> str:
        fmt = f"id={self.id!r} name={self.name!r} is_nsfw={self.is_nsfw!r} topic={self.topic!r} last_message_id={self.last_message_id!r}"
        return "<TextChannel {}>".format(fmt)


class AnnouncementChannel:
    id: str
    guild_id: str
    name: str
    type: int
    position: int
    permission_overwrites: List[Any]
    nsfw: bool
    topic: str
    last_message_id: str
    parent_id: str
    default_auto_archive_duration: int

    def __init__(
        self,
        id: str,
        guild_id: str,
        name: str,
        type: int,
        position: int,
        permission_overwrites: List[Any],
        nsfw: bool,
        topic: str,
        last_message_id: str,
        parent_id: str,
        default_auto_archive_duration: int,
    ) -> None:
        self.id = id
        self.guild_id = guild_id
        self.name = name
        self.type = type
        self.position = position
        self.permission_overwrites = permission_overwrites
        self.is_nsfw = nsfw
        self.topic = topic
        self.last_message_id = last_message_id
        self.parent_id = parent_id
        self.default_auto_archive_duration = default_auto_archive_duration
        self.DISCORD_EPOCH = 1420070400000

    def snowflake_time(self, id: int) -> datetime.datetime:
        timestamp = ((id >> 22) + self.DISCORD_EPOCH) / 1000
        return datetime.datetime.utcfromtimestamp(timestamp).replace(
            tzinfo=datetime.timezone.utc
        )

    def __repr__(self) -> str:
        fmt = f"id={self.id!r} name={self.name!r} is_nsfw={self.is_nsfw!r} topic={self.topic!r} last_message_id={self.last_message_id!r}"
        return "<AnnouncementChannel {}>".format(fmt)


from typing import List, Any


class VoiceChannel:
    id: str
    guild_id: str
    name: str
    type: int
    nsfw: bool
    position: int
    permission_overwrites: List[Any]
    bitrate: int
    user_limit: int
    parent_id: None
    rtc_region: None

    def __init__(
        self,
        id: str,
        guild_id: str,
        name: str,
        type: int,
        nsfw: bool,
        position: int,
        permission_overwrites: List[Any],
        bitrate: int,
        user_limit: int,
        parent_id: None,
        rtc_region: None,
    ) -> None:
        self.id = id
        self.guild_id = guild_id
        self.name = name
        self.type = type
        self.nsfw = nsfw
        self.position = position
        self.permission_overwrites = permission_overwrites
        self.bitrate = bitrate
        self.user_limit = user_limit
        self.parent_id = parent_id
        self.rtc_region = rtc_region
        self.DISCORD_EPOCH = 1420070400000

    def snowflake_time(self, id: int) -> datetime.datetime:
        timestamp = ((id >> 22) + self.DISCORD_EPOCH) / 1000
        return datetime.datetime.utcfromtimestamp(timestamp).replace(
            tzinfo=datetime.timezone.utc
        )

    def __repr__(self) -> str:
        fmt = f"id={self.id!r} name={self.name!r} is_nsfw={self.is_nsfw!r} topic={self.topic!r} last_message_id={self.last_message_id!r}"
        return "<TextChannel {}>".format(fmt)


from typing import List


class Recipient:
    username: str
    discriminator: int
    id: str
    avatar: str

    def __init__(self, username: str, discriminator: int, id: str, avatar: str) -> None:
        self.username = username
        self.discriminator = discriminator
        self.id = id
        self.avatar = avatar


class DMChannel:
    last_message_id: str
    type: int
    id: str
    recipients: List[Recipient]

    def __init__(
        self, last_message_id: str, type: int, id: str, recipients: List[Recipient]
    ) -> None:
        self.last_message_id = last_message_id
        self.type = type
        self.id = id
        self.recipients = recipients
        self.DISCORD_EPOCH = 1420070400000

    def snowflake_time(self, id: int) -> datetime.datetime:
        timestamp = ((id >> 22) + self.DISCORD_EPOCH) / 1000
        return datetime.datetime.utcfromtimestamp(timestamp).replace(
            tzinfo=datetime.timezone.utc
        )

    def __repr__(self) -> str:
        fmt = f"id={self.id!r} name={self.name!r} last_message_id={self.last_message_id!r}"
        return "<DMChannel {}>".format(fmt)


class GroupDMChannel:
    name: str
    icon: None
    recipients: List[Recipient]
    last_message_id: str
    type: int
    id: str
    owner_id: str

    def __init__(
        self,
        name: str,
        icon: None,
        recipients: List[Recipient],
        last_message_id: str,
        type: int,
        id: str,
        owner_id: str,
    ) -> None:
        self.name = name
        self.icon = icon
        self.recipients = recipients
        self.last_message_id = last_message_id
        self.type = type
        self.id = id
        self.owner_id = owner_id
        self.DISCORD_EPOCH = 1420070400000

    def snowflake_time(self, id: int) -> datetime.datetime:
        timestamp = ((id >> 22) + self.DISCORD_EPOCH) / 1000
        return datetime.datetime.utcfromtimestamp(timestamp).replace(
            tzinfo=datetime.timezone.utc
        )

    def __repr__(self) -> str:
        fmt = f"id={self.id!r} name={self.name!r} last_message_id={self.last_message_id!r} recipients={self.recipients!r} owner_id={self.owner_id}"
        return "<GroupDMChannel {}>".format(fmt)
