from dweather_client.ipfs_queries import SimpleGriddedDataset, RtmaGriddedDataset, Era5LandWind, PrismGriddedDataset

"""
Module containing the leaf classes for the gridded dataset inheritance chain.
Do not add non-leaf classes to this file, as it will cause the dict built from this module to break
"""

class PrismcTmaxDaily(PrismGriddedDataset):
    dataset = "prismc-tmax-daily"

class PrismcTminDaily(PrismGriddedDataset):
    dataset = "prismc-tmin-daily"

class PrismcPrecipDaily(PrismGriddedDataset):
    dataset = "prismc-precip-daily"

class RtmaPcpHourly(RtmaGriddedDataset):
    dataset = "rtma_pcp-hourly"

class RtmaTempHourly(RtmaGriddedDataset):
    dataset = "rtma_temp-hourly"

class RtmaWindUHourly(RtmaGriddedDataset):
    dataset = "rtma_wind_u-hourly"

class RtmaWindVHourly(RtmaGriddedDataset):
    dataset = "rtma_wind_v-hourly"

class CpccPrecipUsDaily(SimpleGriddedDataset):
    dataset = "cpcc_precip_us-daily"

class CpccPrecipGlobalDaily(SimpleGriddedDataset):
    dataset = "cpcc_precip_global-daily"

class CpccTempMaxDaily(SimpleGriddedDataset):
    dataset = "cpcc_temp_max-daily"

class CpccTempMinDaily(SimpleGriddedDataset):
    dataset = "cpcc_temp_min-daily"

class ChirpscFinal05Daily(SimpleGriddedDataset):
    dataset = "chirpsc_final_05-daily"

class ChirpscFinal25Daily(SimpleGriddedDataset):
    dataset = "chirpsc_final_25-daily"

class ChirpscPrelim05Daily(SimpleGriddedDataset):
    dataset = "chirpsc_prelim_05-daily"

class Era5LandWindUHourly(Era5LandWind):
    dataset = "era5_land_wind_u-hourly"

class Era5LandWindVHourly(Era5LandWind):
    dataset = "era5_land_wind_v-hourly"

class Era5Wind100mUHourly(SimpleGriddedDataset):
    dataset = "era5_wind_100m_u-hourly"

class Era5Wind100mVHourly(SimpleGriddedDataset):
    dataset = "era5_wind_100m_v-hourly"
