# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1alpha1Transcript(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'accession_version': 'str',
        'cds': 'V1alpha1SeqRangeSet',
        'ensembl_transcript': 'str',
        'exons': 'V1alpha1SeqRangeSet',
        'genomic_locations': 'list[V1alpha1GenomicLocation]',
        'genomic_range': 'V1alpha1SeqRangeSet',
        'length': 'int',
        'name': 'str',
        'protein': 'V1alpha1Protein',
        'type': 'TranscriptTranscriptType'
    }

    attribute_map = {
        'accession_version': 'accession_version',
        'cds': 'cds',
        'ensembl_transcript': 'ensembl_transcript',
        'exons': 'exons',
        'genomic_locations': 'genomic_locations',
        'genomic_range': 'genomic_range',
        'length': 'length',
        'name': 'name',
        'protein': 'protein',
        'type': 'type'
    }

    def __init__(self, accession_version=None, cds=None, ensembl_transcript=None, exons=None, genomic_locations=None, genomic_range=None, length=None, name=None, protein=None, type=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1Transcript - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._accession_version = None
        self._cds = None
        self._ensembl_transcript = None
        self._exons = None
        self._genomic_locations = None
        self._genomic_range = None
        self._length = None
        self._name = None
        self._protein = None
        self._type = None
        self.discriminator = None

        if accession_version is not None:
            self.accession_version = accession_version
        if cds is not None:
            self.cds = cds
        if ensembl_transcript is not None:
            self.ensembl_transcript = ensembl_transcript
        if exons is not None:
            self.exons = exons
        if genomic_locations is not None:
            self.genomic_locations = genomic_locations
        if genomic_range is not None:
            self.genomic_range = genomic_range
        if length is not None:
            self.length = length
        if name is not None:
            self.name = name
        if protein is not None:
            self.protein = protein
        if type is not None:
            self.type = type

    @property
    def accession_version(self):
        """Gets the accession_version of this V1alpha1Transcript.  # noqa: E501


        :return: The accession_version of this V1alpha1Transcript.  # noqa: E501
        :rtype: str
        """
        return self._accession_version

    @accession_version.setter
    def accession_version(self, accession_version):
        """Sets the accession_version of this V1alpha1Transcript.


        :param accession_version: The accession_version of this V1alpha1Transcript.  # noqa: E501
        :type: str
        """

        self._accession_version = accession_version

    @property
    def cds(self):
        """Gets the cds of this V1alpha1Transcript.  # noqa: E501


        :return: The cds of this V1alpha1Transcript.  # noqa: E501
        :rtype: V1alpha1SeqRangeSet
        """
        return self._cds

    @cds.setter
    def cds(self, cds):
        """Sets the cds of this V1alpha1Transcript.


        :param cds: The cds of this V1alpha1Transcript.  # noqa: E501
        :type: V1alpha1SeqRangeSet
        """

        self._cds = cds

    @property
    def ensembl_transcript(self):
        """Gets the ensembl_transcript of this V1alpha1Transcript.  # noqa: E501


        :return: The ensembl_transcript of this V1alpha1Transcript.  # noqa: E501
        :rtype: str
        """
        return self._ensembl_transcript

    @ensembl_transcript.setter
    def ensembl_transcript(self, ensembl_transcript):
        """Sets the ensembl_transcript of this V1alpha1Transcript.


        :param ensembl_transcript: The ensembl_transcript of this V1alpha1Transcript.  # noqa: E501
        :type: str
        """

        self._ensembl_transcript = ensembl_transcript

    @property
    def exons(self):
        """Gets the exons of this V1alpha1Transcript.  # noqa: E501


        :return: The exons of this V1alpha1Transcript.  # noqa: E501
        :rtype: V1alpha1SeqRangeSet
        """
        return self._exons

    @exons.setter
    def exons(self, exons):
        """Sets the exons of this V1alpha1Transcript.


        :param exons: The exons of this V1alpha1Transcript.  # noqa: E501
        :type: V1alpha1SeqRangeSet
        """

        self._exons = exons

    @property
    def genomic_locations(self):
        """Gets the genomic_locations of this V1alpha1Transcript.  # noqa: E501


        :return: The genomic_locations of this V1alpha1Transcript.  # noqa: E501
        :rtype: list[V1alpha1GenomicLocation]
        """
        return self._genomic_locations

    @genomic_locations.setter
    def genomic_locations(self, genomic_locations):
        """Sets the genomic_locations of this V1alpha1Transcript.


        :param genomic_locations: The genomic_locations of this V1alpha1Transcript.  # noqa: E501
        :type: list[V1alpha1GenomicLocation]
        """

        self._genomic_locations = genomic_locations

    @property
    def genomic_range(self):
        """Gets the genomic_range of this V1alpha1Transcript.  # noqa: E501


        :return: The genomic_range of this V1alpha1Transcript.  # noqa: E501
        :rtype: V1alpha1SeqRangeSet
        """
        return self._genomic_range

    @genomic_range.setter
    def genomic_range(self, genomic_range):
        """Sets the genomic_range of this V1alpha1Transcript.


        :param genomic_range: The genomic_range of this V1alpha1Transcript.  # noqa: E501
        :type: V1alpha1SeqRangeSet
        """

        self._genomic_range = genomic_range

    @property
    def length(self):
        """Gets the length of this V1alpha1Transcript.  # noqa: E501


        :return: The length of this V1alpha1Transcript.  # noqa: E501
        :rtype: int
        """
        return self._length

    @length.setter
    def length(self, length):
        """Sets the length of this V1alpha1Transcript.


        :param length: The length of this V1alpha1Transcript.  # noqa: E501
        :type: int
        """

        self._length = length

    @property
    def name(self):
        """Gets the name of this V1alpha1Transcript.  # noqa: E501


        :return: The name of this V1alpha1Transcript.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this V1alpha1Transcript.


        :param name: The name of this V1alpha1Transcript.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def protein(self):
        """Gets the protein of this V1alpha1Transcript.  # noqa: E501


        :return: The protein of this V1alpha1Transcript.  # noqa: E501
        :rtype: V1alpha1Protein
        """
        return self._protein

    @protein.setter
    def protein(self, protein):
        """Sets the protein of this V1alpha1Transcript.


        :param protein: The protein of this V1alpha1Transcript.  # noqa: E501
        :type: V1alpha1Protein
        """

        self._protein = protein

    @property
    def type(self):
        """Gets the type of this V1alpha1Transcript.  # noqa: E501


        :return: The type of this V1alpha1Transcript.  # noqa: E501
        :rtype: TranscriptTranscriptType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this V1alpha1Transcript.


        :param type: The type of this V1alpha1Transcript.  # noqa: E501
        :type: TranscriptTranscriptType
        """

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1Transcript):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1Transcript):
            return True

        return self.to_dict() != other.to_dict()
