# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class Transaction(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'transaction_type': 'str',
        'transaction_id': 'str',
        'account_owner': 'str',
        'pending_transaction_id': 'str',
        'pending': 'bool',
        'payment_channel': 'str',
        'payment_meta': 'PaymentMeta',
        'name': 'str',
        'merchant_name': 'str',
        'location': 'Location',
        'authorized_date': 'str',
        'date': 'str',
        'category_id': 'str',
        'category': 'list[str]',
        'unofficial_currency_code': 'str',
        'iso_currency_code': 'str',
        'amount': 'float',
        'account_id': 'str',
        'transaction_code': 'TransactionCode'
    }

    attribute_map = {
        'transaction_type': 'transaction_type',
        'transaction_id': 'transaction_id',
        'account_owner': 'account_owner',
        'pending_transaction_id': 'pending_transaction_id',
        'pending': 'pending',
        'payment_channel': 'payment_channel',
        'payment_meta': 'payment_meta',
        'name': 'name',
        'merchant_name': 'merchant_name',
        'location': 'location',
        'authorized_date': 'authorized_date',
        'date': 'date',
        'category_id': 'category_id',
        'category': 'category',
        'unofficial_currency_code': 'unofficial_currency_code',
        'iso_currency_code': 'iso_currency_code',
        'amount': 'amount',
        'account_id': 'account_id',
        'transaction_code': 'transaction_code'
    }

    def __init__(self, transaction_type=None, transaction_id=None, account_owner=None, pending_transaction_id=None, pending=None, payment_channel=None, payment_meta=None, name=None, merchant_name=None, location=None, authorized_date=None, date=None, category_id=None, category=None, unofficial_currency_code=None, iso_currency_code=None, amount=None, account_id=None, transaction_code=None, local_vars_configuration=None):  # noqa: E501
        """Transaction - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._transaction_type = None
        self._transaction_id = None
        self._account_owner = None
        self._pending_transaction_id = None
        self._pending = None
        self._payment_channel = None
        self._payment_meta = None
        self._name = None
        self._merchant_name = None
        self._location = None
        self._authorized_date = None
        self._date = None
        self._category_id = None
        self._category = None
        self._unofficial_currency_code = None
        self._iso_currency_code = None
        self._amount = None
        self._account_id = None
        self._transaction_code = None
        self.discriminator = None

        if transaction_type is not None:
            self.transaction_type = transaction_type
        if transaction_id is not None:
            self.transaction_id = transaction_id
        self.account_owner = account_owner
        self.pending_transaction_id = pending_transaction_id
        if pending is not None:
            self.pending = pending
        if payment_channel is not None:
            self.payment_channel = payment_channel
        if payment_meta is not None:
            self.payment_meta = payment_meta
        if name is not None:
            self.name = name
        self.merchant_name = merchant_name
        if location is not None:
            self.location = location
        self.authorized_date = authorized_date
        if date is not None:
            self.date = date
        if category_id is not None:
            self.category_id = category_id
        self.category = category
        self.unofficial_currency_code = unofficial_currency_code
        self.iso_currency_code = iso_currency_code
        if amount is not None:
            self.amount = amount
        if account_id is not None:
            self.account_id = account_id
        self.transaction_code = transaction_code

    @property
    def transaction_type(self):
        """Gets the transaction_type of this Transaction.  # noqa: E501

        Please use the `payment_channel` field, `transaction_type` will be deprecated in the future.  `digital:` transactions that took place online.  `place:` transactions that were made at a physical location.  `special:` transactions that relate to banks, e.g. fees or deposits.  `unresolved:` transactions that do not fit into the other three types.   # noqa: E501

        :return: The transaction_type of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """Sets the transaction_type of this Transaction.

        Please use the `payment_channel` field, `transaction_type` will be deprecated in the future.  `digital:` transactions that took place online.  `place:` transactions that were made at a physical location.  `special:` transactions that relate to banks, e.g. fees or deposits.  `unresolved:` transactions that do not fit into the other three types.   # noqa: E501

        :param transaction_type: The transaction_type of this Transaction.  # noqa: E501
        :type transaction_type: str
        """
        allowed_values = ["digital", "place", "special", "unresolved"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and transaction_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `transaction_type` ({0}), must be one of {1}"  # noqa: E501
                .format(transaction_type, allowed_values)
            )

        self._transaction_type = transaction_type

    @property
    def transaction_id(self):
        """Gets the transaction_id of this Transaction.  # noqa: E501

        The unique ID of the transaction. Like all Plaid identifiers, the `transaction_id` is case sensitive.  # noqa: E501

        :return: The transaction_id of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this Transaction.

        The unique ID of the transaction. Like all Plaid identifiers, the `transaction_id` is case sensitive.  # noqa: E501

        :param transaction_id: The transaction_id of this Transaction.  # noqa: E501
        :type transaction_id: str
        """

        self._transaction_id = transaction_id

    @property
    def account_owner(self):
        """Gets the account_owner of this Transaction.  # noqa: E501

        The name of the account owner. This field is not typically populated and only relevant when dealing with sub-accounts.  # noqa: E501

        :return: The account_owner of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._account_owner

    @account_owner.setter
    def account_owner(self, account_owner):
        """Sets the account_owner of this Transaction.

        The name of the account owner. This field is not typically populated and only relevant when dealing with sub-accounts.  # noqa: E501

        :param account_owner: The account_owner of this Transaction.  # noqa: E501
        :type account_owner: str
        """

        self._account_owner = account_owner

    @property
    def pending_transaction_id(self):
        """Gets the pending_transaction_id of this Transaction.  # noqa: E501

        The ID of a posted transaction's associated pending transaction, where applicable.  # noqa: E501

        :return: The pending_transaction_id of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._pending_transaction_id

    @pending_transaction_id.setter
    def pending_transaction_id(self, pending_transaction_id):
        """Sets the pending_transaction_id of this Transaction.

        The ID of a posted transaction's associated pending transaction, where applicable.  # noqa: E501

        :param pending_transaction_id: The pending_transaction_id of this Transaction.  # noqa: E501
        :type pending_transaction_id: str
        """

        self._pending_transaction_id = pending_transaction_id

    @property
    def pending(self):
        """Gets the pending of this Transaction.  # noqa: E501

        When `true`, identifies the transaction as pending or unsettled. Pending transaction details (name, type, amount, category ID) may change before they are settled.  # noqa: E501

        :return: The pending of this Transaction.  # noqa: E501
        :rtype: bool
        """
        return self._pending

    @pending.setter
    def pending(self, pending):
        """Sets the pending of this Transaction.

        When `true`, identifies the transaction as pending or unsettled. Pending transaction details (name, type, amount, category ID) may change before they are settled.  # noqa: E501

        :param pending: The pending of this Transaction.  # noqa: E501
        :type pending: bool
        """

        self._pending = pending

    @property
    def payment_channel(self):
        """Gets the payment_channel of this Transaction.  # noqa: E501

        The channel used to make a payment. `online:` transactions that took place online.  `in store:` transactions that were made at a physical location.  `other:` transactions that relate to banks, e.g. fees or deposits.  This field replaces the `transaction_type` field.   # noqa: E501

        :return: The payment_channel of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._payment_channel

    @payment_channel.setter
    def payment_channel(self, payment_channel):
        """Sets the payment_channel of this Transaction.

        The channel used to make a payment. `online:` transactions that took place online.  `in store:` transactions that were made at a physical location.  `other:` transactions that relate to banks, e.g. fees or deposits.  This field replaces the `transaction_type` field.   # noqa: E501

        :param payment_channel: The payment_channel of this Transaction.  # noqa: E501
        :type payment_channel: str
        """
        allowed_values = ["online", "in store", "other"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and payment_channel not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `payment_channel` ({0}), must be one of {1}"  # noqa: E501
                .format(payment_channel, allowed_values)
            )

        self._payment_channel = payment_channel

    @property
    def payment_meta(self):
        """Gets the payment_meta of this Transaction.  # noqa: E501


        :return: The payment_meta of this Transaction.  # noqa: E501
        :rtype: PaymentMeta
        """
        return self._payment_meta

    @payment_meta.setter
    def payment_meta(self, payment_meta):
        """Sets the payment_meta of this Transaction.


        :param payment_meta: The payment_meta of this Transaction.  # noqa: E501
        :type payment_meta: PaymentMeta
        """

        self._payment_meta = payment_meta

    @property
    def name(self):
        """Gets the name of this Transaction.  # noqa: E501

        The merchant name or transaction description.  If the `transaction` object was returned by a Transactions endpoint such as `/transactions/get`, this field will always appear. If the `transaction` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.  # noqa: E501

        :return: The name of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Transaction.

        The merchant name or transaction description.  If the `transaction` object was returned by a Transactions endpoint such as `/transactions/get`, this field will always appear. If the `transaction` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.  # noqa: E501

        :param name: The name of this Transaction.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def merchant_name(self):
        """Gets the merchant_name of this Transaction.  # noqa: E501

        The merchant name, as extracted by Plaid from the `name` field.  # noqa: E501

        :return: The merchant_name of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._merchant_name

    @merchant_name.setter
    def merchant_name(self, merchant_name):
        """Sets the merchant_name of this Transaction.

        The merchant name, as extracted by Plaid from the `name` field.  # noqa: E501

        :param merchant_name: The merchant_name of this Transaction.  # noqa: E501
        :type merchant_name: str
        """

        self._merchant_name = merchant_name

    @property
    def location(self):
        """Gets the location of this Transaction.  # noqa: E501


        :return: The location of this Transaction.  # noqa: E501
        :rtype: Location
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this Transaction.


        :param location: The location of this Transaction.  # noqa: E501
        :type location: Location
        """

        self._location = location

    @property
    def authorized_date(self):
        """Gets the authorized_date of this Transaction.  # noqa: E501

        The date that the transaction was authorized. Dates are returned in an ISO 8601 format ( `YYYY-MM-DD` ).  # noqa: E501

        :return: The authorized_date of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._authorized_date

    @authorized_date.setter
    def authorized_date(self, authorized_date):
        """Sets the authorized_date of this Transaction.

        The date that the transaction was authorized. Dates are returned in an ISO 8601 format ( `YYYY-MM-DD` ).  # noqa: E501

        :param authorized_date: The authorized_date of this Transaction.  # noqa: E501
        :type authorized_date: str
        """

        self._authorized_date = authorized_date

    @property
    def date(self):
        """Gets the date of this Transaction.  # noqa: E501

        For pending transactions, the date that the transaction occurred; for posted transactions, the date that the transaction posted. Both dates are returned in an ISO 8601 format ( `YYYY-MM-DD` ).  # noqa: E501

        :return: The date of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._date

    @date.setter
    def date(self, date):
        """Sets the date of this Transaction.

        For pending transactions, the date that the transaction occurred; for posted transactions, the date that the transaction posted. Both dates are returned in an ISO 8601 format ( `YYYY-MM-DD` ).  # noqa: E501

        :param date: The date of this Transaction.  # noqa: E501
        :type date: str
        """

        self._date = date

    @property
    def category_id(self):
        """Gets the category_id of this Transaction.  # noqa: E501

        The ID of the category to which this transaction belongs. See [Categories](https://plaid.com/docs/#category-overview).  If the `transaction` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.  # noqa: E501

        :return: The category_id of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this Transaction.

        The ID of the category to which this transaction belongs. See [Categories](https://plaid.com/docs/#category-overview).  If the `transaction` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.  # noqa: E501

        :param category_id: The category_id of this Transaction.  # noqa: E501
        :type category_id: str
        """

        self._category_id = category_id

    @property
    def category(self):
        """Gets the category of this Transaction.  # noqa: E501

        A hierarchical array of the categories to which this transaction belongs. See [Categories](https://plaid.com/docs/#category-overview).  If the `transaction` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.  # noqa: E501

        :return: The category of this Transaction.  # noqa: E501
        :rtype: list[str]
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this Transaction.

        A hierarchical array of the categories to which this transaction belongs. See [Categories](https://plaid.com/docs/#category-overview).  If the `transaction` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.  # noqa: E501

        :param category: The category of this Transaction.  # noqa: E501
        :type category: list[str]
        """

        self._category = category

    @property
    def unofficial_currency_code(self):
        """Gets the unofficial_currency_code of this Transaction.  # noqa: E501

        The unofficial currency code associated with the transaction. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.  # noqa: E501

        :return: The unofficial_currency_code of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._unofficial_currency_code

    @unofficial_currency_code.setter
    def unofficial_currency_code(self, unofficial_currency_code):
        """Sets the unofficial_currency_code of this Transaction.

        The unofficial currency code associated with the transaction. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.  # noqa: E501

        :param unofficial_currency_code: The unofficial_currency_code of this Transaction.  # noqa: E501
        :type unofficial_currency_code: str
        """

        self._unofficial_currency_code = unofficial_currency_code

    @property
    def iso_currency_code(self):
        """Gets the iso_currency_code of this Transaction.  # noqa: E501

        The ISO-4217 currency code of the transaction. Always `null` if `unofficial_currency_code` is non-null.  # noqa: E501

        :return: The iso_currency_code of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._iso_currency_code

    @iso_currency_code.setter
    def iso_currency_code(self, iso_currency_code):
        """Sets the iso_currency_code of this Transaction.

        The ISO-4217 currency code of the transaction. Always `null` if `unofficial_currency_code` is non-null.  # noqa: E501

        :param iso_currency_code: The iso_currency_code of this Transaction.  # noqa: E501
        :type iso_currency_code: str
        """

        self._iso_currency_code = iso_currency_code

    @property
    def amount(self):
        """Gets the amount of this Transaction.  # noqa: E501

        The settled value of the transaction, denominated in the account's currency, as stated in `iso_currency_code` or `unofficial_currency_code`. Positive values when money moves out of the account; negative values when money moves in. For example, debit card purchases are positive; credit card payments, direct deposits, and refunds are negative.  # noqa: E501

        :return: The amount of this Transaction.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Transaction.

        The settled value of the transaction, denominated in the account's currency, as stated in `iso_currency_code` or `unofficial_currency_code`. Positive values when money moves out of the account; negative values when money moves in. For example, debit card purchases are positive; credit card payments, direct deposits, and refunds are negative.  # noqa: E501

        :param amount: The amount of this Transaction.  # noqa: E501
        :type amount: float
        """

        self._amount = amount

    @property
    def account_id(self):
        """Gets the account_id of this Transaction.  # noqa: E501

        The ID of the account in which this transaction occurred.  # noqa: E501

        :return: The account_id of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this Transaction.

        The ID of the account in which this transaction occurred.  # noqa: E501

        :param account_id: The account_id of this Transaction.  # noqa: E501
        :type account_id: str
        """

        self._account_id = account_id

    @property
    def transaction_code(self):
        """Gets the transaction_code of this Transaction.  # noqa: E501


        :return: The transaction_code of this Transaction.  # noqa: E501
        :rtype: TransactionCode
        """
        return self._transaction_code

    @transaction_code.setter
    def transaction_code(self, transaction_code):
        """Sets the transaction_code of this Transaction.


        :param transaction_code: The transaction_code of this Transaction.  # noqa: E501
        :type transaction_code: TransactionCode
        """

        self._transaction_code = transaction_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Transaction):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Transaction):
            return True

        return self.to_dict() != other.to_dict()
