# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class PaymentMeta(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'reference_number': 'str',
        'ppd_id': 'str',
        'payee': 'str',
        'by_order_of': 'str',
        'payer': 'str',
        'payment_method': 'str',
        'payment_processor': 'str',
        'reason': 'str'
    }

    attribute_map = {
        'reference_number': 'reference_number',
        'ppd_id': 'ppd_id',
        'payee': 'payee',
        'by_order_of': 'by_order_of',
        'payer': 'payer',
        'payment_method': 'payment_method',
        'payment_processor': 'payment_processor',
        'reason': 'reason'
    }

    def __init__(self, reference_number=None, ppd_id=None, payee=None, by_order_of=None, payer=None, payment_method=None, payment_processor=None, reason=None, local_vars_configuration=None):  # noqa: E501
        """PaymentMeta - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._reference_number = None
        self._ppd_id = None
        self._payee = None
        self._by_order_of = None
        self._payer = None
        self._payment_method = None
        self._payment_processor = None
        self._reason = None
        self.discriminator = None

        self.reference_number = reference_number
        self.ppd_id = ppd_id
        self.payee = payee
        self.by_order_of = by_order_of
        self.payer = payer
        self.payment_method = payment_method
        self.payment_processor = payment_processor
        self.reason = reason

    @property
    def reference_number(self):
        """Gets the reference_number of this PaymentMeta.  # noqa: E501

        The transaction reference number supplied by the financial institution.  # noqa: E501

        :return: The reference_number of this PaymentMeta.  # noqa: E501
        :rtype: str
        """
        return self._reference_number

    @reference_number.setter
    def reference_number(self, reference_number):
        """Sets the reference_number of this PaymentMeta.

        The transaction reference number supplied by the financial institution.  # noqa: E501

        :param reference_number: The reference_number of this PaymentMeta.  # noqa: E501
        :type reference_number: str
        """

        self._reference_number = reference_number

    @property
    def ppd_id(self):
        """Gets the ppd_id of this PaymentMeta.  # noqa: E501

        The ACH PPD ID for the payer.  # noqa: E501

        :return: The ppd_id of this PaymentMeta.  # noqa: E501
        :rtype: str
        """
        return self._ppd_id

    @ppd_id.setter
    def ppd_id(self, ppd_id):
        """Sets the ppd_id of this PaymentMeta.

        The ACH PPD ID for the payer.  # noqa: E501

        :param ppd_id: The ppd_id of this PaymentMeta.  # noqa: E501
        :type ppd_id: str
        """

        self._ppd_id = ppd_id

    @property
    def payee(self):
        """Gets the payee of this PaymentMeta.  # noqa: E501

        For transfers, the party that is receiving the transaction.  # noqa: E501

        :return: The payee of this PaymentMeta.  # noqa: E501
        :rtype: str
        """
        return self._payee

    @payee.setter
    def payee(self, payee):
        """Sets the payee of this PaymentMeta.

        For transfers, the party that is receiving the transaction.  # noqa: E501

        :param payee: The payee of this PaymentMeta.  # noqa: E501
        :type payee: str
        """

        self._payee = payee

    @property
    def by_order_of(self):
        """Gets the by_order_of of this PaymentMeta.  # noqa: E501

        The party initiating a wire transfer. Will be `null` if the transaction is not a wire transfer.  # noqa: E501

        :return: The by_order_of of this PaymentMeta.  # noqa: E501
        :rtype: str
        """
        return self._by_order_of

    @by_order_of.setter
    def by_order_of(self, by_order_of):
        """Sets the by_order_of of this PaymentMeta.

        The party initiating a wire transfer. Will be `null` if the transaction is not a wire transfer.  # noqa: E501

        :param by_order_of: The by_order_of of this PaymentMeta.  # noqa: E501
        :type by_order_of: str
        """

        self._by_order_of = by_order_of

    @property
    def payer(self):
        """Gets the payer of this PaymentMeta.  # noqa: E501

        For transfers, the party that is paying the transaction.  # noqa: E501

        :return: The payer of this PaymentMeta.  # noqa: E501
        :rtype: str
        """
        return self._payer

    @payer.setter
    def payer(self, payer):
        """Sets the payer of this PaymentMeta.

        For transfers, the party that is paying the transaction.  # noqa: E501

        :param payer: The payer of this PaymentMeta.  # noqa: E501
        :type payer: str
        """

        self._payer = payer

    @property
    def payment_method(self):
        """Gets the payment_method of this PaymentMeta.  # noqa: E501

        The type of transfer, e.g. 'ACH'  # noqa: E501

        :return: The payment_method of this PaymentMeta.  # noqa: E501
        :rtype: str
        """
        return self._payment_method

    @payment_method.setter
    def payment_method(self, payment_method):
        """Sets the payment_method of this PaymentMeta.

        The type of transfer, e.g. 'ACH'  # noqa: E501

        :param payment_method: The payment_method of this PaymentMeta.  # noqa: E501
        :type payment_method: str
        """

        self._payment_method = payment_method

    @property
    def payment_processor(self):
        """Gets the payment_processor of this PaymentMeta.  # noqa: E501

        The name of the payment processor  # noqa: E501

        :return: The payment_processor of this PaymentMeta.  # noqa: E501
        :rtype: str
        """
        return self._payment_processor

    @payment_processor.setter
    def payment_processor(self, payment_processor):
        """Sets the payment_processor of this PaymentMeta.

        The name of the payment processor  # noqa: E501

        :param payment_processor: The payment_processor of this PaymentMeta.  # noqa: E501
        :type payment_processor: str
        """

        self._payment_processor = payment_processor

    @property
    def reason(self):
        """Gets the reason of this PaymentMeta.  # noqa: E501

        The payer-supplied description of the transfer.  # noqa: E501

        :return: The reason of this PaymentMeta.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this PaymentMeta.

        The payer-supplied description of the transfer.  # noqa: E501

        :param reason: The reason of this PaymentMeta.  # noqa: E501
        :type reason: str
        """

        self._reason = reason

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaymentMeta):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PaymentMeta):
            return True

        return self.to_dict() != other.to_dict()
