# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class Category(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'category_id': 'str',
        'group': 'str',
        'hierarchy': 'list[str]'
    }

    attribute_map = {
        'category_id': 'category_id',
        'group': 'group',
        'hierarchy': 'hierarchy'
    }

    def __init__(self, category_id=None, group=None, hierarchy=None, local_vars_configuration=None):  # noqa: E501
        """Category - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._category_id = None
        self._group = None
        self._hierarchy = None
        self.discriminator = None

        if category_id is not None:
            self.category_id = category_id
        if group is not None:
            self.group = group
        if hierarchy is not None:
            self.hierarchy = hierarchy

    @property
    def category_id(self):
        """Gets the category_id of this Category.  # noqa: E501

        An identifying number for the category. `category_id` is a Plaid-specific identifier and does not necessarily correspond to merchant category codes.  # noqa: E501

        :return: The category_id of this Category.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this Category.

        An identifying number for the category. `category_id` is a Plaid-specific identifier and does not necessarily correspond to merchant category codes.  # noqa: E501

        :param category_id: The category_id of this Category.  # noqa: E501
        :type category_id: str
        """

        self._category_id = category_id

    @property
    def group(self):
        """Gets the group of this Category.  # noqa: E501

        `place` for physical transactions or `special` for other transactions such as bank charges.  # noqa: E501

        :return: The group of this Category.  # noqa: E501
        :rtype: str
        """
        return self._group

    @group.setter
    def group(self, group):
        """Sets the group of this Category.

        `place` for physical transactions or `special` for other transactions such as bank charges.  # noqa: E501

        :param group: The group of this Category.  # noqa: E501
        :type group: str
        """

        self._group = group

    @property
    def hierarchy(self):
        """Gets the hierarchy of this Category.  # noqa: E501

        A hierarchical array of the categories to which this `category_id` belongs.  # noqa: E501

        :return: The hierarchy of this Category.  # noqa: E501
        :rtype: list[str]
        """
        return self._hierarchy

    @hierarchy.setter
    def hierarchy(self, hierarchy):
        """Sets the hierarchy of this Category.

        A hierarchical array of the categories to which this `category_id` belongs.  # noqa: E501

        :param hierarchy: The hierarchy of this Category.  # noqa: E501
        :type hierarchy: list[str]
        """

        self._hierarchy = hierarchy

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Category):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Category):
            return True

        return self.to_dict() != other.to_dict()
