"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualGatewayListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Represents the properties needed to define listeners for a VirtualGateway.
 *
 * @experimental
 */
class VirtualGatewayListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP, options.healthCheck, options.port, options.tls, options.connectionPool);
    }
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http2(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP2, options.healthCheck, options.port, options.tls, options.connectionPool);
    }
    /**
     * (experimental) Returns a GRPC Listener for a VirtualGateway.
     *
     * @experimental
     */
    static grpc(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.GRPC, options.healthCheck, options.port, options.tls, options.connectionPool);
    }
}
exports.VirtualGatewayListener = VirtualGatewayListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualGatewayListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualGatewayListener", version: "1.109.0" };
/**
 * Represents the properties needed to define an HTTP Listener for a VirtualGateway
 */
class VirtualGatewayListenerImpl extends VirtualGatewayListener {
    constructor(protocol, healthCheck, port = 8080, tls, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.port = port;
        this.tls = tls;
        this.connectionPool = connectionPool;
    }
    /**
     * Called when the GatewayListener type is initialized. Can be used to enforce
     * mutual exclusivity
     */
    bind(scope) {
        var _b;
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: (_b = this.healthCheck) === null || _b === void 0 ? void 0 : _b.bind(scope, { defaultPort: this.port }).virtualGatewayHealthCheck,
                tls: renderTls(scope, this.tls),
                connectionPool: this.connectionPool ? renderConnectionPool(this.connectionPool, this.protocol) : undefined,
            },
        };
    }
}
/**
 * Renders the TLS config for a listener
 */
function renderTls(scope, tls) {
    return tls
        ? {
            certificate: tls.certificate.bind(scope).tlsCertificate,
            mode: tls.mode,
        }
        : undefined;
}
function renderConnectionPool(connectionPool, listenerProtocol) {
    return ({
        [listenerProtocol]: {
            maxRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxRequests) !== undefined ? connectionPool.maxRequests : undefined,
            maxConnections: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxConnections) !== undefined ? connectionPool.maxConnections : undefined,
            maxPendingRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxPendingRequests) !== undefined ? connectionPool.maxPendingRequests : undefined,
        },
    });
}
//# sourceMappingURL=data:application/json;base64,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