import * as acmpca from '@aws-cdk/aws-acmpca';
import { CfnVirtualGateway, CfnVirtualNode } from './appmesh.generated';
import { Construct } from '@aws-cdk/core';
/**
 * (experimental) Represents the properties needed to define TLS validation context.
 *
 * @experimental
 */
export interface TlsValidation {
    /**
     * (experimental) Reference to where to retrieve the trust chain.
     *
     * @experimental
     */
    readonly trust: TlsValidationTrust;
}
/**
 * (experimental) All Properties for TLS Validations for both Client Policy and Listener.
 *
 * @experimental
 */
export interface TlsValidationTrustConfig {
    /**
     * (experimental) VirtualNode CFN configuration for client policy's TLS Validation.
     *
     * @experimental
     */
    readonly virtualNodeClientTlsValidationTrust: CfnVirtualNode.TlsValidationContextTrustProperty;
    /**
     * (experimental) VirtualGateway CFN configuration for client policy's TLS Validation.
     *
     * @experimental
     */
    readonly virtualGatewayClientTlsValidationTrust: CfnVirtualGateway.VirtualGatewayTlsValidationContextTrustProperty;
}
/**
 * (experimental) ACM Trust Properties.
 *
 * @experimental
 */
export interface TlsValidationAcmTrustOptions {
    /**
     * (experimental) Contains information for your private certificate authority.
     *
     * @experimental
     */
    readonly certificateAuthorities: acmpca.ICertificateAuthority[];
}
/**
 * (experimental) File Trust Properties.
 *
 * @experimental
 */
export interface TlsValidationFileTrustOptions {
    /**
     * (experimental) Path to the Certificate Chain file on the file system where the Envoy is deployed.
     *
     * @experimental
     */
    readonly certificateChain: string;
}
/**
 * (experimental) Defines the TLS validation context trust.
 *
 * @experimental
 */
export declare abstract class TlsValidationTrust {
    /**
     * (experimental) Tells envoy where to fetch the validation context from.
     *
     * @experimental
     */
    static file(props: TlsValidationFileTrustOptions): TlsValidationTrust;
    /**
     * (experimental) TLS validation context trust for ACM Private Certificate Authority (CA).
     *
     * @experimental
     */
    static acm(props: TlsValidationAcmTrustOptions): TlsValidationTrust;
    /**
     * (experimental) Returns Trust context based on trust type.
     *
     * @experimental
     */
    abstract bind(scope: Construct): TlsValidationTrustConfig;
}
