"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TlsCertificate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Represents a TLS certificate.
 *
 * @experimental
 */
class TlsCertificate {
    /**
     * (experimental) Returns an File TLS Certificate.
     *
     * @experimental
     */
    static file(props) {
        return new FileTlsCertificate(props);
    }
    /**
     * (experimental) Returns an ACM TLS Certificate.
     *
     * @experimental
     */
    static acm(props) {
        return new AcmTlsCertificate(props);
    }
}
exports.TlsCertificate = TlsCertificate;
_a = JSII_RTTI_SYMBOL_1;
TlsCertificate[_a] = { fqn: "@aws-cdk/aws-appmesh.TlsCertificate", version: "1.109.0" };
/**
 * Represents a ACM provided TLS certificate
 */
class AcmTlsCertificate extends TlsCertificate {
    constructor(props) {
        super();
        this.acmCertificate = props.certificate;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                acm: {
                    certificateArn: this.acmCertificate.certificateArn,
                },
            },
        };
    }
}
/**
 * Represents a file provided TLS certificate
 */
class FileTlsCertificate extends TlsCertificate {
    constructor(props) {
        super();
        this.certificateChain = props.certificateChainPath;
        this.privateKey = props.privateKeyPath;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                file: {
                    certificateChain: this.certificateChain,
                    privateKey: this.privateKey,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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