import * as acm from '@aws-cdk/aws-certificatemanager';
import { CfnVirtualNode } from './appmesh.generated';
import { Construct } from '@aws-cdk/core';
/**
 * (experimental) A wrapper for the tls config returned by {@link TlsCertificate.bind}.
 *
 * @experimental
 */
export interface TlsCertificateConfig {
    /**
     * (experimental) The CFN shape for a TLS certificate.
     *
     * @experimental
     */
    readonly tlsCertificate: CfnVirtualNode.ListenerTlsCertificateProperty;
}
/**
 * (experimental) ACM Certificate Properties.
 *
 * @experimental
 */
export interface AcmCertificateOptions {
    /**
     * (experimental) The ACM certificate.
     *
     * @experimental
     */
    readonly certificate: acm.ICertificate;
}
/**
 * (experimental) File Certificate Properties.
 *
 * @experimental
 */
export interface FileCertificateOptions {
    /**
     * (experimental) The file path of the certificate chain file.
     *
     * @experimental
     */
    readonly certificateChainPath: string;
    /**
     * (experimental) The file path of the private key file.
     *
     * @experimental
     */
    readonly privateKeyPath: string;
}
/**
 * (experimental) Represents a TLS certificate.
 *
 * @experimental
 */
export declare abstract class TlsCertificate {
    /**
     * (experimental) Returns an File TLS Certificate.
     *
     * @experimental
     */
    static file(props: FileCertificateOptions): TlsCertificate;
    /**
     * (experimental) Returns an ACM TLS Certificate.
     *
     * @experimental
     */
    static acm(props: AcmCertificateOptions): TlsCertificate;
    /**
     * (experimental) Returns TLS certificate based provider.
     *
     * @experimental
     */
    abstract bind(_scope: Construct): TlsCertificateConfig;
}
