"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRouteSpec = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Used to generate specs with different protocols for a GatewayRoute.
 *
 * @experimental
 */
class GatewayRouteSpec {
    /**
     * (experimental) Creates an HTTP Based GatewayRoute.
     *
     * @param options - no http gateway route.
     * @experimental
     */
    static http(options) {
        return new HttpGatewayRouteSpec(options, shared_interfaces_1.Protocol.HTTP);
    }
    /**
     * (experimental) Creates an HTTP2 Based GatewayRoute.
     *
     * @param options - no http2 gateway route.
     * @experimental
     */
    static http2(options) {
        return new HttpGatewayRouteSpec(options, shared_interfaces_1.Protocol.HTTP2);
    }
    /**
     * (experimental) Creates an GRPC Based GatewayRoute.
     *
     * @param options - no grpc gateway route.
     * @experimental
     */
    static grpc(options) {
        return new GrpcGatewayRouteSpec(options);
    }
}
exports.GatewayRouteSpec = GatewayRouteSpec;
_a = JSII_RTTI_SYMBOL_1;
GatewayRouteSpec[_a] = { fqn: "@aws-cdk/aws-appmesh.GatewayRouteSpec", version: "1.109.0" };
class HttpGatewayRouteSpec extends GatewayRouteSpec {
    constructor(options, protocol) {
        super();
        this.routeTarget = options.routeTarget;
        this.routeType = protocol;
        this.match = options.match;
    }
    bind(_scope) {
        const prefixPath = this.match ? this.match.prefixPath : '/';
        if (prefixPath[0] != '/') {
            throw new Error(`Prefix Path must start with \'/\', got: ${prefixPath}`);
        }
        const httpConfig = {
            match: {
                prefix: prefixPath,
            },
            action: {
                target: {
                    virtualService: {
                        virtualServiceName: this.routeTarget.virtualServiceName,
                    },
                },
            },
        };
        return {
            httpSpecConfig: this.routeType === shared_interfaces_1.Protocol.HTTP ? httpConfig : undefined,
            http2SpecConfig: this.routeType === shared_interfaces_1.Protocol.HTTP2 ? httpConfig : undefined,
        };
    }
}
class GrpcGatewayRouteSpec extends GatewayRouteSpec {
    constructor(options) {
        super();
        this.match = options.match;
        this.routeTarget = options.routeTarget;
    }
    bind(_scope) {
        return {
            grpcSpecConfig: {
                action: {
                    target: {
                        virtualService: {
                            virtualServiceName: this.routeTarget.virtualServiceName,
                        },
                    },
                },
                match: {
                    serviceName: this.match.serviceName,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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