"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnAgent = exports.toJson_CfnAgentPropsVpcConfiguration = exports.toJson_CfnAgentProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnAgentProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnAgentProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ClusterID': obj.clusterId,
        'KubeConfig': obj.kubeConfig,
        'RoleArn': obj.roleArn,
        'Namespace': obj.namespace,
        'Name': obj.name,
        'Values': obj.values,
        'ValueYaml': obj.valueYaml,
        'Version': obj.version,
        'ValueOverrideURL': obj.valueOverrideUrl,
        'TimeOut': obj.timeOut,
        'VPCConfiguration': toJson_CfnAgentPropsVpcConfiguration(obj.vpcConfiguration),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnAgentProps = toJson_CfnAgentProps;
/**
 * Converts an object of type 'CfnAgentPropsVpcConfiguration' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnAgentPropsVpcConfiguration(obj) {
    var _b, _c;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'SecurityGroupIds': (_b = obj.securityGroupIds) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'SubnetIds': (_c = obj.subnetIds) === null || _c === void 0 ? void 0 : _c.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnAgentPropsVpcConfiguration = toJson_CfnAgentPropsVpcConfiguration;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Sysdig::Helm::Agent`
 *
 * @cloudformationResource Sysdig::Helm::Agent
 * @stability external
 * @link https://github.com/sysdiglabs/cloudformation-resource-providers.git
 */
class CfnAgent extends cdk.CfnResource {
    /**
     * Create a new `Sysdig::Helm::Agent`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAgent.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnAgentProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('ID'));
    }
}
exports.CfnAgent = CfnAgent;
_a = JSII_RTTI_SYMBOL_1;
CfnAgent[_a] = { fqn: "@cdk-cloudformation/sysdig-helm-agent.CfnAgent", version: "1.8.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnAgent.CFN_RESOURCE_TYPE_NAME = "Sysdig::Helm::Agent";
//# sourceMappingURL=data:application/json;base64,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