# -*- coding: utf-8 -*-
"""
    pip_services3_commons.data.IStringIdentifiable
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    Interface for identifiable data objects
    
    :copyright: Conceptual Vision Consulting LLC 2018-2019, see AUTHORS for more details.
    :license: MIT, see LICENSE for more details.
"""

from .IIdentifiable import IIdentifiable

class IStringIdentifiable(IIdentifiable):
    """
    Interface for data objects that can be uniquely identifed by a string id.

    The interface extends [[IIdentifiable]] to hardcode id type to string.

    It is a common pattern to use a string GUID as the id, generated by [[IdGenerator]].

    Example:
        class MyData(IStringIdentifiable):
            id = None
            ...
    """
    # id = None
    pass
