# xmds2-tools
Tools to read .hdf5 and .xsil files generated using [XMDS2](http://xmds.org) and functions to implement Bessel transformations and Bessel quadrature integration

These tools were built to work with the output files generated by XMDS2 but can be used for other purposes.

The function `reader.ReadH5` reads any [HDF5 file](https://www.hdfgroup.org/solutions/hdf5/) and returns the contents as a Python dictionary. Likewise, `reader.WriteH5` takes a Python dictionary and saves the contents as an HDF5 file.

XMDS2 simulations generate a text file with extension `.xsil` as well as the HDF5 data. The function 'reader.ParseXSIL' reads the XML data from the text file and returns a dictionary with simulation parameters including global variables, command line variables, and variables derived from global and command line variables. If the Bessel transform is used on an axis a variable called `"axis name"Outer` is added where `"axis name"` is the name of the axis defined in XMDS and the value of the variable is the outer radius of the interval defining the grid.

The `bessel.py` module is based on [Numerical calculation of dipolar-quantum-droplet stationary states](https://journals.aps.org/prresearch/abstract/10.1103/PhysRevResearch.3.013283) and implements Bessel quadrature integration and numerical radial derivative in cylindrical coordinates.

## Examples
The `examples/` folder contains Python scripts demonstrating the use of the `reader` and `bessel` modules to analyse the output of some of the XMDS2 examples. The `bessel` module is also used for quadrature integration and compared to the trapezium method.

None of the examples or any of the XMDS2 source code is reproduced here and the user is instead refered to the [XMDS2 website](http://xmds.org')

* `examples/groundstate_workedexamples.py` corresponds to the continuous renormalisation groundstate example.
* `examples/bc_groundstate.py` corresponds to the imaginary time evolution example using DCT and Bessel transform in the XMDS directory `examples/bessel_cosine_groundstate.xmds`
* `examples/bessel_integration.py` compares convergence when integrating using the trapezium method and by Bessel quadrature

## Installation

### Install from PyPI

* `python -m pip install xmds2tools`

### Build from source
* `python -m pip install --upgrade pip setuptools`
* `python -m pip install build`
* `git clone https://github.com/CSChisholm/xmds2-tools`
* `cd xmds2-tools`
* `python -m build`

## Acknowledgements

These functions were written and tested during the PhD project of C. S. Chisholm at [ICFO - The Institute of Photonic Sciences](https://www.icfo.eu/) under the supervision of Prof. Dr. Leticia Tarruell and with support from Dr. Ramón Ramos.

Thanks to Prof. P. B. Blakie, Dr. M. Johnsson, and Prof. M. J. Davis for advice.

## References

1. G. R. Dennis, J. J. Hope, and M. T. Johnsson, [*XMDS2: Fast, scalable simulation of coupled stochastic partial differential equations*](https://doi.org/10.1016/j.cpc.2012.08.016). Compuer Physics Communications **184**(1), 201-208 (2013).
2. A.-C. Lee, D. Baillie, and P. B. Blakie, [*Numerical calculation of dipolar-quantum-droplet stationary states*](https://doi.org/10.1103/PhysRevResearch.3.013283). Physical Review Research **3**, 013283 (2021).
