# Module `ida-is`

Shortcut functions for quickly checking or manipulating an address or function's flags. 

## Flag checks

### Usage:
   
    from ida_is import *

    if HasAnyName(0x140000000) or HasAnyName('__ImageBase') or \
            HasAnyName(ida_funcs.get_func(0x140000000)):
        # ...

    # Effectively identical to:
    #     return idc.get_full_flags(_get_ea_by_any(ea)) & idc.FF_ANYNAME != 0
     
    
#### Functions

     def HasAnyName(ea)
     def HasLabel(ea)
     def HasName(ea)
     def HasUserName(ea)
     def IsAlign(ea)
     def IsBin0(ea)
     def IsBin1(ea)
     def IsByte(ea)
     def IsChar0(ea)
     def IsChar1(ea)
     def IsChunkHead(ea)
     def IsChunkStart(ea)
     def IsCode_(ea)
     def IsData(ea)
     def IsDec0(ea)
     def IsDec1(ea)
     def IsDefarg0(ea)
     def IsDefarg1(ea)
     def IsDouble(ea)
     def IsDword(ea)
     def IsEnum0(ea)
     def IsEnum1(ea)
     def IsExtern(ea)
     def IsExtra(ea)
     def IsFloat(ea)
     def IsFlow(ea)
     
     def IsFunc_(ea)
     def IsHead(ea)
     def IsHex0(ea)
     def IsHex1(ea)
     def IsManual0(ea)
     def IsManual1(ea)
     def IsOct0(ea)
     def IsOct1(ea)
     def IsOff0(ea)
     def IsOff1(ea)
     def IsOword(ea)
     def IsPackReal(ea)
     def IsQword(ea)
     def IsRef(ea)
     def IsSeg0(ea)
     def IsSeg1(ea)
     def IsStkvar0(ea)
     def IsStkvar1(ea)
     def IsStrlit(ea)
     def IsStroff0(ea)
     def IsStroff1(ea)
     def IsStruct(ea)
     def IsTail(ea)
     def IsTbyte(ea)
     def IsUnknown(ea)
     def IsWord(ea)

## Function Flag Checking

     def IsFuncBottomBP(ea)
     def IsFuncEntry(ea)
     def IsFuncFar(ea)
     def IsFuncFrame(ea)
     def IsFuncFuzzySp(ea)
     def IsFuncHead(ea)
     def IsFuncHidden(ea)
     def IsFuncLib(ea)
     def IsFuncLumina(ea)
     def IsFuncNoRet(ea)
     def IsFuncNoRetPending(ea)
     def IsFuncPrologOk(ea)
     def IsFuncPurgedOk(ea)
     def IsFuncSpReady(ea)
     def IsFuncStart(ea)
     def IsFuncStaticDef(ea)
     def IsFuncTail(ea)
     def IsFuncThunk(ea)
     def IsFuncUserFar(ea)


## Function Flags Setting

### Usage:

    from ida_is import *

    SetFuncFar(0x140000000, true), SetFuncFar('__ImageBase', true), \
            SetFuncFar(ida_funcs.get_func(0x140000000), true)

    # Effectively:
    #     def SetFuncFar(ea, v):
    #         if v:
    #             _SetFuncFlags(_get_ea_by_any(ea), lambda x: x | ida_funcs.FUNC_FAR)
    #         else:
    #             _SetFuncFlags(_get_ea_by_any(ea), lambda x: x & ida_funcs.FUNC_FAR)
     
    
#### Functions

     def SetFuncBottomBP(ea, v)
     def SetFuncFar(ea, v)
     def SetFuncFrame(ea, v)
     def SetFuncFuzzySp(ea, v)
     def SetFuncHidden(ea, v)
     def SetFuncLib(ea, v)
     def SetFuncLumina(ea, v)
     def SetFuncNoRet(ea, v)
     def SetFuncNoRetPending(ea, v)
     def SetFuncPrologOk(ea, v)
     def SetFuncPurgedOk(ea, v)
     def SetFuncSpReady(ea, v)
     def SetFuncStaticDef(ea, v)
     def SetFuncTail(ea, v)
     def SetFuncThunk(ea, v)
     def SetFuncUserFar(ea, v)

-----
Generated by *pdoc* 0.10.0 (<https://pdoc3.github.io>).
