
import os
from appdirs import user_config_dir

CONFIG_DIR = user_config_dir("yurolabs")
CONFIG_FILE = os.path.join(CONFIG_DIR, "config")
URL_FILE = os.path.join(CONFIG_DIR, "base_url")

def save_key(key: str):
    os.makedirs(CONFIG_DIR, exist_ok=True)
    with open(CONFIG_FILE, "w") as f:
        f.write(key)

def load_key():
    with open(CONFIG_FILE) as f:
        return f.read().strip()


def save_base_url(url: str):
    os.makedirs(CONFIG_DIR, exist_ok=True)
    with open(URL_FILE, "w") as f:
        f.write(url.strip())


def load_base_url() -> str:
    if os.path.exists(URL_FILE):
        with open(URL_FILE) as f:
            return f.read().strip()
    return os.environ.get("YURO_BASE_URL", "http://localhost:8000/yuro")
