# coding: utf-8

"""
    Collibra Search API

    <p>The Search API allows you to create your own integration with the Collibra Search Engine.<br /> Find your data!</p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_search.configuration import Configuration


class SearchResultResource(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'resource_type': 'str',
        'id': 'str',
        'created_by': 'str',
        'created_on': 'int',
        'last_modified_on': 'int',
        'name': 'str'
    }

    attribute_map = {
        'resource_type': 'resourceType',
        'id': 'id',
        'created_by': 'createdBy',
        'created_on': 'createdOn',
        'last_modified_on': 'lastModifiedOn',
        'name': 'name'
    }

    discriminator_value_class_map = {
        'SearchUserResultResource': 'SearchUserResultResource',
        'SearchDomainResultResource': 'SearchDomainResultResource',
        'SearchUserGroupResultResource': 'SearchUserGroupResultResource',
        'SearchCommunityResultResource': 'SearchCommunityResultResource',
        'SearchAssetResultResource': 'SearchAssetResultResource'
    }

    def __init__(self, resource_type=None, id=None, created_by=None, created_on=None, last_modified_on=None, name=None, local_vars_configuration=None):  # noqa: E501
        """SearchResultResource - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._resource_type = None
        self._id = None
        self._created_by = None
        self._created_on = None
        self._last_modified_on = None
        self._name = None
        self.discriminator = 'resource_type'

        if resource_type is not None:
            self.resource_type = resource_type
        if id is not None:
            self.id = id
        if created_by is not None:
            self.created_by = created_by
        if created_on is not None:
            self.created_on = created_on
        if last_modified_on is not None:
            self.last_modified_on = last_modified_on
        if name is not None:
            self.name = name

    @property
    def resource_type(self):
        """Gets the resource_type of this SearchResultResource.  # noqa: E501

        The resource type, also known as resource category.  # noqa: E501

        :return: The resource_type of this SearchResultResource.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this SearchResultResource.

        The resource type, also known as resource category.  # noqa: E501

        :param resource_type: The resource_type of this SearchResultResource.  # noqa: E501
        :type: str
        """
        allowed_values = ["Asset", "Community", "Domain", "User", "UserGroup"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and resource_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `resource_type` ({0}), must be one of {1}"  # noqa: E501
                .format(resource_type, allowed_values)
            )

        self._resource_type = resource_type

    @property
    def id(self):
        """Gets the id of this SearchResultResource.  # noqa: E501

        The resource ID.  # noqa: E501

        :return: The id of this SearchResultResource.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SearchResultResource.

        The resource ID.  # noqa: E501

        :param id: The id of this SearchResultResource.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def created_by(self):
        """Gets the created_by of this SearchResultResource.  # noqa: E501

        The ID of the user who created the resource.  # noqa: E501

        :return: The created_by of this SearchResultResource.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this SearchResultResource.

        The ID of the user who created the resource.  # noqa: E501

        :param created_by: The created_by of this SearchResultResource.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def created_on(self):
        """Gets the created_on of this SearchResultResource.  # noqa: E501

        The timestamp (in UTC time standard) of the creation of this resource.  # noqa: E501

        :return: The created_on of this SearchResultResource.  # noqa: E501
        :rtype: int
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this SearchResultResource.

        The timestamp (in UTC time standard) of the creation of this resource.  # noqa: E501

        :param created_on: The created_on of this SearchResultResource.  # noqa: E501
        :type: int
        """

        self._created_on = created_on

    @property
    def last_modified_on(self):
        """Gets the last_modified_on of this SearchResultResource.  # noqa: E501

        The timestamp (in UTC time standard) of the last modification of this resource.  # noqa: E501

        :return: The last_modified_on of this SearchResultResource.  # noqa: E501
        :rtype: int
        """
        return self._last_modified_on

    @last_modified_on.setter
    def last_modified_on(self, last_modified_on):
        """Sets the last_modified_on of this SearchResultResource.

        The timestamp (in UTC time standard) of the last modification of this resource.  # noqa: E501

        :param last_modified_on: The last_modified_on of this SearchResultResource.  # noqa: E501
        :type: int
        """

        self._last_modified_on = last_modified_on

    @property
    def name(self):
        """Gets the name of this SearchResultResource.  # noqa: E501

        The name of the resource.  # noqa: E501

        :return: The name of this SearchResultResource.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SearchResultResource.

        The name of the resource.  # noqa: E501

        :param name: The name of this SearchResultResource.  # noqa: E501
        :type: str
        """

        self._name = name

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_key = self.attribute_map[self.discriminator]
        discriminator_value = data[discriminator_key]
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchResultResource):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SearchResultResource):
            return True

        return self.to_dict() != other.to_dict()
