# coding: utf-8

"""
    Collibra Search API

    <p>The Search API allows you to create your own integration with the Collibra Search Engine.<br /> Find your data!</p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_search.configuration import Configuration


class SearchResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'total': 'int',
        'results': 'list[SearchResult]',
        'aggregations': 'list[SearchResponseAggregation]'
    }

    attribute_map = {
        'total': 'total',
        'results': 'results',
        'aggregations': 'aggregations'
    }

    def __init__(self, total=None, results=None, aggregations=None, local_vars_configuration=None):  # noqa: E501
        """SearchResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._total = None
        self._results = None
        self._aggregations = None
        self.discriminator = None

        if total is not None:
            self.total = total
        if results is not None:
            self.results = results
        if aggregations is not None:
            self.aggregations = aggregations

    @property
    def total(self):
        """Gets the total of this SearchResponse.  # noqa: E501

        The total number of resources matching the search criteria, ignoring pagination (`limit` and `offset`).  # noqa: E501

        :return: The total of this SearchResponse.  # noqa: E501
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this SearchResponse.

        The total number of resources matching the search criteria, ignoring pagination (`limit` and `offset`).  # noqa: E501

        :param total: The total of this SearchResponse.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                total is not None and total < 0):  # noqa: E501
            raise ValueError("Invalid value for `total`, must be a value greater than or equal to `0`")  # noqa: E501

        self._total = total

    @property
    def results(self):
        """Gets the results of this SearchResponse.  # noqa: E501

        The list of search results ordered as per the search request.  # noqa: E501

        :return: The results of this SearchResponse.  # noqa: E501
        :rtype: list[SearchResult]
        """
        return self._results

    @results.setter
    def results(self, results):
        """Sets the results of this SearchResponse.

        The list of search results ordered as per the search request.  # noqa: E501

        :param results: The results of this SearchResponse.  # noqa: E501
        :type: list[SearchResult]
        """

        self._results = results

    @property
    def aggregations(self):
        """Gets the aggregations of this SearchResponse.  # noqa: E501

        The aggregations performed on all the results matching the search criteria, ignoring pagination (`limit` and `offset`). Aggregations are only performed on the fields requested in the search request.  # noqa: E501

        :return: The aggregations of this SearchResponse.  # noqa: E501
        :rtype: list[SearchResponseAggregation]
        """
        return self._aggregations

    @aggregations.setter
    def aggregations(self, aggregations):
        """Sets the aggregations of this SearchResponse.

        The aggregations performed on all the results matching the search criteria, ignoring pagination (`limit` and `offset`). Aggregations are only performed on the fields requested in the search request.  # noqa: E501

        :param aggregations: The aggregations of this SearchResponse.  # noqa: E501
        :type: list[SearchResponseAggregation]
        """

        self._aggregations = aggregations

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SearchResponse):
            return True

        return self.to_dict() != other.to_dict()
