# coding: utf-8

"""
    Collibra Search API

    <p>The Search API allows you to create your own integration with the Collibra Search Engine.<br /> Find your data!</p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_search.configuration import Configuration


class SearchRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'keywords': 'str',
        'search_in_fields': 'list[SearchInFields]',
        'filters': 'list[SearchFilter]',
        'aggregations': 'list[SearchAggregation]',
        'sort_field': 'str',
        'sort_order': 'str',
        'highlights': 'SearchHighlight',
        'limit': 'int',
        'offset': 'int'
    }

    attribute_map = {
        'keywords': 'keywords',
        'search_in_fields': 'searchInFields',
        'filters': 'filters',
        'aggregations': 'aggregations',
        'sort_field': 'sortField',
        'sort_order': 'sortOrder',
        'highlights': 'highlights',
        'limit': 'limit',
        'offset': 'offset'
    }

    def __init__(self, keywords=None, search_in_fields=None, filters=None, aggregations=None, sort_field='RELEVANCE', sort_order=None, highlights=None, limit=20, offset=0, local_vars_configuration=None):  # noqa: E501
        """SearchRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._keywords = None
        self._search_in_fields = None
        self._filters = None
        self._aggregations = None
        self._sort_field = None
        self._sort_order = None
        self._highlights = None
        self._limit = None
        self._offset = None
        self.discriminator = None

        if keywords is not None:
            self.keywords = keywords
        self.search_in_fields = search_in_fields
        self.filters = filters
        self.aggregations = aggregations
        self.sort_field = sort_field
        self.sort_order = sort_order
        self.highlights = highlights
        self.limit = limit
        self.offset = offset

    @property
    def keywords(self):
        """Gets the keywords of this SearchRequest.  # noqa: E501

        The search term.<br /> The field is mandatory and cannot be empty. You can use optional wildcards and quotes. No asterisk \"*\" wildcard will be automatically added for REST calls.  # noqa: E501

        :return: The keywords of this SearchRequest.  # noqa: E501
        :rtype: str
        """
        return self._keywords

    @keywords.setter
    def keywords(self, keywords):
        """Sets the keywords of this SearchRequest.

        The search term.<br /> The field is mandatory and cannot be empty. You can use optional wildcards and quotes. No asterisk \"*\" wildcard will be automatically added for REST calls.  # noqa: E501

        :param keywords: The keywords of this SearchRequest.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                keywords is not None and len(keywords) > 1000):
            raise ValueError("Invalid value for `keywords`, length must be less than or equal to `1000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                keywords is not None and len(keywords) < 1):
            raise ValueError("Invalid value for `keywords`, length must be greater than or equal to `1`")  # noqa: E501

        self._keywords = keywords

    @property
    def search_in_fields(self):
        """Gets the search_in_fields of this SearchRequest.  # noqa: E501

        Optional set of fields to search in. By default, the search is performed in all the supported fields.  # noqa: E501

        :return: The search_in_fields of this SearchRequest.  # noqa: E501
        :rtype: list[SearchInFields]
        """
        return self._search_in_fields

    @search_in_fields.setter
    def search_in_fields(self, search_in_fields):
        """Sets the search_in_fields of this SearchRequest.

        Optional set of fields to search in. By default, the search is performed in all the supported fields.  # noqa: E501

        :param search_in_fields: The search_in_fields of this SearchRequest.  # noqa: E501
        :type: list[SearchInFields]
        """

        self._search_in_fields = search_in_fields

    @property
    def filters(self):
        """Gets the filters of this SearchRequest.  # noqa: E501

        Optional filters to apply to narrow down the search results.  # noqa: E501

        :return: The filters of this SearchRequest.  # noqa: E501
        :rtype: list[SearchFilter]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """Sets the filters of this SearchRequest.

        Optional filters to apply to narrow down the search results.  # noqa: E501

        :param filters: The filters of this SearchRequest.  # noqa: E501
        :type: list[SearchFilter]
        """

        self._filters = filters

    @property
    def aggregations(self):
        """Gets the aggregations of this SearchRequest.  # noqa: E501

        Optional set of aggregations to perform. Only results that match the search criteria (including all filters) are aggregated. Aggregation counts ignore pagination settings (limit and offset). Aggregations can be used to visualize a faceted search on frontend-related applications.  # noqa: E501

        :return: The aggregations of this SearchRequest.  # noqa: E501
        :rtype: list[SearchAggregation]
        """
        return self._aggregations

    @aggregations.setter
    def aggregations(self, aggregations):
        """Sets the aggregations of this SearchRequest.

        Optional set of aggregations to perform. Only results that match the search criteria (including all filters) are aggregated. Aggregation counts ignore pagination settings (limit and offset). Aggregations can be used to visualize a faceted search on frontend-related applications.  # noqa: E501

        :param aggregations: The aggregations of this SearchRequest.  # noqa: E501
        :type: list[SearchAggregation]
        """

        self._aggregations = aggregations

    @property
    def sort_field(self):
        """Gets the sort_field of this SearchRequest.  # noqa: E501

        The reference field for sorting the results.  # noqa: E501

        :return: The sort_field of this SearchRequest.  # noqa: E501
        :rtype: str
        """
        return self._sort_field

    @sort_field.setter
    def sort_field(self, sort_field):
        """Sets the sort_field of this SearchRequest.

        The reference field for sorting the results.  # noqa: E501

        :param sort_field: The sort_field of this SearchRequest.  # noqa: E501
        :type: str
        """
        allowed_values = [None,"RELEVANCE", "NAME", "LAST_MODIFIED_ON"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and sort_field not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `sort_field` ({0}), must be one of {1}"  # noqa: E501
                .format(sort_field, allowed_values)
            )

        self._sort_field = sort_field

    @property
    def sort_order(self):
        """Gets the sort_order of this SearchRequest.  # noqa: E501

        The order in which the results are sorted. The default order when sorting by `NAME` is ascending (`ASC`). The default order when sorting by other fields is descending (`DESC`).  # noqa: E501

        :return: The sort_order of this SearchRequest.  # noqa: E501
        :rtype: str
        """
        return self._sort_order

    @sort_order.setter
    def sort_order(self, sort_order):
        """Sets the sort_order of this SearchRequest.

        The order in which the results are sorted. The default order when sorting by `NAME` is ascending (`ASC`). The default order when sorting by other fields is descending (`DESC`).  # noqa: E501

        :param sort_order: The sort_order of this SearchRequest.  # noqa: E501
        :type: str
        """
        allowed_values = [None,"ASC", "DESC"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and sort_order not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `sort_order` ({0}), must be one of {1}"  # noqa: E501
                .format(sort_order, allowed_values)
            )

        self._sort_order = sort_order

    @property
    def highlights(self):
        """Gets the highlights of this SearchRequest.  # noqa: E501


        :return: The highlights of this SearchRequest.  # noqa: E501
        :rtype: SearchHighlight
        """
        return self._highlights

    @highlights.setter
    def highlights(self, highlights):
        """Sets the highlights of this SearchRequest.


        :param highlights: The highlights of this SearchRequest.  # noqa: E501
        :type: SearchHighlight
        """

        self._highlights = highlights

    @property
    def limit(self):
        """Gets the limit of this SearchRequest.  # noqa: E501

        The number of search results to present in the response. If set to `0`, only aggregations are performed. Negative values are not possible. If not set, the default limit is used. The maximum possible value is `1000`. In conjunction with `offset`, this field provides a method to paginate the results. The sum of `limit` and `offset` cannot exceed `10000`.  # noqa: E501

        :return: The limit of this SearchRequest.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this SearchRequest.

        The number of search results to present in the response. If set to `0`, only aggregations are performed. Negative values are not possible. If not set, the default limit is used. The maximum possible value is `1000`. In conjunction with `offset`, this field provides a method to paginate the results. The sum of `limit` and `offset` cannot exceed `10000`.  # noqa: E501

        :param limit: The limit of this SearchRequest.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                limit is not None and limit > 1000):  # noqa: E501
            raise ValueError("Invalid value for `limit`, must be a value less than or equal to `1000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                limit is not None and limit < 0):  # noqa: E501
            raise ValueError("Invalid value for `limit`, must be a value greater than or equal to `0`")  # noqa: E501

        self._limit = limit

    @property
    def offset(self):
        """Gets the offset of this SearchRequest.  # noqa: E501

        The number of first search results to skip in the response. Negative values are not possible. If not set or set to `0`, no results are skipped. In conjunction with `limit`, this field provides a method to paginate the results. The sum of `limit` and `offset` cannot exceed `10000`.  # noqa: E501

        :return: The offset of this SearchRequest.  # noqa: E501
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """Sets the offset of this SearchRequest.

        The number of first search results to skip in the response. Negative values are not possible. If not set or set to `0`, no results are skipped. In conjunction with `limit`, this field provides a method to paginate the results. The sum of `limit` and `offset` cannot exceed `10000`.  # noqa: E501

        :param offset: The offset of this SearchRequest.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                offset is not None and offset > 10000):  # noqa: E501
            raise ValueError("Invalid value for `offset`, must be a value less than or equal to `10000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                offset is not None and offset < 0):  # noqa: E501
            raise ValueError("Invalid value for `offset`, must be a value greater than or equal to `0`")  # noqa: E501

        self._offset = offset

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SearchRequest):
            return True

        return self.to_dict() != other.to_dict()
