# coding: utf-8

"""
    Collibra Search API

    <p>The Search API allows you to create your own integration with the Collibra Search Engine.<br /> Find your data!</p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_search.configuration import Configuration


class SearchInFields(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'resource_type': 'str',
        'fields': 'list[str]'
    }

    attribute_map = {
        'resource_type': 'resourceType',
        'fields': 'fields'
    }

    def __init__(self, resource_type=None, fields=None, local_vars_configuration=None):  # noqa: E501
        """SearchInFields - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._resource_type = None
        self._fields = None
        self.discriminator = None

        if resource_type is not None:
            self.resource_type = resource_type
        if fields is not None:
            self.fields = fields

    @property
    def resource_type(self):
        """Gets the resource_type of this SearchInFields.  # noqa: E501

        The reference resource type for the filter, also known as resource category. You must also provide at least one field for each resource type. When you include more than one resource type, you must provide the same fields (if available) for all resource types.<br /> Possible values are `Asset`, `Domain`, `Community`, `User` and `UserGroup`.<br /> Use in conjunction with `fields`.  # noqa: E501

        :return: The resource_type of this SearchInFields.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this SearchInFields.

        The reference resource type for the filter, also known as resource category. You must also provide at least one field for each resource type. When you include more than one resource type, you must provide the same fields (if available) for all resource types.<br /> Possible values are `Asset`, `Domain`, `Community`, `User` and `UserGroup`.<br /> Use in conjunction with `fields`.  # noqa: E501

        :param resource_type: The resource_type of this SearchInFields.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def fields(self):
        """Gets the fields of this SearchInFields.  # noqa: E501

        A list of fields for the reference resource type. Works in conjunction with `resourceType`.<br /> Possible values for `Asset` are  `name`, `displayName`, `comments`, `tags`, `dataClassification` and `attributes`. Note that `attributes` is a wildcard for all attribute types. To search in a specific attribute type, use the following notation: `resource_type:resource_uuid` where `resource_type` is the attribute resource type, such as `StringAttributeType` (or use the generic `attribute`) and `resource_uuid` is the UUID of the attribute type. <br/>Possible values for `Domain` and `Community` are `name` and `comments`.<br /> Possible values for `User` and `UserGroup` are `name`.  # noqa: E501

        :return: The fields of this SearchInFields.  # noqa: E501
        :rtype: list[str]
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """Sets the fields of this SearchInFields.

        A list of fields for the reference resource type. Works in conjunction with `resourceType`.<br /> Possible values for `Asset` are  `name`, `displayName`, `comments`, `tags`, `dataClassification` and `attributes`. Note that `attributes` is a wildcard for all attribute types. To search in a specific attribute type, use the following notation: `resource_type:resource_uuid` where `resource_type` is the attribute resource type, such as `StringAttributeType` (or use the generic `attribute`) and `resource_uuid` is the UUID of the attribute type. <br/>Possible values for `Domain` and `Community` are `name` and `comments`.<br /> Possible values for `User` and `UserGroup` are `name`.  # noqa: E501

        :param fields: The fields of this SearchInFields.  # noqa: E501
        :type: list[str]
        """

        self._fields = fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchInFields):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SearchInFields):
            return True

        return self.to_dict() != other.to_dict()
