"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const codedeploy = require("../../lib");
module.exports = {
    'CodeDeploy DeploymentConfig': {
        'can be created by specifying only minHealthyHostCount'(test) {
            const stack = new cdk.Stack();
            new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                minimumHealthyHosts: codedeploy.MinimumHealthyHosts.count(1),
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::DeploymentConfig', {
                'MinimumHealthyHosts': {
                    'Type': 'HOST_COUNT',
                    'Value': 1,
                },
            }));
            test.done();
        },
        'can be created by specifying only minHealthyHostPercentage'(test) {
            const stack = new cdk.Stack();
            new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                minimumHealthyHosts: codedeploy.MinimumHealthyHosts.percentage(75),
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::DeploymentConfig', {
                'MinimumHealthyHosts': {
                    'Type': 'FLEET_PERCENT',
                    'Value': 75,
                },
            }));
            test.done();
        },
        'can be imported'(test) {
            const stack = new cdk.Stack();
            const deploymentConfig = codedeploy.ServerDeploymentConfig.fromServerDeploymentConfigName(stack, 'MyDC', 'MyDC');
            test.notEqual(deploymentConfig, undefined);
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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