"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubWebhookHandler = void 0;
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const access_1 = require("./access");
const webhook_handler_function_1 = require("./lambdas/webhook-handler-function");
/**
 * Create a Lambda with a public URL to handle GitHub webhook events. After validating the event with the given secret, the orchestrator step function is called with information about the workflow job.
 *
 * This construct is not meant to be used by itself.
 */
class GithubWebhookHandler extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.handler = new webhook_handler_function_1.WebhookHandlerFunction(this, 'webhook-handler', {
            description: 'Handle GitHub webhook and start runner orchestrator',
            environment: {
                STEP_FUNCTION_ARN: props.orchestrator.stateMachineArn,
                WEBHOOK_SECRET_ARN: props.secrets.webhook.secretArn,
            },
            timeout: cdk.Duration.seconds(30),
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        });
        const access = props?.access ?? access_1.LambdaAccess.lambdaUrl();
        this.url = access._bind(this, 'access', this.handler);
        props.secrets.webhook.grantRead(this.handler);
        props.orchestrator.grantStartExecution(this.handler);
    }
}
exports.GithubWebhookHandler = GithubWebhookHandler;
//# sourceMappingURL=data:application/json;base64,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