"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LinuxUbuntuComponents = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const common_1 = require("../../../common");
const index_1 = require("../index");
/**
 * Components for Ubuntu Linux that can be used with AWS Image Builder based builders. These cannot be used by {@link CodeBuildImageBuilder}.
 *
 * @deprecated Use `RunnerImageComponent` instead.
 */
class LinuxUbuntuComponents {
    static requiredPackages(scope, id, architecture) {
        let archUrl;
        if (architecture.is(common_1.Architecture.X86_64)) {
            archUrl = 'amd64';
        }
        else if (architecture.is(common_1.Architecture.ARM64)) {
            archUrl = 'arm64';
        }
        else {
            throw new Error(`Unsupported architecture for required packages: ${architecture.name}`);
        }
        return new index_1.ImageBuilderComponent(scope, id, {
            platform: 'Linux',
            displayName: 'Required packages',
            description: 'Install packages required for GitHub Runner and upgrade all packages',
            commands: [
                'set -ex',
                'apt-get update',
                'DEBIAN_FRONTEND=noninteractive apt-get upgrade -y',
                'DEBIAN_FRONTEND=noninteractive apt-get install -y curl sudo jq bash zip unzip iptables software-properties-common ca-certificates',
                `curl -sfLo /tmp/amazon-cloudwatch-agent.deb https://s3.amazonaws.com/amazoncloudwatch-agent/ubuntu/${archUrl}/latest/amazon-cloudwatch-agent.deb`,
                'dpkg -i -E /tmp/amazon-cloudwatch-agent.deb',
                'rm /tmp/amazon-cloudwatch-agent.deb',
            ],
        });
    }
    static runnerUser(scope, id, _architecture) {
        return new index_1.ImageBuilderComponent(scope, id, {
            platform: 'Linux',
            displayName: 'GitHub Runner user',
            description: 'Install latest version of AWS CLI',
            commands: [
                'set -ex',
                'addgroup runner',
                'adduser --system --disabled-password --home /home/runner --ingroup runner runner',
                'usermod -aG sudo runner',
                'echo "%sudo   ALL=(ALL:ALL) NOPASSWD: ALL" > /etc/sudoers.d/runner',
            ],
        });
    }
    static awsCli(scope, id, architecture) {
        let archUrl;
        if (architecture.is(common_1.Architecture.X86_64)) {
            archUrl = 'x86_64';
        }
        else if (architecture.is(common_1.Architecture.ARM64)) {
            archUrl = 'aarch64';
        }
        else {
            throw new Error(`Unsupported architecture for awscli: ${architecture.name}`);
        }
        return new index_1.ImageBuilderComponent(scope, id, {
            platform: 'Linux',
            displayName: 'AWS CLI',
            description: 'Install latest version of AWS CLI',
            commands: [
                'set -ex',
                `curl -fsSL "https://awscli.amazonaws.com/awscli-exe-linux-${archUrl}.zip" -o awscliv2.zip`,
                'unzip -q awscliv2.zip',
                './aws/install',
                'rm -rf awscliv2.zip aws',
            ],
        });
    }
    static githubCli(scope, id, _architecture) {
        return new index_1.ImageBuilderComponent(scope, id, {
            platform: 'Linux',
            displayName: 'GitHub CLI',
            description: 'Install latest version of gh',
            commands: [
                'set -ex',
                'curl -fsSL https://cli.github.com/packages/githubcli-archive-keyring.gpg | sudo dd of=/usr/share/keyrings/githubcli-archive-keyring.gpg',
                'echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/githubcli-archive-keyring.gpg] ' +
                    '  https://cli.github.com/packages stable main" | sudo tee /etc/apt/sources.list.d/github-cli.list > /dev/null',
                'apt-get update',
                'DEBIAN_FRONTEND=noninteractive apt-get install -y gh',
            ],
        });
    }
    static git(scope, id, _architecture) {
        return new index_1.ImageBuilderComponent(scope, id, {
            platform: 'Linux',
            displayName: 'Git',
            description: 'Install latest version of git',
            commands: [
                'set -ex',
                'add-apt-repository ppa:git-core/ppa',
                'apt-get update',
                'DEBIAN_FRONTEND=noninteractive apt-get install -y git',
            ],
        });
    }
    static githubRunner(scope, id, runnerVersion, architecture) {
        let versionCommand;
        if (runnerVersion.is(common_1.RunnerVersion.latest())) {
            versionCommand = 'RUNNER_VERSION=`curl -w "%{redirect_url}" -fsS https://github.com/actions/runner/releases/latest | grep -oE "[^/v]+$"`';
        }
        else {
            versionCommand = `RUNNER_VERSION='${runnerVersion.version}'`;
        }
        let archUrl;
        if (architecture.is(common_1.Architecture.X86_64)) {
            archUrl = 'x64';
        }
        else if (architecture.is(common_1.Architecture.ARM64)) {
            archUrl = 'arm64';
        }
        else {
            throw new Error(`Unsupported architecture for GitHub Runner: ${architecture.name}`);
        }
        return new index_1.ImageBuilderComponent(scope, id, {
            platform: 'Linux',
            displayName: 'GitHub Actions Runner',
            description: 'Install latest version of GitHub Actions Runner',
            commands: [
                'set -ex',
                versionCommand,
                `curl -fsSLO "https://github.com/actions/runner/releases/download/v\${RUNNER_VERSION}/actions-runner-linux-${archUrl}-\${RUNNER_VERSION}.tar.gz"`,
                `tar xzf "actions-runner-linux-${archUrl}-\${RUNNER_VERSION}.tar.gz"`,
                `rm actions-runner-linux-${archUrl}-\${RUNNER_VERSION}.tar.gz`,
                './bin/installdependencies.sh',
                `echo -n ${runnerVersion.version} > RUNNER_VERSION`,
            ],
        });
    }
    static docker(scope, id, _architecture) {
        return new index_1.ImageBuilderComponent(scope, id, {
            platform: 'Linux',
            displayName: 'Docker',
            description: 'Install latest version of Docker',
            commands: [
                'set -ex',
                'curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo gpg --dearmor -o /usr/share/keyrings/docker.gpg',
                'echo ' +
                    '  "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/docker.gpg] https://download.docker.com/linux/ubuntu ' +
                    '  $(lsb_release -cs) stable" | sudo tee /etc/apt/sources.list.d/docker.list > /dev/null',
                'apt-get update',
                'DEBIAN_FRONTEND=noninteractive apt-get install -y docker-ce docker-ce-cli containerd.io docker-compose-plugin',
                'usermod -aG docker runner',
                'ln -s /usr/libexec/docker/cli-plugins/docker-compose /usr/bin/docker-compose',
            ],
        });
    }
    static extraCertificates(scope, id, path) {
        return new index_1.ImageBuilderComponent(scope, id, {
            platform: 'Linux',
            displayName: 'Extra certificates',
            description: 'Install self-signed certificates to provide access to GitHub Enterprise Server',
            commands: [
                'set -ex',
                'cp certs/certs.pem /usr/local/share/ca-certificates/github-enterprise-server.crt',
                'update-ca-certificates',
            ],
            assets: [
                {
                    path: 'certs',
                    asset: new aws_cdk_lib_1.aws_s3_assets.Asset(scope, `${id} Asset`, { path }),
                },
            ],
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
LinuxUbuntuComponents[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.LinuxUbuntuComponents", version: "0.9.3" };
exports.LinuxUbuntuComponents = LinuxUbuntuComponents;
//# sourceMappingURL=data:application/json;base64,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