"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImageBuilderObjectBase = void 0;
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_image_builder_versioner_function_1 = require("../../../lambdas/aws-image-builder-versioner-function");
const utils_1 = require("../../../utils");
/**
 * @internal
 */
class ImageBuilderObjectBase extends cdk.Resource {
    constructor(scope, id) {
        super(scope, id);
    }
    version(type, name, data) {
        return new aws_cdk_lib_1.CustomResource(this, 'Version', {
            serviceToken: this.versionFunction().functionArn,
            resourceType: `Custom::ImageBuilder-${type}-Version`,
            removalPolicy: cdk.RemovalPolicy.RETAIN,
            properties: {
                ObjectType: type,
                ObjectName: name,
                VersionedData: data, // get a new version every time something changes, like Image Builder wants
            },
        }).ref;
    }
    versionFunction() {
        return (0, utils_1.singletonLambda)(aws_image_builder_versioner_function_1.AwsImageBuilderVersionerFunction, this, 'aws-image-builder-versioner', {
            description: 'Custom resource handler that bumps up Image Builder versions',
            initialPolicy: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    actions: [
                        'imagebuilder:ListComponents',
                        'imagebuilder:ListContainerRecipes',
                        'imagebuilder:ListImageRecipes',
                    ],
                    resources: ['*'],
                }),
            ],
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
            timeout: cdk.Duration.minutes(5),
        });
    }
}
exports.ImageBuilderObjectBase = ImageBuilderObjectBase;
//# sourceMappingURL=data:application/json;base64,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