"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const AWS = require("aws-sdk");
const semver_1 = require("semver");
const helpers_1 = require("./helpers");
const ib = new AWS.Imagebuilder();
/* eslint-disable @typescript-eslint/no-require-imports, import/no-extraneous-dependencies */
async function handler(event, context) {
    console.log(JSON.stringify({ ...event, ResponseURL: '...' }));
    try {
        const objectType = event.ResourceProperties.ObjectType;
        const objectName = event.ResourceProperties.ObjectName;
        switch (event.RequestType) {
            case 'Create':
            case 'Update':
                let version = '1.0.0';
                let allVersions = [];
                try {
                    switch (objectType) {
                        case 'Component': {
                            let result = {};
                            do {
                                result = await ib.listComponents({
                                    filters: [{
                                            name: 'name',
                                            values: [objectName],
                                        }],
                                    nextToken: result.nextToken,
                                }).promise();
                                allVersions = allVersions.concat(result.componentVersionList.map(i => i.version || '1.0.0'));
                            } while (result.nextToken);
                            break;
                        }
                        case 'ImageRecipe': {
                            let result = {};
                            do {
                                result = await ib.listImageRecipes({
                                    filters: [{
                                            name: 'name',
                                            values: [objectName],
                                        }],
                                    nextToken: result.nextToken,
                                }).promise();
                                allVersions = allVersions.concat(result.imageRecipeSummaryList.map(i => i.arn?.split('/').pop() || '1.0.0'));
                            } while (result.nextToken);
                            break;
                        }
                        case 'ContainerRecipe': {
                            let result = {};
                            do {
                                result = await ib.listContainerRecipes({
                                    filters: [{
                                            name: 'name',
                                            values: [objectName],
                                        }],
                                    nextToken: result.nextToken,
                                }).promise();
                                allVersions = allVersions.concat(result.containerRecipeSummaryList.map(i => i.arn?.split('/').pop() || '1.0.0'));
                            } while (result.nextToken);
                            break;
                        }
                    }
                }
                catch (e) {
                    if (e.code !== 'ResourceNotFoundException') {
                        throw e;
                    }
                    else {
                        console.log('Resource not found, assuming first version');
                    }
                }
                version = (0, semver_1.maxSatisfying)(allVersions, '>=0.0.0');
                if (version === null) {
                    version = '1.0.0';
                }
                console.log(`Found versions ${allVersions} -- latest is ${version}`);
                version = (0, semver_1.inc)(version, 'patch');
                if (version === null) {
                    throw new Error('Unable to bump version');
                }
                await (0, helpers_1.customResourceRespond)(event, 'SUCCESS', 'OK', version, {});
                break;
            case 'Delete':
                await (0, helpers_1.customResourceRespond)(event, 'SUCCESS', 'OK', event.PhysicalResourceId, {});
                break;
        }
    }
    catch (e) {
        console.log(e);
        await (0, helpers_1.customResourceRespond)(event, 'FAILED', e.message || 'Internal Error', context.logStreamName, {});
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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