[![Build Status](https://travis-ci.org/aiidateam/aiida_core.svg?branch=develop)](https://travis-ci.org/aiidateam/aiida_core)
[![Coverage Status](https://coveralls.io/repos/github/aiidateam/aiida_core/badge.svg?branch=develop)](https://coveralls.io/github/aiidateam/aiida_core?branch=develop)
[![Docs status](https://readthedocs.org/projects/aiida-core/badge)](http://aiida-core.readthedocs.io/)
[![PyPI version](https://badge.fury.io/py/aiida-core.svg)](https://badge.fury.io/py/aiida-core)


AiiDA
=====

**Automated Interactive Infrastructure and Database for Computational
Science**

AiiDA is a sophisticated framework designed from scratch to be a
flexible and scalable infrastructure for computational science. Being
able to store the full data provenance of each simulation, and based on
a tailored database solution built for efficient data mining
implementations, AiiDA gives the user the ability to interact seamlessly
with any number of HPC machines and codes thanks to its flexible plugin
interface, together with a powerful workflow engine for the automation
of simulations.

The official homepage is at <http://www.aiida.net>

The code is hosted on GitHub at
<https://github.com/aiidateam/aiida_core>

The documentation is hosted on Read The Docs at:

-   [stable version](http://aiida-core.readthedocs.io/en/stable)
-   [develop version](http://aiida-core.readthedocs.io/en/latest)

Which branch should you use?
----------------------------

-   **Users**: the stable version of the code is in the [master
    branch](https://github.com/aiidateam/aiida_core/tree/master)
-   **Developers**: the procedure to contribute through pull-requests
    can be found in the
    [wiki](https://github.com/aiidateam/aiida_core/wiki/Contributing-guide-and-branch-descriptions)

How to cite AiiDA
-----------------

If you use AiiDA in your research, please consider citing the following
work:

> Giovanni Pizzi, Andrea Cepellotti, Riccardo Sabatini, Nicola Marzari,
> and Boris Kozinsky, *AiiDA: automated interactive infrastructure and
> database for computational science*, Comp. Mat. Sci 111, 218-230
> (2016); <http://dx.doi.org/10.1016/j.commatsci.2015.09.013>;
> <http://www.aiida.net>.

License
-------

The terms of the AiiDA license can be found in the LICENSE.txt file.

Acknowledgements
----------------

This work is supported by the [MARVEL National Centre for Competency in
Research](<http://nccr-marvel.ch>) funded by the [Swiss National
Science Foundation](<http://www.snf.ch/en>), as well as by the [MaX
European Centre of Excellence](<http://www.max-centre.eu/>) funded by
the Horizon 2020 EINFRA-5 program, Grant No. 676598.

![MARVEL](docs/source/images/MARVEL.png)
![MaX](docs/source/images/MaX.png)
