/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.codepolicy.SASScope;
import com.sas.models.BufferHints;
import com.sas.models.CacheException;
import com.sas.models.CacheInterface;
import com.sas.models.StaticCacheInterface;

@SASScope
public abstract class CacheBase
implements CacheInterface {
    public static final int DEFAULT_MAX_SIZE = 128;
    public static final int DEFAULT_LOOKAHEAD_SIZE = 16;
    public static final int DEFAULT_THRESHOLD_VALUE = 25;
    public static final int DEFAULT_THRESHOLD_TYPE = 0;
    protected StaticCacheInterface secondaryCache;
    protected int maxSize;
    protected int count;
    protected int threshold;
    protected int thresholdType;
    protected int accessType;
    protected boolean sequential;
    protected int lookAheadSize;
    protected int direction;
    protected int directionChangeThreshold;
    protected int leaning;
    private int lookAheadState;
    private static Object[] noObjects;

    public CacheBase(StaticCacheInterface secondaryCache) {
        this(secondaryCache, 128, 16, 0, 25);
    }

    public CacheBase(StaticCacheInterface secondaryCache, int maxSize, int lookAheadSize, int thresholdType, int thresholdValue) {
        this.secondaryCache = secondaryCache;
        if (maxSize != -1) {
            this.maxSize = maxSize;
        }
        if (lookAheadSize != -1) {
            this.lookAheadSize = Math.max(1, lookAheadSize);
        }
        if (this.threshold != -1) {
            this.threshold = this.threshold;
        }
        if (thresholdValue != -1) {
            this.thresholdType = thresholdType;
        }
        this.setDirection(256);
        this.directionChangeThreshold = 2;
    }

    @Override
    public int count() {
        return this.count;
    }

    public boolean lookAheadEnabled() {
        return this.lookAheadState == 0;
    }

    public void enableLookAhead() {
        if (this.lookAheadState > 0) {
            --this.lookAheadState;
        }
    }

    public boolean disableLookAhead() {
        ++this.lookAheadState;
        return true;
    }

    public static Object[] nullObjectArray() {
        if (noObjects == null) {
            noObjects = new Object[0];
        }
        return noObjects;
    }

    @Override
    public void useBufferHints(BufferHints hints) {
        while (hints != null) {
            try {
                if ((hints.how & 1) == 1) {
                    if (hints.what == 8192) {
                        this.configureCache(hints.count, -1, -1, -1, -1);
                    } else if (hints.what == 4096) {
                        this.configureCache(-1, hints.count, -1, -1, -1);
                    }
                } else if (hints.what == 16384) {
                    this.setDirection(hints.how);
                }
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
            hints = hints.moreHints;
        }
    }

    public void setDirection(int newDirection) {
        this.direction = newDirection;
    }

    public int getDirection() {
        return this.direction;
    }

    @Override
    public synchronized void configureCache(int maxCacheSize, int bufferLookAhead, int thresholdType, int thresholdValue, int accessType) throws CacheException {
        if (bufferLookAhead != -1) {
            this.lookAheadSize = bufferLookAhead;
        }
        if (thresholdType != -1) {
            this.thresholdType = thresholdType;
            this.threshold = thresholdValue;
        }
        if (this.accessType != -1) {
            boolean bl = this.sequential = (accessType & 0x1000) != 0;
        }
        if (maxCacheSize != -1) {
            this.maxSize = maxCacheSize;
        }
    }

    @Override
    public abstract Object getFromCache(long var1) throws CacheException;

    @Override
    public abstract Object[] getFromCache(long[] var1, boolean var2) throws CacheException;

    @Override
    public abstract Object[] getFromCache(long var1, long var3, boolean var5) throws CacheException;

    @Override
    public abstract long[] computeCacheKeyRange(long var1, long var3, int var5) throws CacheException;

    @Override
    public abstract long[] getCacheKeys() throws CacheException;

    @Override
    public abstract boolean cacheContainsKey(long var1) throws CacheException;

    @Override
    public void setSecondaryCache(StaticCacheInterface cache) throws CacheException {
        this.secondaryCache = this.secondaryCache;
    }

    @Override
    public StaticCacheInterface getSecondaryCache() {
        return this.secondaryCache;
    }

    @Override
    public int getCacheKeyUse() {
        return this.secondaryCache.getCacheKeyUse();
    }

    @Override
    public abstract void invalidateCache();

    @Override
    public abstract void invalidateCache(long var1) throws CacheException;

    @Override
    public abstract void storeInCache(long var1, Object var3) throws CacheException;

    protected boolean isFull() {
        return this.count == this.maxSize;
    }

    public int getCacheCapacity() {
        return this.maxSize;
    }
}

