# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetTwingateUsersResult',
    'AwaitableGetTwingateUsersResult',
    'get_twingate_users',
    'get_twingate_users_output',
]

@pulumi.output_type
class GetTwingateUsersResult:
    """
    A collection of values returned by getTwingateUsers.
    """
    def __init__(__self__, email=None, email_contains=None, email_exclude=None, email_prefix=None, email_regexp=None, email_suffix=None, first_name=None, first_name_contains=None, first_name_exclude=None, first_name_prefix=None, first_name_regexp=None, first_name_suffix=None, id=None, last_name=None, last_name_contains=None, last_name_exclude=None, last_name_prefix=None, last_name_regexp=None, last_name_suffix=None, roles=None, users=None):
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if email_contains and not isinstance(email_contains, str):
            raise TypeError("Expected argument 'email_contains' to be a str")
        pulumi.set(__self__, "email_contains", email_contains)
        if email_exclude and not isinstance(email_exclude, str):
            raise TypeError("Expected argument 'email_exclude' to be a str")
        pulumi.set(__self__, "email_exclude", email_exclude)
        if email_prefix and not isinstance(email_prefix, str):
            raise TypeError("Expected argument 'email_prefix' to be a str")
        pulumi.set(__self__, "email_prefix", email_prefix)
        if email_regexp and not isinstance(email_regexp, str):
            raise TypeError("Expected argument 'email_regexp' to be a str")
        pulumi.set(__self__, "email_regexp", email_regexp)
        if email_suffix and not isinstance(email_suffix, str):
            raise TypeError("Expected argument 'email_suffix' to be a str")
        pulumi.set(__self__, "email_suffix", email_suffix)
        if first_name and not isinstance(first_name, str):
            raise TypeError("Expected argument 'first_name' to be a str")
        pulumi.set(__self__, "first_name", first_name)
        if first_name_contains and not isinstance(first_name_contains, str):
            raise TypeError("Expected argument 'first_name_contains' to be a str")
        pulumi.set(__self__, "first_name_contains", first_name_contains)
        if first_name_exclude and not isinstance(first_name_exclude, str):
            raise TypeError("Expected argument 'first_name_exclude' to be a str")
        pulumi.set(__self__, "first_name_exclude", first_name_exclude)
        if first_name_prefix and not isinstance(first_name_prefix, str):
            raise TypeError("Expected argument 'first_name_prefix' to be a str")
        pulumi.set(__self__, "first_name_prefix", first_name_prefix)
        if first_name_regexp and not isinstance(first_name_regexp, str):
            raise TypeError("Expected argument 'first_name_regexp' to be a str")
        pulumi.set(__self__, "first_name_regexp", first_name_regexp)
        if first_name_suffix and not isinstance(first_name_suffix, str):
            raise TypeError("Expected argument 'first_name_suffix' to be a str")
        pulumi.set(__self__, "first_name_suffix", first_name_suffix)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_name and not isinstance(last_name, str):
            raise TypeError("Expected argument 'last_name' to be a str")
        pulumi.set(__self__, "last_name", last_name)
        if last_name_contains and not isinstance(last_name_contains, str):
            raise TypeError("Expected argument 'last_name_contains' to be a str")
        pulumi.set(__self__, "last_name_contains", last_name_contains)
        if last_name_exclude and not isinstance(last_name_exclude, str):
            raise TypeError("Expected argument 'last_name_exclude' to be a str")
        pulumi.set(__self__, "last_name_exclude", last_name_exclude)
        if last_name_prefix and not isinstance(last_name_prefix, str):
            raise TypeError("Expected argument 'last_name_prefix' to be a str")
        pulumi.set(__self__, "last_name_prefix", last_name_prefix)
        if last_name_regexp and not isinstance(last_name_regexp, str):
            raise TypeError("Expected argument 'last_name_regexp' to be a str")
        pulumi.set(__self__, "last_name_regexp", last_name_regexp)
        if last_name_suffix and not isinstance(last_name_suffix, str):
            raise TypeError("Expected argument 'last_name_suffix' to be a str")
        pulumi.set(__self__, "last_name_suffix", last_name_suffix)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Returns only users that exactly match this email.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="emailContains")
    def email_contains(self) -> Optional[str]:
        """
        Match when the value exist in the email of the user.
        """
        return pulumi.get(self, "email_contains")

    @property
    @pulumi.getter(name="emailExclude")
    def email_exclude(self) -> Optional[str]:
        """
        Match when the value does not exist in the email of the user.
        """
        return pulumi.get(self, "email_exclude")

    @property
    @pulumi.getter(name="emailPrefix")
    def email_prefix(self) -> Optional[str]:
        """
        The email of the user must start with the value.
        """
        return pulumi.get(self, "email_prefix")

    @property
    @pulumi.getter(name="emailRegexp")
    def email_regexp(self) -> Optional[str]:
        """
        The regular expression match of the email of the user.
        """
        return pulumi.get(self, "email_regexp")

    @property
    @pulumi.getter(name="emailSuffix")
    def email_suffix(self) -> Optional[str]:
        """
        The email of the user must end with the value.
        """
        return pulumi.get(self, "email_suffix")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[str]:
        """
        Returns only users that exactly match the first name.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="firstNameContains")
    def first_name_contains(self) -> Optional[str]:
        """
        Match when the value exist in the first name of the user.
        """
        return pulumi.get(self, "first_name_contains")

    @property
    @pulumi.getter(name="firstNameExclude")
    def first_name_exclude(self) -> Optional[str]:
        """
        Match when the value does not exist in the first name of the user.
        """
        return pulumi.get(self, "first_name_exclude")

    @property
    @pulumi.getter(name="firstNamePrefix")
    def first_name_prefix(self) -> Optional[str]:
        """
        The first name of the user must start with the value.
        """
        return pulumi.get(self, "first_name_prefix")

    @property
    @pulumi.getter(name="firstNameRegexp")
    def first_name_regexp(self) -> Optional[str]:
        """
        The regular expression match of the first name of the user.
        """
        return pulumi.get(self, "first_name_regexp")

    @property
    @pulumi.getter(name="firstNameSuffix")
    def first_name_suffix(self) -> Optional[str]:
        """
        The first name of the user must end with the value.
        """
        return pulumi.get(self, "first_name_suffix")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[str]:
        """
        Returns only users that exactly match the last name.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="lastNameContains")
    def last_name_contains(self) -> Optional[str]:
        """
        Match when the value exist in the last name of the user.
        """
        return pulumi.get(self, "last_name_contains")

    @property
    @pulumi.getter(name="lastNameExclude")
    def last_name_exclude(self) -> Optional[str]:
        """
        Match when the value does not exist in the last name of the user.
        """
        return pulumi.get(self, "last_name_exclude")

    @property
    @pulumi.getter(name="lastNamePrefix")
    def last_name_prefix(self) -> Optional[str]:
        """
        The last name of the user must start with the value.
        """
        return pulumi.get(self, "last_name_prefix")

    @property
    @pulumi.getter(name="lastNameRegexp")
    def last_name_regexp(self) -> Optional[str]:
        """
        The regular expression match of the last name of the user.
        """
        return pulumi.get(self, "last_name_regexp")

    @property
    @pulumi.getter(name="lastNameSuffix")
    def last_name_suffix(self) -> Optional[str]:
        """
        The last name of the user must end with the value.
        """
        return pulumi.get(self, "last_name_suffix")

    @property
    @pulumi.getter
    def roles(self) -> Optional[Sequence[str]]:
        """
        Returns users that match a list of roles. Valid roles: `ADMIN`, `DEVOPS`, `SUPPORT`, `MEMBER`.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetTwingateUsersUserResult']:
        return pulumi.get(self, "users")


class AwaitableGetTwingateUsersResult(GetTwingateUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTwingateUsersResult(
            email=self.email,
            email_contains=self.email_contains,
            email_exclude=self.email_exclude,
            email_prefix=self.email_prefix,
            email_regexp=self.email_regexp,
            email_suffix=self.email_suffix,
            first_name=self.first_name,
            first_name_contains=self.first_name_contains,
            first_name_exclude=self.first_name_exclude,
            first_name_prefix=self.first_name_prefix,
            first_name_regexp=self.first_name_regexp,
            first_name_suffix=self.first_name_suffix,
            id=self.id,
            last_name=self.last_name,
            last_name_contains=self.last_name_contains,
            last_name_exclude=self.last_name_exclude,
            last_name_prefix=self.last_name_prefix,
            last_name_regexp=self.last_name_regexp,
            last_name_suffix=self.last_name_suffix,
            roles=self.roles,
            users=self.users)


def get_twingate_users(email: Optional[str] = None,
                       email_contains: Optional[str] = None,
                       email_exclude: Optional[str] = None,
                       email_prefix: Optional[str] = None,
                       email_regexp: Optional[str] = None,
                       email_suffix: Optional[str] = None,
                       first_name: Optional[str] = None,
                       first_name_contains: Optional[str] = None,
                       first_name_exclude: Optional[str] = None,
                       first_name_prefix: Optional[str] = None,
                       first_name_regexp: Optional[str] = None,
                       first_name_suffix: Optional[str] = None,
                       last_name: Optional[str] = None,
                       last_name_contains: Optional[str] = None,
                       last_name_exclude: Optional[str] = None,
                       last_name_prefix: Optional[str] = None,
                       last_name_regexp: Optional[str] = None,
                       last_name_suffix: Optional[str] = None,
                       roles: Optional[Sequence[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTwingateUsersResult:
    """
    Users in Twingate can be given access to Twingate Resources and may either be added manually or automatically synchronized with a 3rd party identity provider. For more information, see Twingate's [documentation](https://docs.twingate.com/docs/users).

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_twingate as twingate

    all = twingate.get_twingate_users()
    ```
    <!--End PulumiCodeChooser -->


    :param str email: The email address of the User
    :param str email_contains: Match when the value exist in the email of the user.
    :param str email_exclude: Match when the value does not exist in the email of the user.
    :param str email_prefix: The email of the user must start with the value.
    :param str email_regexp: The regular expression match of the email of the user.
    :param str email_suffix: The email of the user must end with the value.
    :param str first_name: The first name of the User
    :param str first_name_contains: Match when the value exist in the first name of the user.
    :param str first_name_exclude: Match when the value does not exist in the first name of the user.
    :param str first_name_prefix: The first name of the user must start with the value.
    :param str first_name_regexp: The regular expression match of the first name of the user.
    :param str first_name_suffix: The first name of the user must end with the value.
    :param str last_name: The last name of the User
    :param str last_name_contains: Match when the value exist in the last name of the user.
    :param str last_name_exclude: Match when the value does not exist in the last name of the user.
    :param str last_name_prefix: The last name of the user must start with the value.
    :param str last_name_regexp: The regular expression match of the last name of the user.
    :param str last_name_suffix: The last name of the user must end with the value.
    :param Sequence[str] roles: Returns users that match a list of roles. Valid roles: `ADMIN`, `DEVOPS`, `SUPPORT`, `MEMBER`.
    """
    __args__ = dict()
    __args__['email'] = email
    __args__['emailContains'] = email_contains
    __args__['emailExclude'] = email_exclude
    __args__['emailPrefix'] = email_prefix
    __args__['emailRegexp'] = email_regexp
    __args__['emailSuffix'] = email_suffix
    __args__['firstName'] = first_name
    __args__['firstNameContains'] = first_name_contains
    __args__['firstNameExclude'] = first_name_exclude
    __args__['firstNamePrefix'] = first_name_prefix
    __args__['firstNameRegexp'] = first_name_regexp
    __args__['firstNameSuffix'] = first_name_suffix
    __args__['lastName'] = last_name
    __args__['lastNameContains'] = last_name_contains
    __args__['lastNameExclude'] = last_name_exclude
    __args__['lastNamePrefix'] = last_name_prefix
    __args__['lastNameRegexp'] = last_name_regexp
    __args__['lastNameSuffix'] = last_name_suffix
    __args__['roles'] = roles
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('twingate:index/getTwingateUsers:getTwingateUsers', __args__, opts=opts, typ=GetTwingateUsersResult).value

    return AwaitableGetTwingateUsersResult(
        email=pulumi.get(__ret__, 'email'),
        email_contains=pulumi.get(__ret__, 'email_contains'),
        email_exclude=pulumi.get(__ret__, 'email_exclude'),
        email_prefix=pulumi.get(__ret__, 'email_prefix'),
        email_regexp=pulumi.get(__ret__, 'email_regexp'),
        email_suffix=pulumi.get(__ret__, 'email_suffix'),
        first_name=pulumi.get(__ret__, 'first_name'),
        first_name_contains=pulumi.get(__ret__, 'first_name_contains'),
        first_name_exclude=pulumi.get(__ret__, 'first_name_exclude'),
        first_name_prefix=pulumi.get(__ret__, 'first_name_prefix'),
        first_name_regexp=pulumi.get(__ret__, 'first_name_regexp'),
        first_name_suffix=pulumi.get(__ret__, 'first_name_suffix'),
        id=pulumi.get(__ret__, 'id'),
        last_name=pulumi.get(__ret__, 'last_name'),
        last_name_contains=pulumi.get(__ret__, 'last_name_contains'),
        last_name_exclude=pulumi.get(__ret__, 'last_name_exclude'),
        last_name_prefix=pulumi.get(__ret__, 'last_name_prefix'),
        last_name_regexp=pulumi.get(__ret__, 'last_name_regexp'),
        last_name_suffix=pulumi.get(__ret__, 'last_name_suffix'),
        roles=pulumi.get(__ret__, 'roles'),
        users=pulumi.get(__ret__, 'users'))


@_utilities.lift_output_func(get_twingate_users)
def get_twingate_users_output(email: Optional[pulumi.Input[Optional[str]]] = None,
                              email_contains: Optional[pulumi.Input[Optional[str]]] = None,
                              email_exclude: Optional[pulumi.Input[Optional[str]]] = None,
                              email_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                              email_regexp: Optional[pulumi.Input[Optional[str]]] = None,
                              email_suffix: Optional[pulumi.Input[Optional[str]]] = None,
                              first_name: Optional[pulumi.Input[Optional[str]]] = None,
                              first_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                              first_name_exclude: Optional[pulumi.Input[Optional[str]]] = None,
                              first_name_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                              first_name_regexp: Optional[pulumi.Input[Optional[str]]] = None,
                              first_name_suffix: Optional[pulumi.Input[Optional[str]]] = None,
                              last_name: Optional[pulumi.Input[Optional[str]]] = None,
                              last_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                              last_name_exclude: Optional[pulumi.Input[Optional[str]]] = None,
                              last_name_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                              last_name_regexp: Optional[pulumi.Input[Optional[str]]] = None,
                              last_name_suffix: Optional[pulumi.Input[Optional[str]]] = None,
                              roles: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTwingateUsersResult]:
    """
    Users in Twingate can be given access to Twingate Resources and may either be added manually or automatically synchronized with a 3rd party identity provider. For more information, see Twingate's [documentation](https://docs.twingate.com/docs/users).

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_twingate as twingate

    all = twingate.get_twingate_users()
    ```
    <!--End PulumiCodeChooser -->


    :param str email: The email address of the User
    :param str email_contains: Match when the value exist in the email of the user.
    :param str email_exclude: Match when the value does not exist in the email of the user.
    :param str email_prefix: The email of the user must start with the value.
    :param str email_regexp: The regular expression match of the email of the user.
    :param str email_suffix: The email of the user must end with the value.
    :param str first_name: The first name of the User
    :param str first_name_contains: Match when the value exist in the first name of the user.
    :param str first_name_exclude: Match when the value does not exist in the first name of the user.
    :param str first_name_prefix: The first name of the user must start with the value.
    :param str first_name_regexp: The regular expression match of the first name of the user.
    :param str first_name_suffix: The first name of the user must end with the value.
    :param str last_name: The last name of the User
    :param str last_name_contains: Match when the value exist in the last name of the user.
    :param str last_name_exclude: Match when the value does not exist in the last name of the user.
    :param str last_name_prefix: The last name of the user must start with the value.
    :param str last_name_regexp: The regular expression match of the last name of the user.
    :param str last_name_suffix: The last name of the user must end with the value.
    :param Sequence[str] roles: Returns users that match a list of roles. Valid roles: `ADMIN`, `DEVOPS`, `SUPPORT`, `MEMBER`.
    """
    ...
