
# LGL quadrature constants based on https://doi.org/10.21914/anziamj.v47i0.1033

n_nodes = 5
nodes = [0.0, 0.172673164646011, 0.5, 0.827326835353989, 1.0]
integration_matrix = [
    [ 0.0677284321861569,  0.119744769343412,  -0.0217357218665581,   0.0106358242254155, -0.00370013924241453],
    [           0.040625,  0.303184183323043,    0.177777777777778,  -0.0309619611008206,             0.009375],
    [ 0.0537001392424145,  0.261586397996807,    0.377291277422114,    0.152477452878811,  -0.0177284321861569],
    [               0.05,  0.272222222222222,    0.355555555555556,    0.272222222222222,                 0.05]
]

integration_weights = \
    [               0.05,  0.272222222222222,    0.355555555555556,    0.272222222222222,                 0.05]

interpolation_weights = [14.0, -32.6666666666667, 37.3333333333333, -32.6666666666667, 14.0]

interpolation_nodes = [0.0, 0.005, 0.01, 0.015, 0.02, 0.025, 0.03, 0.035, 0.04, 0.045, 0.05, 0.055, 0.06, 0.065, 0.07, 0.075, 0.08, 0.085, 0.09, 0.095, 0.1, 0.105, 0.11, 0.115, 0.12, 0.125, 0.13, 0.135, 0.14, 0.145, 0.15, 0.155, 0.16, 0.165, 0.17, 0.175, 0.18, 0.185, 0.19, 0.195, 0.2, 0.205, 0.21, 0.215, 0.22, 0.225, 0.23, 0.235, 0.24, 0.245, 0.25, 0.255, 0.26, 0.265, 0.27, 0.275, 0.28, 0.285, 0.29, 0.295, 0.3, 0.305, 0.31, 0.315, 0.32, 0.325, 0.33, 0.335, 0.34, 0.345, 0.35, 0.355, 0.36, 0.365, 0.37, 0.375, 0.38, 0.385, 0.39, 0.395, 0.4, 0.405, 0.41, 0.415, 0.42, 0.425, 0.43, 0.435, 0.44, 0.445, 0.45, 0.455, 0.46, 0.465, 0.47, 0.475, 0.48, 0.485, 0.49, 0.495, 0.5, 0.505, 0.51, 0.515, 0.52, 0.525, 0.53, 0.535, 0.54, 0.545, 0.55, 0.555, 0.56, 0.565, 0.57, 0.575, 0.58, 0.585, 0.59, 0.595, 0.6, 0.605, 0.61, 0.615, 0.62, 0.625, 0.63, 0.635, 0.64, 0.645, 0.65, 0.655, 0.66, 0.665, 0.67, 0.675, 0.68, 0.685, 0.69, 0.695, 0.7, 0.705, 0.71, 0.715, 0.72, 0.725, 0.73, 0.735, 0.74, 0.745, 0.75, 0.755, 0.76, 0.765, 0.77, 0.775, 0.78, 0.785, 0.79, 0.795, 0.8, 0.805, 0.81, 0.815, 0.82, 0.825, 0.83, 0.835, 0.84, 0.845, 0.85, 0.855, 0.86, 0.865, 0.87, 0.875, 0.88, 0.885, 0.89, 0.895, 0.9, 0.905, 0.91, 0.915, 0.92, 0.925, 0.93, 0.935, 0.94, 0.945, 0.95, 0.955, 0.96, 0.965, 0.97, 0.975, 0.98, 0.985, 0.99, 0.995, 1.0]

interpolation_matrix = [
[1.0, 0.0, 0.0, 0.0, 0.0],
[0.950745633749998, 0.06615269901517824, -0.025609309999999927, 0.013488593484821855, -0.0047776162499999905],
[0.902965139999998, 0.12951851429120534, -0.04914095999999985, 0.025778165708794806, -0.00912085999999998],
[0.856632583749998, 0.1901537303355475, -0.07065010999999978, 0.03690896216445268, -0.01304516624999997],
[0.8117222399999982, 0.24811414165567094, -0.09019135999999973, 0.04692073834432932, -0.016565759999999964],
[0.7682085937499982, 0.30345505275904183, -0.10781874999999969, 0.05585275974095853, -0.019697656249999952],
[0.7260663399999981, 0.3562312781531262, -0.1235857599999996, 0.06374380184687416, -0.022455659999999947],
[0.6852703837499982, 0.40649714234539047, -0.13754530999999953, 0.07063215015461001, -0.024854366249999937],
[0.6457958399999983, 0.4543064798433006, -0.14974975999999945, 0.07655560015669993, -0.02690815999999993],
[0.6076180337499985, 0.49971263515432285, -0.16025090999999944, 0.08155145734567774, -0.028631216249999925],
[0.5707124999999983, 0.5427684627859233, -0.16909999999999936, 0.08565653721407727, -0.03003749999999992],
[0.5350549837499983, 0.5835263272455682, -0.1763477099999993, 0.08890716525443235, -0.031140766249999906],
[0.5006214399999984, 0.6220381030407239, -0.18204415999999926, 0.09133917695927679, -0.0319545599999999],
[0.46738803374999843, 0.6583551746788563, -0.18623890999999923, 0.09298791782114446, -0.03249221624999989],
[0.4353311399999984, 0.6925284366674317, -0.18898095999999914, 0.09388824333256911, -0.032766859999999884],
[0.4044273437499985, 0.7246082935139163, -0.19031874999999915, 0.09407451898608465, -0.032791406249999884],
[0.37465343999999856, 0.754644659725776, -0.1903001599999991, 0.09358062027422485, -0.03257855999999987],
[0.34598643374999855, 0.7826869598104774, -0.18897250999999907, 0.09243993268952357, -0.032140816249999864],
[0.3184035399999987, 0.8087841282754864, -0.186382559999999, 0.09068535172451461, -0.03149045999999986],
[0.29188218374999864, 0.8329846096282691, -0.18257650999999897, 0.08834928287173184, -0.030639566249999858],
[0.2663999999999986, 0.8553363583762922, -0.1775999999999989, 0.08546364162370904, -0.02959999999999985],
[0.2419348337499987, 0.8758868390270209, -0.17149810999999893, 0.08205985347298007, -0.02838341624999985],
[0.2184647399999987, 0.8946830260879223, -0.16431535999999886, 0.07816885391207874, -0.02700125999999984],
[0.1959679837499987, 0.9117714040664621, -0.15609570999999883, 0.07382108843353888, -0.02546476624999983],
[0.17442303999999872, 0.9271979674701067, -0.1468825599999988, 0.06904651252989431, -0.023784959999999827],
[0.15380859374999875, 0.9410082208063222, -0.13671874999999878, 0.06387459169367889, -0.021972656249999823],
[0.13410353999999877, 0.9532471785825748, -0.1256465599999987, 0.0583343014174264, -0.020038459999999814],
[0.11528698374999877, 0.9639593653063303, -0.11370770999999869, 0.0524541271936707, -0.01799276624999981],
[0.09733823999999877, 0.9731888154850553, -0.10094335999999865, 0.046262064514945606, -0.0158457599999998],
[0.08023683374999886, 0.9809790736262158, -0.08739410999999868, 0.03978561887378498, -0.013607416249999806],
[0.06396249999999887, 0.9873731942372784, -0.07309999999999864, 0.03305180576272259, -0.011287499999999801],
[0.04849518374999888, 0.9924137418257085, -0.05810050999999861, 0.026087150674292292, -0.008895566249999796],
[0.0338150399999989, 0.9961427908989731, -0.04243455999999859, 0.018917689101027906, -0.00644095999999979],
[0.01990243374999891, 0.9986019259645377, -0.026140509999998552, 0.01156896653546327, -0.003932816249999785],
[0.006737939999998925, 0.9998322415298686, -0.009256159999998516, 0.004066038470132205, -0.0013800599999997801],
[-0.00569765625000106, 0.9998743421024323, 0.008181250000001517, -0.003566529602431461, 0.0012085937500002251],
[-0.017423360000000984, 0.9987683421896948, 0.02613504000000145, -0.011304662189693858, 0.003824640000000215],
[-0.028457966250000973, 0.9965538662991222, 0.044569090000001484, -0.019124773799121246, 0.006459783750000222],
[-0.03882006000000096, 0.9932700489381808, 0.06344784000000152, -0.027003768938179754, 0.009105940000000225],
[-0.04852801625000095, 0.9889555346143365, 0.08273629000000156, -0.03491904211433554, 0.01175523375000023],
[-0.057600000000000935, 0.9836484778350556, 0.10240000000000157, -0.042848477835054806, 0.014400000000000234],
[-0.06605396625000091, 0.9773865431078046, 0.12240509000000163, -0.050770450607803684, 0.01703278375000024],
[-0.07390766000000087, 0.9702069049400495, 0.14271824000000152, -0.05866382494004834, 0.019646340000000227],
[-0.08117861625000086, 0.962146247839256, 0.1633066900000016, -0.06650795533925503, 0.022233633750000235],
[-0.08788416000000085, 0.953240766312891, 0.18413824000000156, -0.07428268631288987, 0.024787840000000234],
[-0.09404140625000083, 0.9435261648684201, 0.20518125000000162, -0.08196835236841904, 0.027302343750000242],
[-0.09966726000000081, 0.9330376580133096, 0.22640464000000166, -0.0895457780133087, 0.029770740000000247],
[-0.10477841625000081, 0.921809970255026, 0.24777789000000172, -0.09699627775502505, 0.032186833750000254],
[-0.10939136000000074, 0.9098773361010349, 0.2692710400000016, -0.10430165610103417, 0.03454464000000023],
[-0.11352236625000073, 0.8972735000588032, 0.2908546900000016, -0.11144420755880237, 0.03683838375000024],
[-0.1171875000000007, 0.8840317166357966, 0.3125000000000016, -0.11840671663579576, 0.039062500000000236],
[-0.12040261625000069, 0.8701847503394814, 0.33417869000000167, -0.12517245783948053, 0.04121163375000024],
[-0.12318336000000069, 0.8557648756773235, 0.35586304000000163, -0.1317251956773228, 0.043280640000000245],
[-0.12554516625000067, 0.8408038771567894, 0.37752589000000164, -0.13804918465678878, 0.04526458375000024],
[-0.12750326000000067, 0.8253330492853453, 0.39914064000000177, -0.1441291692853447, 0.04715874000000025],
[-0.1290726562500006, 0.8093831965704572, 0.4206812500000018, -0.1499503840704566, 0.04895859375000025],
[-0.1302681600000006, 0.7929846335195913, 0.4421222400000018, -0.15549855351959074, 0.05065984000000024],
[-0.13110436625000058, 0.7761671846402137, 0.4634386900000018, -0.1607598921402133, 0.052258383750000234],
[-0.13159566000000056, 0.7589601844397912, 0.48460624000000163, -0.1657211044397904, 0.053750340000000243],
[-0.13175621625000056, 0.741392477425789, 0.5056010900000015, -0.1703693849257883, 0.05513203375000022],
[-0.13160000000000055, 0.7234924181056737, 0.5264000000000016, -0.17469241810567307, 0.05640000000000024],
[-0.1311407662500005, 0.7052878709869114, 0.5469802900000016, -0.17867837848691093, 0.057550983750000215],
[-0.1303920600000005, 0.6868062105769686, 0.5673198400000017, -0.18231593057696807, 0.05858194000000023],
[-0.12936721625000047, 0.6680743213833111, 0.5873970900000017, -0.18559422888331065, 0.05949003375000021],
[-0.12807936000000048, 0.6491185979134053, 0.6071910400000017, -0.18850291791340482, 0.060272640000000224],
[-0.12654140625000046, 0.6299649446747172, 0.6266812500000017, -0.19103213217471682, 0.060927343750000196],
[-0.12476606000000041, 0.610638776174713, 0.6458478400000016, -0.19317249617471274, 0.06145194000000022],
[-0.12276581625000042, 0.5911650169208591, 0.6646714900000018, -0.19491512442085884, 0.06184443375000022],
[-0.12055296000000039, 0.5715681014206214, 0.6831334400000016, -0.19625162142062114, 0.06210304000000021],
[-0.11813956625000038, 0.5518719741814663, 0.7012154900000017, -0.19717408168146597, 0.062226183750000205],
[-0.11553750000000032, 0.5321000897108595, 0.7189000000000016, -0.19767508971085943, 0.062212500000000205],
[-0.11275841625000035, 0.5122754125162682, 0.7361698900000015, -0.1977477200162677, 0.0620608337500002],
[-0.10981376000000036, 0.49242041710515727, 0.7530086400000016, -0.197385537105157, 0.0617702400000002],
[-0.10671476625000033, 0.4725570879849937, 0.7694002900000015, -0.1965825954849934, 0.06133998375000018],
[-0.10347246000000031, 0.4527069196632435, 0.7853294400000016, -0.19533343966324318, 0.06076954000000019],
[-0.1000976562500003, 0.4328909166473728, 0.8007812500000017, -0.19363310414737248, 0.060058593750000173],
[-0.09660096000000028, 0.4131295934448476, 0.8157414400000017, -0.19147711344484744, 0.05920704000000017],
[-0.09299276625000025, 0.39344297456313443, 0.8301962900000016, -0.18886148206313425, 0.05821498375000017],
[-0.08928326000000025, 0.37385059450969915, 0.8441326400000015, -0.18578271450969905, 0.05708274000000015],
[-0.08548241625000022, 0.3543714977920083, 0.8575378900000017, -0.18223780529200811, 0.055810833750000156],
[-0.0816000000000002, 0.33502423891752764, 0.8704000000000018, -0.17822423891752753, 0.05440000000000014],
[-0.0776455662500002, 0.31582688239372353, 0.8827074900000018, -0.17373998989372347, 0.052851183750000134],
[-0.07362846000000017, 0.29679700272806214, 0.8944494400000017, -0.16878352272806216, 0.05116554000000013],
[-0.06955781625000015, 0.2779516844280097, 0.9056154900000017, -0.1633537919280097, 0.04934443375000012],
[-0.06544256000000019, 0.2593075220010325, 0.9161958400000016, -0.1574502420010324, 0.04738944000000013],
[-0.061291406250000166, 0.2408806199545963, 0.9261812500000015, -0.15107280745459623, 0.04530234375000012],
[-0.057112860000000154, 0.22268659279616768, 0.9355630400000018, -0.14422191279616756, 0.04308514000000012],
[-0.05291521625000014, 0.20474056503321242, 0.9443330900000014, -0.13689847253321236, 0.040740033750000106],
[-0.04870656000000013, 0.18705717117319706, 0.9524838400000017, -0.129103891173197, 0.0382694400000001],
[-0.04449476625000011, 0.16965055572358753, 0.9600082900000017, -0.1208400632235875, 0.035675983750000084],
[-0.040287500000000094, 0.15253437319185018, 0.9669000000000018, -0.11210937319185016, 0.032962500000000075],
[-0.03609221625000008, 0.13572178808545105, 0.9731530900000015, -0.10291469558545102, 0.030132033750000065],
[-0.03191616000000007, 0.11922547491185641, 0.9787622400000017, -0.09325939491185639, 0.027187840000000057],
[-0.027766366250000046, 0.10305761817853233, 0.9837226900000016, -0.08314732567853232, 0.024133383750000043],
[-0.023649660000000038, 0.0872299123929451, 0.9880302400000017, -0.0725828323929451, 0.020972340000000037],
[-0.019572656250000018, 0.07175356206256078, 0.9916812500000015, -0.0615707495625608, 0.017708593750000022],
[-0.015541760000000052, 0.0566392816948458, 0.9946726400000017, -0.05011640169484578, 0.014346240000000047],
[-0.01156316625000004, 0.041897295797265956, 0.9970018900000016, -0.03822560329726594, 0.010889583750000037],
[-0.007642860000000026, 0.027537338877287588, 0.9986670400000016, -0.025904658877287583, 0.007343140000000024],
[-0.0037866162500000133, 0.013568655442376884, 0.9996666900000019, -0.013160362942376881, 0.0037116337500000133],
[0.0, 0.0, 1.0, 0.0, 0.0],
[0.003711633750000013, -0.013160362942376878, 0.9996666900000017, 0.013568655442376882, -0.0037866162500000133],
[0.007343140000000027, -0.025904658877287583, 0.9986670400000017, 0.02753733887728759, -0.007642860000000027],
[0.010889583750000037, -0.03822560329726594, 0.9970018900000017, 0.041897295797265956, -0.01156316625000004],
[0.01434624000000005, -0.05011640169484578, 0.9946726400000017, 0.056639281694845806, -0.015541760000000055],
[0.01770859375000006, -0.06157074956256093, 0.9916812500000015, 0.07175356206256096, -0.019572656250000067],
[0.020972340000000072, -0.07258283239294522, 0.9880302400000016, 0.08722991239294525, -0.023649660000000083],
[0.024133383750000077, -0.08314732567853246, 0.9837226900000016, 0.10305761817853251, -0.027766366250000094],
[0.027187840000000088, -0.0932593949118565, 0.9787622400000017, 0.11922547491185656, -0.03191616000000011],
[0.030132033750000103, -0.10291469558545115, 0.9731530900000015, 0.13572178808545124, -0.03609221625000012],
[0.03296250000000011, -0.11210937319185026, 0.9669000000000015, 0.15253437319185034, -0.04028750000000014],
[0.03567598375000012, -0.1208400632235876, 0.9600082900000017, 0.16965055572358775, -0.044494766250000164],
[0.03826944000000013, -0.1291038911731971, 0.9524838400000016, 0.18705717117319723, -0.048706560000000176],
[0.04074003375000014, -0.13689847253321247, 0.9443330900000015, 0.20474056503321264, -0.05291521625000019],
[0.04308514000000014, -0.1442219127961676, 0.9355630400000016, 0.22268659279616784, -0.0571128600000002],
[0.045302343750000154, -0.15107280745459634, 0.9261812500000015, 0.2408806199545966, -0.06129140625000023],
[0.04738944000000011, -0.15745024200103233, 0.9161958400000016, 0.25930752200103235, -0.06544256000000015],
[0.049344433750000125, -0.16335379192800972, 0.9056154900000017, 0.2779516844280097, -0.06955781625000015],
[0.05116554000000013, -0.16878352272806216, 0.8944494400000017, 0.29679700272806214, -0.07362846000000017],
[0.052851183750000134, -0.1737399898937235, 0.8827074900000017, 0.31582688239372353, -0.07764556625000019],
[0.05440000000000014, -0.1782242389175275, 0.8704000000000017, 0.33502423891752764, -0.0816000000000002],
[0.055810833750000156, -0.18223780529200811, 0.8575378900000017, 0.35437149779200827, -0.08548241625000023],
[0.05708274000000016, -0.18578271450969908, 0.8441326400000017, 0.37385059450969926, -0.08928326000000025],
[0.05821498375000017, -0.18886148206313425, 0.8301962900000017, 0.39344297456313443, -0.09299276625000025],
[0.05920704000000017, -0.19147711344484744, 0.8157414400000017, 0.41312959344484756, -0.09660096000000026],
[0.060058593750000173, -0.19363310414737245, 0.8007812500000017, 0.43289091664737267, -0.10009765625000029],
[0.06076954000000019, -0.19533343966324315, 0.7853294400000017, 0.4527069196632435, -0.10347246000000032],
[0.061339983750000195, -0.19658259548499343, 0.7694002900000017, 0.47255708798499374, -0.10671476625000033],
[0.061770240000000184, -0.197385537105157, 0.7530086400000017, 0.4924204171051573, -0.10981376000000036],
[0.0620608337500002, -0.1977477200162677, 0.7361698900000015, 0.5122754125162681, -0.11275841625000035],
[0.062212500000000205, -0.19767508971085943, 0.7189000000000016, 0.5321000897108599, -0.11553750000000038],
[0.062226183750000205, -0.19717408168146594, 0.7012154900000016, 0.5518719741814664, -0.11813956625000041],
[0.0621030400000002, -0.19625162142062114, 0.6831334400000016, 0.5715681014206216, -0.12055296000000043],
[0.06184443375000019, -0.1949151244208588, 0.6646714900000016, 0.5911650169208593, -0.12276581625000045],
[0.061451940000000205, -0.19317249617471272, 0.6458478400000015, 0.6106387761747134, -0.12476606000000046],
[0.06092734375000021, -0.1910321321747168, 0.6266812500000015, 0.6299649446747174, -0.12654140625000046],
[0.06027264000000021, -0.18850291791340482, 0.6071910400000015, 0.6491185979134055, -0.1280793600000005],
[0.05949003375000021, -0.18559422888331067, 0.5873970900000014, 0.6680743213833114, -0.12936721625000047],
[0.058581940000000214, -0.18231593057696804, 0.5673198400000015, 0.6868062105769689, -0.1303920600000005],
[0.057550983750000215, -0.1786783784869109, 0.5469802900000014, 0.7052878709869117, -0.13114076625000054],
[0.056400000000000214, -0.17469241810567301, 0.5264000000000013, 0.7234924181056738, -0.13160000000000055],
[0.055132033750000246, -0.17036938492578832, 0.5056010900000019, 0.7413924774257887, -0.13175621625000056],
[0.053750340000000243, -0.1657211044397904, 0.4846062400000018, 0.7589601844397909, -0.13159566000000056],
[0.05225838375000024, -0.16075989214021333, 0.46343869000000176, 0.7761671846402138, -0.13110436625000058],
[0.05065984000000025, -0.15549855351959077, 0.44212224000000183, 0.7929846335195914, -0.1302681600000006],
[0.048958593750000244, -0.1499503840704566, 0.4206812500000018, 0.8093831965704572, -0.12907265625000064],
[0.04715874000000024, -0.1441291692853447, 0.39914064000000177, 0.8253330492853452, -0.12750326000000065],
[0.04526458375000024, -0.1380491846567888, 0.3775258900000017, 0.8408038771567895, -0.12554516625000067],
[0.04328064000000024, -0.1317251956773228, 0.35586304000000174, 0.8557648756773235, -0.12318336000000069],
[0.04121163375000025, -0.12517245783948053, 0.33417869000000167, 0.8701847503394813, -0.1204026162500007],
[0.039062500000000236, -0.11840671663579576, 0.31250000000000167, 0.8840317166357966, -0.11718750000000072],
[0.03683838375000024, -0.11144420755880237, 0.2908546900000016, 0.897273500058803, -0.11352236625000073],
[0.03454464000000024, -0.10430165610103416, 0.26927104000000157, 0.9098773361010349, -0.10939136000000074],
[0.032186833750000234, -0.09699627775502499, 0.24777789000000155, 0.9218099702550258, -0.10477841625000074],
[0.029770740000000226, -0.08954577801330865, 0.22640464000000152, 0.9330376580133094, -0.09966726000000076],
[0.02730234375000022, -0.081968352368419, 0.20518125000000148, 0.9435261648684201, -0.0940414062500008],
[0.02478784000000022, -0.07428268631288984, 0.18413824000000145, 0.9532407663128908, -0.0878841600000008],
[0.022233633750000217, -0.06650795533925498, 0.16330669000000145, 0.962146247839256, -0.0811786162500008],
[0.019646340000000213, -0.0586638249400483, 0.1427182400000014, 0.9702069049400494, -0.07390766000000082],
[0.017032783750000207, -0.050770450607803594, 0.12240509000000138, 0.9773865431078047, -0.06605396625000083],
[0.014400000000000204, -0.0428484778350547, 0.10240000000000136, 0.9836484778350557, -0.05760000000000084],
[0.011755233750000201, -0.034919042114335455, 0.08273629000000132, 0.9889555346143365, -0.04852801625000084],
[0.009105940000000198, -0.027003768938179656, 0.0634478400000013, 0.9932700489381807, -0.03882006000000084],
[0.0064597837500001915, -0.019124773799121156, 0.044569090000001275, 0.9965538662991222, -0.028457966250000855],
[0.0038246400000001863, -0.011304662189693773, 0.026135040000001247, 0.9987683421896948, -0.017423360000000856],
[0.001208593750000182, -0.0035665296024313333, 0.008181250000001222, 0.9998743421024323, -0.00569765625000086],
[-0.0013800599999998229, 0.004066038470132331, -0.009256159999998804, 0.9998322415298689, 0.006737939999999139],
[-0.003932816249999771, 0.01156896653546323, -0.02614050999999846, 0.9986019259645377, 0.019902433749998838],
[-0.006440959999999777, 0.018917689101027868, -0.0424345599999985, 0.9961427908989733, 0.03381503999999883],
[-0.008895566249999784, 0.026087150674292257, -0.05810050999999854, 0.9924137418257089, 0.04849518374999882],
[-0.011287499999999789, 0.033051805762722555, -0.07309999999999857, 0.9873731942372785, 0.0639624999999988],
[-0.013607416249999796, 0.03978561887378495, -0.08739410999999864, 0.9809790736262161, 0.08023683374999879],
[-0.0158457599999998, 0.04626206451494561, -0.10094335999999866, 0.9731888154850554, 0.09733823999999877],
[-0.01799276624999981, 0.0524541271936707, -0.1137077099999987, 0.9639593653063303, 0.11528698374999877],
[-0.020038459999999817, 0.058334301417426404, -0.1256465599999987, 0.9532471785825746, 0.13410353999999874],
[-0.021972656249999823, 0.06387459169367889, -0.13671874999999878, 0.9410082208063222, 0.15380859374999875],
[-0.023784959999999827, 0.06904651252989433, -0.14688255999999883, 0.9271979674701067, 0.17442303999999875],
[-0.025464766249999837, 0.07382108843353888, -0.15609570999999886, 0.911771404066462, 0.19596798374999874],
[-0.02700125999999984, 0.07816885391207874, -0.16431535999999888, 0.8946830260879222, 0.2184647399999987],
[-0.02838341624999985, 0.08205985347298009, -0.17149810999999893, 0.8758868390270209, 0.24193483374999875],
[-0.02959999999999985, 0.08546364162370905, -0.17759999999999898, 0.855336358376292, 0.26639999999999875],
[-0.030639566249999858, 0.08834928287173185, -0.182576509999999, 0.832984609628269, 0.2918821837499988],
[-0.031490459999999866, 0.09068535172451463, -0.18638255999999903, 0.8087841282754862, 0.31840353999999876],
[-0.032140816249999864, 0.09243993268952357, -0.18897250999999907, 0.7826869598104772, 0.3459864337499987],
[-0.03257855999999987, 0.09358062027422487, -0.19030015999999914, 0.7546446597257758, 0.3746534399999988],
[-0.032791406249999884, 0.09407451898608464, -0.19031874999999912, 0.7246082935139159, 0.4044273437499988],
[-0.032766859999999884, 0.09388824333256911, -0.18898095999999914, 0.6925284366674314, 0.4353311399999988],
[-0.03249221624999989, 0.09298791782114443, -0.1862389099999992, 0.658355174678856, 0.4673880337499988],
[-0.031954559999999896, 0.09133917695927676, -0.1820441599999992, 0.6220381030407236, 0.5006214399999988],
[-0.031140766249999893, 0.08890716525443232, -0.17634770999999924, 0.5835263272455679, 0.5350549837499988],
[-0.030037499999999898, 0.08565653721407723, -0.16909999999999925, 0.5427684627859228, 0.570712499999999],
[-0.028631216249999893, 0.08155145734567769, -0.1602509099999993, 0.4997126351543223, 0.6076180337499989],
[-0.026908159999999945, 0.07655560015669997, -0.14974975999999954, 0.4543064798433009, 0.645795839999998],
[-0.024854366249999954, 0.07063215015461005, -0.13754530999999962, 0.4064971423453908, 0.685270383749998],
[-0.02245565999999996, 0.06374380184687421, -0.12358575999999968, 0.35623127815312655, 0.7260663399999981],
[-0.019697656249999966, 0.05585275974095857, -0.10781874999999973, 0.30345505275904205, 0.7682085937499981],
[-0.016565759999999978, 0.04692073834432935, -0.09019135999999979, 0.2481141416556712, 0.8117222399999982],
[-0.013045166249999981, 0.03690896216445271, -0.07065010999999985, 0.1901537303355477, 0.8566325837499981],
[-0.009120859999999988, 0.025778165708794827, -0.04914095999999989, 0.12951851429120545, 0.9029651399999982],
[-0.004777616249999995, 0.013488593484821867, -0.02560930999999995, 0.06615269901517828, 0.9507456337499981],
[0.0, 0.0, 0.0, 0.0, 1.0]
]


if __name__ == '__main__':
    import numpy as np
    M = np.matrix(integration_matrix)
    n = np.array(np.matrix(nodes).T)
    n1 = n[1:,:]

    # Check that polynomials are integrated correctly.
    # The quadrature must integrate low order polynomials exactly.
    for i in range(5):
        e = (i+1) * M@(n**i) - (n1**(i+1))
        print(e)
        assert np.max(np.abs(e)) < 1e-14
