from enum import Enum


class WeatherModel(Enum):
    """Enumeration of weather models"""

    DWD_ICON_EU = "dwd-icon-eu"
    DWD_ICON_EU_EPS = "dwd-icon-eu-eps"
    DWD_ICON_GLOBAL = "dwd-icon-global"
    DWD_COSMO_D2 = "dwd-cosmo-d2"
    DWD_COSMO_D2_EPS = "dwd-cosmo-d2-eps"
    NCEP_GFS_025 = "ncep-gfs-025"
    NCEP_GFS_050 = "ncep-gfs-050"
    NCEP_GFS_100 = "ncep-gfs-100"
    METEO_FRANCE_AROME = "meteo-france-arome"
    KNMI_HARMONIE = "knmi-harmonie"
    ARPEGE = "arpege"
    GEOS5 = "geos_5"

    # For testing purposes.
    UNKNOWN = "unknown"


class LevelTypes(Enum):
    """Enumeration of weather models levels type"""

    SINGLE_LEVEL = "single_level"
    MULTI_LEVEL = "multi_level"
    HEIGHT_ABOVE_GROUND = "heightAboveGround"
    ENTIRE_ATMOSPHERE = "entireAtmosphere"
    ISOBARIC_HPA = "isobaricInhPa"
    ISOBARIC_PA = "isobaricInPa"
    SURFACE = "surface"
    SIGMA = "sigma"
    SIGMA_LAYER = "sigmaLayer"
    HYBRID = "hybrid"
    TROPOPAUSE = "tropopause"


class ForecastVariables(Enum):
    """Unified NWP variables enumerations"""

    AIR_TEMPERATURE_2M = "air_temperature_2m"
    SNOW_HEIGHT = "snow_height"
    MAX_WIND_GUST_10M = "max_wind_gust_10m"
    WIND_U_10M = "wind_u_10m"
    WIND_V_10M = "wind_v_10m"
    DEWPOINT_2M = "dewpoint_2m"
    TOTAL_PRECIPITATION = "total_precipitation"
    CONVECTIVE_SNOW = "convective_snow"
    GRID_SCALE_SNOW = "grid_scale_snow"
    CONVECTIVE_RAIN = "convective_rain"
    GRID_SCALE_RAIN = "grid_scale_rain"
    GLOBAL_HORIZONTAL_IRRADIANCE = "global_horizontal_irradiance"
    DIFFUSE_HORIZONTAL_IRRADIANCE = "diffuse_horizontal_irradiance"
    DIRECT_NORMAL_IRRADIANCE = "direct_normal_irradiance"
    MIXED_LAYER_CAPE = "mixed_layer_cape"
    MOST_UNSTABLE_CAPE = "most_unstable_cape"
    SURFACE_BASED_CAPE = "surface_based_cape"
    PRESSURE_MEAN_SEA_LEVEL = "pressure_mean_sea_level"
    PRESSURE_MEAN_SEA_LEVEL_ETA_LEVEL = "pressure_mean_sea_level_eta_level"
    MAX_AIR_TEMPERATURE_2M = "max_air_temperature_2m"
    MIN_AIR_TEMPERATURE_2M = "min_air_temperature_2m"
    WEATHER_SYNOP_CODE = "weather_synop_code"
    SOIL_TEMPERATURE = "soil_temperature"
    TOTAL_CLOUD_COVER = "total_cloud_cover"
    RELATIVE_HUMIDITY_2M = "relative_humidity_2m"
    RELATIVE_HUMIDITY = "relative_humidity"
    GEOPOTENTIAL_HEIGHT = "geopotential_height"
    SUNSHINE_DURATION = "sunshine_duration"
    LOW_LEVEL_CLOUDS = "low_level_clouds"
    MEDIUM_LEVEL_CLOUDS = "medium_level_clouds"
    HIGH_LEVEL_CLOUDS = "high_level_clouds"
    TOTAL_PRECIPITATION_RATE = "total_precipitation_rate"
    CONVECTIVE_PRECIPITATION_RATE = "convective_precipitation_rate"
    SUPERCELL_DETECTION_INDEX_1 = "supercell_detection_index_1"
    SUPERCELL_DETECTION_INDEX_2 = "supercell_detection_index_2"
    ALBEDO = "albedo"
    MAX_RADAR_REFLECTIVITY = "max_radar_reflectivity"
    WIND_U = "wind_u"
    WIND_V = "wind_v"
    TURBULENT_KINETIC_ENERGY = "turbulent_kinetic_energy"
    SPECIFIC_HUMIDITY = "specific_humidity"
    SURFACE_SPECIFIC_HUMIDITY = "surface_specific_humidity"
    PRESSURE_SURFACE = "pressure_surface"
    SOIL_MOISTURE_CONTENT = "soil_moisture_content"
    APPARENT_TEMPERATURE = "apparent_temperature"
    STORM_MOTION_U = "storm_motion_u"
    STORM_MOTION_V = "storm_motion_v"
    STORM_RELATIVE_HELICITY = "storm_relative_helicity"
    ICE_GROWTH_RATE = "ice_growth_rate"
    CLOUD_MIXING_RATIO = "cloud_mixing_ratio"
    ICE_WATER_MIXING_RATIO = "ice_water_mixing_ratio"
    RAIN_WATER_MIXING_RATIO = "rain_water_mixing_ratio"
    SNOW_WATER_MIXING_RATIO = "snow_water_mixing_ratio"
    GRAUPEL_MIXING_RATIO = "graupel_mixing_ratio"
    ABSOLUTE_VORTICITY = "absolute_vorticity"
    OZONE_MIXING_RATIO = "ozone_mixing_ratio"
    VERTICAL_VELOCITY = "vertical_velocity"
    GEOMETRIC_VERTICAL_VELOCITY = "geometric_vertical_velocity"
    FIVE_WAVE_GEOPOTENTIAL_HEIGHT = "five_wave_geopotential_height"
    ICING_SEVERITY = "icing_severity"
    ICAO_STANDARD_ATMOSPHERE = "icao_standard_atmosphere"
    UPWARD_SHORT_WAVE_RADIATION = "upward_short_wave_radiation"
    UPWARD_LONG_WAVE_RADIATION = "upward_long_wave_radiation"
    DOWNWARD_SHORT_WAVE_RADIATION = "downward_short_wave_radiation"
    DOWNWARD_LONG_WAVE_RADIATION = "downward_long_wave_radiation"
    CONVECTIVE_INHIBITION = "convective_inhibition"
    PRESSURE_LEVEL_PARCEL_LIFT = "pressure_level_parcel-lift"
    potential_temperature = "potential_temperature"
    SEA_ICE_COVER = "sea_ice_cover"
    SURFACE_AIR_PRESSURE = "surface_air_pressure"
    LAND_SEA_MASK = "land_sea_mask"
    VISIBILITY = "visibility"
    CONVECTIVE_PRECIPITATION_WATER = "convective_precipitation_water"
    OROGRAPHY = "orography"
    LATENT_HEAT_FLUX_NET = "latent_heat_flux_net"
    SENSIBLE_HEAT_FLUX_NET = "sensible_heat_flux_net"
    CATEGORICAL_FREEZING_RAIN = "categorical_freezing_rain"
    CATEGORICAL_ICE_PELLETS = "categorical_ice_pellets"
    PERCENT_FROZEN_PRECIPITATION = "percent_frozen_precipitation"
    POTENTIAL_EVAPORATION_RATE = "potential_evaporation_rate"
    SNOW_WATER_EQUIVALENT_ACCUMULATED = "snow_water_equivalent_accumulated"
    MOMENTUM_FLUX_U = "momentum_flux_u"
    MOMENTUM_FLUX_V = "momentum_flux_v"
    ZONAL_FLUX_GRAVITY_WAVE_STRESS = "zonal_flux_gravity_wave_stress"
    MERIDONAL_FLUX_GRAVITY_WAVE_STRESS = "meridonal_flux_gravity_wave_stress"
    BOUNDARY_LAYER_HEIGHT = "boundary_layer_height"
    LIFTED_INDEX = "lifted_index"
    LIFTED_INDEX_FOUR_LAYER = "lifted_index_four_layer"
    WATER_RUNOFF = "water_runoff"
    GROUND_HEAT_FLUX = "ground_heat_flux"
    HAINES_INDEX = "haines_index"
    WILTING_POINT = "wilting_point"
    LAND_SEA_COVERAGE = "land_sea_coverage"
    FIELD_CAPACITY = "field_capacity"
    PRECIPITABLE_WATER = "precipitable_water"
    CLOUD_WATER = "cloud_water"
    CLOUD_WORK_FUNCTION = "cloud_work_function"
    OZONE_TOTALE = "ozone_totale"
    VENTILATION_RATE = "ventilation_rate"
    MAX_WIND_GUST_U = "max_wind_gust_u"
    MAX_WIND_GUST_V = "max_wind_gust_v"
    GRAUPEL = "graupel"
    MIXED_LAYER_DEPTH = "mixed_layer_depth"
    SNOW_RATE = "snow_rate"
