from typing import Any, Dict, List, Type, TypeVar, Union

import attr

from ..types import UNSET, Unset

T = TypeVar("T", bound="NullRequest")

@attr.s(auto_attribs=True)
class NullRequest:
    """
    Attributes:
        non_existant_property (Union[Unset, int]):
    """

    non_existant_property: Union[Unset, int] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)


    def to_dict(self) -> Dict[str, Any]:
        non_existant_property = self.non_existant_property

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({
        })
        if non_existant_property is not UNSET:
            field_dict["nonExistantProperty"] = non_existant_property

        return field_dict



    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        non_existant_property = d.pop("nonExistantProperty", UNSET)

        null_request = cls(
            non_existant_property=non_existant_property,
        )

        null_request.additional_properties = d
        return null_request

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
