# Generated by Django 4.0.4 on 2022-05-30 17:44

import django.contrib.postgres.fields
import django.core.serializers.json
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('dcim', '0153_created_datetimefield'),
        ('extras', '0073_journalentry_tags_custom_fields'),
        ('ipam', '0057_created_datetimefield'),
    ]

    operations = [
        migrations.CreateModel(
            name='StaticRoute',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('next_hop', django.contrib.postgres.fields.ArrayField(base_field=models.GenericIPAddressField(), null=True, size=None)),
                ('distance', models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(255)])),
                ('comments', models.TextField(blank=True)),
                ('destination_prefix', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='ipam.prefix')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='dcim.device')),
                ('site', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='%(class)s_related', to='dcim.site')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('vrf', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='ipam.vrf')),
            ],
            options={
                'verbose_name_plural': 'Static Routes',
                'ordering': ('device', 'vrf', 'destination_prefix', 'next_hop'),
                'unique_together': {('device', 'vrf', 'destination_prefix')},
            },
        ),
    ]
