import ptrade.component.rule


class MyRule(ptrade.component.rule.Rule):
    # [交易规则] -----------------------------------------------------------
    # T = 0 -> T0交易
    # T = 1 -> T1交易 ...
    T = 0
    # [时区] --------------------------------------------------------------
    TIMEZONE = 'Asia/Shanghai'
    # TIMEZONE = 'America/New_York'
    # [账户余额] -----------------------------------------------------------
    ACCOUNT_MONEY = 1000
    # [购买金额] -----------------------------------------------------------
    # 单次开仓的默认金额占比
    BUY_MONEY_RATE = None
    # 单次开仓的默认金额
    BUY_MONEY = 100
    # [止盈止损] -----------------------------------------------------------
    # 多单止盈，挂单价格
    LONG_TP_RATE = None
    # 多单止损，出发止损价格，以市价单平仓
    LONG_SL_RATE = None
    # 空单止盈，挂单价格
    SHORT_TP_RATE = None
    # 空单止损，出发止损价格，以市价单平仓
    SHORT_SL_RATE = None
    # [杠杆] ---------------------------------------------------------------
    # 多单杠杆
    LONG_LEVER = 1
    # 空单杠杆
    SHORT_LEVER = 1
    # [仓位] ---------------------------------------------------------------
    # 多单仓位
    LONG_POSITION = 5
    # 空单仓位
    SHORT_POSITION = 5
    # 总仓位
    POSITION = 10
    # [最长订单时间（分钟）] ---------------------------------------------------
    # 可以执行开仓的时间
    BUY_PERIODS = [
        ['00:00:00', '23:59:59']  # 可以开仓时间段为00:00:00 ~ 23:59:59
    ]
    # 可以执行平仓的时间
    SELL_PERIODS = [
        ['00:00:00', '23:59:59']  # 可以平仓时间段为00:00:00 ~ 23:59:59
    ]
    # 运行抛出的时间
    THROW_PERIODS = []
    # [最长订单时间（分钟）] ---------------------------------------------------
    MAX_HOLD_ORDER_MINUTE = None
    # [手续费率] -------------------------------------------------------------
    # 开仓的手续费
    BUY_COMMISSION_RATE = 0.00035
    # 平仓的手续费
    SELL_COMMISSION_RATE = 0.00035
