if(typeof OpenAssessment=="undefined"||!OpenAssessment){OpenAssessment={}}if(typeof window.gettext==="undefined"){window.gettext=function(text){return text}}if(typeof window.ngetgext==="undefined"){window.ngettext=function(singularText,pluralText,n){if(n>1){return pluralText}else{return singularText}}}if(typeof window.Logger==="undefined"){window.Logger={log:function(){}}}if(typeof window.MathJax==="undefined"){window.MathJax={Hub:{Typeset:function(){},Queue:function(){}}}}if(typeof OpenAssessment.Server==="undefined"||!OpenAssessment.Server){OpenAssessment.Server=function(runtime,element){this.runtime=runtime;this.element=element};var jsonContentType="application/json; charset=utf-8";OpenAssessment.Server.prototype={url:function(handler){return this.runtime.handlerUrl(this.element,handler)},render:function(component){var view=this;var url=this.url("render_"+component);return $.Deferred(function(defer){$.ajax({url:url,type:"POST",dataType:"html"}).done(function(data){defer.resolveWith(view,[data])}).fail(function(){defer.rejectWith(view,[gettext("This section could not be loaded.")])})}).promise()},renderLatex:function(element){element.filter(".allow--latex").each(function(){MathJax.Hub.Queue(["Typeset",MathJax.Hub,this])})},renderContinuedPeer:function(){var view=this;var url=this.url("render_peer_assessment");return $.Deferred(function(defer){$.ajax({url:url,type:"POST",dataType:"html",data:{continue_grading:true}}).done(function(data){defer.resolveWith(view,[data])}).fail(function(){defer.rejectWith(view,[gettext("This section could not be loaded.")])})}).promise()},studentInfo:function(studentUsername,options){var url=this.url("render_student_info");return $.Deferred(function(defer){$.ajax({url:url,type:"POST",dataType:"html",data:_.extend({student_username:studentUsername},options)}).done(function(data){defer.resolveWith(this,[data])}).fail(function(){defer.rejectWith(this,[gettext("This section could not be loaded.")])})}).promise()},staffGradeForm:function(){var url=this.url("render_staff_grade_form");return $.Deferred(function(defer){$.ajax({url:url,type:"POST",dataType:"html"}).done(function(data){defer.resolveWith(this,[data])}).fail(function(){defer.rejectWith(this,[gettext("The staff assessment form could not be loaded.")])})}).promise()},staffGradeCounts:function(){var url=this.url("render_staff_grade_counts");return $.Deferred(function(defer){$.ajax({url:url,type:"POST",dataType:"html"}).done(function(data){defer.resolveWith(this,[data])}).fail(function(){defer.rejectWith(this,[gettext("The display of ungraded and checked out responses could not be loaded.")])})}).promise()},submit:function(submission){var url=this.url("submit");return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:JSON.stringify({submission:submission}),contentType:jsonContentType}).done(function(data){var success=data[0];if(success){var studentId=data[1];var attemptNum=data[2];defer.resolveWith(this,[studentId,attemptNum])}else{var errorNum=data[1];var errorMsg=data[2];defer.rejectWith(this,[errorNum,errorMsg])}}).fail(function(){defer.rejectWith(this,["AJAX",gettext("This response could not be submitted.")])})}).promise()},save:function(submission){var url=this.url("save_submission");return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:JSON.stringify({submission:submission}),contentType:jsonContentType}).done(function(data){if(data.success){defer.resolve()}else{defer.rejectWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("This response could not be saved.")])})}).promise()},submitFeedbackOnAssessment:function(text,options){var url=this.url("submit_feedback");var payload=JSON.stringify({feedback_text:text,feedback_options:options});return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:payload,contentType:jsonContentType}).done(function(data){if(data.success){defer.resolve()}else{defer.rejectWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("This feedback could not be submitted.")])})}).promise()},submitAssessment:function(assessmentType,payload){var url=this.url(assessmentType);return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:JSON.stringify(payload),contentType:jsonContentType}).done(function(data){if(data.success){defer.resolve()}else{defer.rejectWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("This assessment could not be submitted.")])})}).promise()},peerAssess:function(optionsSelected,criterionFeedback,overallFeedback,submissionID){return this.submitAssessment("peer_assess",{options_selected:optionsSelected,criterion_feedback:criterionFeedback,overall_feedback:overallFeedback,submission_uuid:submissionID})},selfAssess:function(optionsSelected,criterionFeedback,overallFeedback){return this.submitAssessment("self_assess",{options_selected:optionsSelected,criterion_feedback:criterionFeedback,overall_feedback:overallFeedback})},staffAssess:function(optionsSelected,criterionFeedback,overallFeedback,submissionID,assessType){return this.submitAssessment("staff_assess",{options_selected:optionsSelected,criterion_feedback:criterionFeedback,overall_feedback:overallFeedback,submission_uuid:submissionID,assess_type:assessType})},trainingAssess:function(optionsSelected){var url=this.url("training_assess");var payload=JSON.stringify({options_selected:optionsSelected});return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:payload,contentType:jsonContentType}).done(function(data){if(data.success){defer.resolveWith(this,[data.corrections])}else{defer.rejectWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("This assessment could not be submitted.")])})})},scheduleTraining:function(){var url=this.url("schedule_training");return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:'""',contentType:jsonContentType}).done(function(data){if(data.success){defer.resolveWith(this,[data.msg])}else{defer.rejectWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("This assessment could not be submitted.")])})})},rescheduleUnfinishedTasks:function(){var url=this.url("reschedule_unfinished_tasks");return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:'""',contentType:jsonContentType}).done(function(data){if(data.success){defer.resolveWith(this,[data.msg])}else{defer.rejectWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("One or more rescheduling tasks failed.")])})})},updateEditorContext:function(options){var url=this.url("update_editor_context");var payload=JSON.stringify({prompts:options.prompts,prompts_type:options.prompts_type,feedback_prompt:options.feedbackPrompt,feedback_default_text:options.feedback_default_text,title:options.title,submission_start:options.submissionStart,submission_due:options.submissionDue,criteria:options.criteria,assessments:options.assessments,editor_assessments_order:options.editorAssessmentsOrder,text_response:options.textResponse,file_upload_response:options.fileUploadResponse,file_upload_type:options.fileUploadType,white_listed_file_types:options.fileTypeWhiteList,allow_latex:options.latexEnabled,leaderboard_show:options.leaderboardNum,teams_enabled:options.teamsEnabled,selected_teamset_id:options.selectedTeamsetId});return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:payload,contentType:jsonContentType}).done(function(data){if(data.success){defer.resolve()}else{defer.rejectWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("This problem could not be saved.")])})}).promise()},checkReleased:function(){var url=this.url("check_released");var payload='""';return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:payload,contentType:jsonContentType}).done(function(data){if(data.success){defer.resolveWith(this,[data.is_released])}else{defer.rejectWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("The server could not be contacted.")])})}).promise()},getUploadUrl:function(contentType,filename,filenum){var url=this.url("upload_url");return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:JSON.stringify({contentType:contentType,filename:filename,filenum:filenum}),contentType:jsonContentType}).done(function(data){if(data.success){defer.resolve(data.url)}else{defer.rejectWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("Could not retrieve upload url.")])})}).promise()},removeUploadedFile:function(filenum){var url=this.url("remove_uploaded_file");return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:JSON.stringify({filenum:filenum}),contentType:jsonContentType}).done(function(data){if(data.success){defer.resolve()}else{defer.rejectWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("Server error.")])})}).promise()},saveFilesDescriptions:function(fileMetadata){var url=this.url("save_files_descriptions");return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:JSON.stringify({fileMetadata:fileMetadata}),contentType:jsonContentType}).done(function(data){if(data.success){defer.resolve()}else{defer.rejectWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("Server error.")])})}).promise()},getDownloadUrl:function(filenum){var url=this.url("download_url");return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:JSON.stringify({filenum:filenum}),contentType:jsonContentType}).done(function(data){if(data.success){defer.resolve(data.url)}else{defer.rejectWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("Could not retrieve download url.")])})}).promise()},cancelSubmission:function(submissionID,comments){var url=this.url("cancel_submission");var payload=JSON.stringify({submission_uuid:submissionID,comments:comments});return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:payload,contentType:jsonContentType}).done(function(data){if(data.success){defer.resolveWith(this,[data.msg])}}).fail(function(){defer.rejectWith(this,[gettext("The submission could not be removed from the grading pool.")])})}).promise()},publishEvent:function(eventName,eventData){eventData.event_name=eventName;var url=this.url("publish_event");var payload=JSON.stringify(eventData);$.ajax({type:"POST",url:url,data:payload,contentType:jsonContentType})},getTeamDetail:function(teamId){var teamsUrl=window.location.origin+"/api/team/v0/teams/"+teamId;return $.ajax({type:"GET",url:teamsUrl,contentType:jsonContentType})},listTeams:function(username,courseId){var teamsUrl=window.location.origin+"/api/team/v0/teams/";return $.Deferred(function(defer){$.ajax({type:"GET",url:teamsUrl,data:{course_id:courseId,username:username},contentType:jsonContentType}).done(function(data){if(data.count>1){defer.rejectWith(this,[gettext("Multiple teams returned for course")])}else if(data.count===0){defer.resolveWith(this,[null])}else{defer.resolveWith(this,[data.results[0]])}}).fail(function(){defer.rejectWith(this,[gettext("Could not load teams information.")])})}).promise()},getUsername:function(){var url=this.url("get_student_username");return $.Deferred(function(defer){$.ajax({type:"POST",url:url,data:JSON.stringify({}),contentType:jsonContentType}).done(function(data){if(data.username===null){defer.rejectWith(this,[gettext("User lookup failed")])}else{defer.resolveWith(this,[data.username])}}).fail(function(){defer.rejectWith(this,[gettext("Error when looking up username")])})})}}}OpenAssessment.BaseView=function(runtime,element,server,data){this.runtime=runtime;this.element=element;this.server=server;this.fileUploader=new OpenAssessment.FileUploader;this.responseView=new OpenAssessment.ResponseView(this.element,this.server,this.fileUploader,this,data);this.trainingView=new OpenAssessment.StudentTrainingView(this.element,this.server,this);this.selfView=new OpenAssessment.SelfView(this.element,this.server,this);this.peerView=new OpenAssessment.PeerView(this.element,this.server,this);this.staffView=new OpenAssessment.StaffView(this.element,this.server,this);this.gradeView=new OpenAssessment.GradeView(this.element,this.server,this);this.leaderboardView=new OpenAssessment.LeaderboardView(this.element,this.server,this);this.messageView=new OpenAssessment.MessageView(this.element,this.server,this);this.staffAreaView=new OpenAssessment.StaffAreaView(this.element,this.server,this);this.usageID="";this.srStatusUpdates=[]};if(typeof OpenAssessment.unsavedChanges==="undefined"||!OpenAssessment.unsavedChanges){OpenAssessment.unsavedChanges={}}OpenAssessment.clearUnsavedChanges=function(){OpenAssessment.unsavedChanges={};window.onbeforeunload=null};OpenAssessment.BaseView.prototype={IS_SHOWING_CLASS:"is--showing",SLIDABLE_CLASS:"ui-slidable",SLIDABLE_CONTENT_CLASS:"ui-slidable__content",SLIDABLE_CONTROLS_CLASS:"ui-slidable__control",SLIDABLE_CONTAINER_CLASS:"ui-slidable__container",READER_FEEDBACK_CLASS:".sr.reader-feedback",scrollToTop:function(selector){if(!selector){selector=".openassessment__steps"}if($.scrollTo instanceof Function){$(window).scrollTo($(selector,this.element),800,{offset:-50});$(selector+" > header ."+this.SLIDABLE_CLASS,this.element).focus()}},srClear:function(){$(this.READER_FEEDBACK_CLASS).html("")},srReadTexts:function(texts){var $readerFeedbackSelector=$(this.READER_FEEDBACK_CLASS),htmlFeedback="";this.srClear();$.each(texts,function(ids,value){htmlFeedback=htmlFeedback+"<p>"+value+"</p>\n"});$readerFeedbackSelector.html(htmlFeedback)},areSRStepsLoading:function(){return this.responseView.isRendering||this.peerView.isRendering||this.selfView.isRendering||this.gradeView.isRendering||this.trainingView.isRendering||this.staffView.isRendering},announceStatusChangeToSRandFocus:function(stepID,usageID,gradeStatus,currentView,focusID){var text=this.getStatus(stepID,currentView,gradeStatus);if(typeof usageID!=="undefined"&&$(stepID,currentView.element).hasClass("is--showing")&&typeof focusID!=="undefined"){$(focusID,currentView.element).focus();this.srStatusUpdates.push(text)}else if(currentView.announceStatus){this.srStatusUpdates.push(text)}if(!this.areSRStepsLoading()&&this.srStatusUpdates.length>0){this.srReadTexts(this.srStatusUpdates);this.srStatusUpdates=[]}currentView.announceStatus=false},getStatus:function(stepID,currentView,gradeStatus){var cssBase=stepID+" .step__header .step__title ";var cssStringTitle=cssBase+".step__label";var cssStringStatus=cssBase+".step__status";if(gradeStatus){cssStringStatus=cssBase+".grade__value"}return $(cssStringTitle,currentView.element).text().trim()+" "+$(cssStringStatus,currentView.element).text().trim()},setUpCollapseExpand:function(parentElement){var view=this;$("."+view.SLIDABLE_CONTROLS_CLASS,parentElement).each(function(){$(this).on("click",function(event){event.preventDefault();var $slidableControl=$(event.target).closest("."+view.SLIDABLE_CONTROLS_CLASS);var $container=$slidableControl.closest("."+view.SLIDABLE_CONTAINER_CLASS);var $toggleButton=$slidableControl.find("."+view.SLIDABLE_CLASS);var $panel=$slidableControl.next("."+view.SLIDABLE_CONTENT_CLASS);if($container.hasClass("is--showing")){$panel.slideUp();$toggleButton.attr("aria-expanded","false");$container.removeClass("is--showing")}else if(!$container.hasClass("has--error")&&!$container.hasClass("is--empty")&&!$container.hasClass("is--unavailable")){$panel.slideDown();$toggleButton.attr("aria-expanded","true");$container.addClass("is--showing")}$container.removeClass("is--initially--collapsed ")})})},bindLatexPreview:function(parentElement){parentElement.find(".submission__preview__item").hide();parentElement.find(".submission__preview").click(function(eventObject){eventObject.preventDefault();var previewName=$(eventObject.target).data("input");var previewText=parentElement.find('textarea[data-preview="'+previewName+'"]').val();var previewContainer=parentElement.find('.preview_content[data-preview="'+previewName+'"]');previewContainer.html(previewText.replace(/\r\n|\r|\n/g,"<br />"));previewContainer.parent().parent().parent().show();MathJax.Hub.Queue(["Typeset",MathJax.Hub,previewContainer[0]])})},getUsageID:function(){if(!this.usageID){this.usageID=$(this.element).data("usage-id")}return this.usageID},load:function(){this.responseView.load();this.loadAssessmentModules();this.staffAreaView.load()},loadAssessmentModules:function(usageID){this.trainingView.load(usageID);this.peerView.load(usageID);this.staffView.load(usageID);this.selfView.load(usageID);this.gradeView.load(usageID);this.leaderboardView.load(usageID)},loadMessageView:function(){this.messageView.load()},toggleActionError:function(type,message){var element=this.element;var container=null;if(type==="save"){container=".response__submission__actions"}else if(type==="submit"||type==="peer"||type==="self"||type==="student-training"){container=".step__actions"}else if(type==="feedback_assess"){container=".submission__feedback__actions"}else if(type==="upload"){container=".upload__error"}else if(type==="delete"){container=".delete__error"}if(container===null){if(message!==null){console.log(message)}}else{$(container+" .message__content",element).html("<p>"+(message?_.escape(message):"")+"</p>");$(container,element).toggleClass("has--error",message!==null);$(container+" > .message",element).focus()}if(message!==null){var contentTitle=$(container+" .message__title").text();this.srReadTexts([contentTitle,message])}},showLoadError:function(stepName,errorMessage){if(!errorMessage){errorMessage=gettext("Unable to load")}var $container=$(".step--"+stepName);$container.toggleClass("has--error",true);$container.removeClass("is--showing");$container.find(".ui-slidable").attr("aria-expanded","false");$container.find(".step__status__value i").removeClass().addClass("icon fa fa-exclamation-triangle");$container.find(".step__status__value .copy").html(_.escape(errorMessage))},unsavedWarningEnabled:function(enabled,key,message){if(typeof enabled==="undefined"){return window.onbeforeunload!==null}else{var usageID=$(this.element).data("usage-id");if(enabled){if(typeof OpenAssessment.unsavedChanges[usageID]==="undefined"||!OpenAssessment.unsavedChanges[usageID]){OpenAssessment.unsavedChanges[usageID]={}}OpenAssessment.unsavedChanges[usageID][key]=message;window.onbeforeunload=function(){for(var xblockUsageID in OpenAssessment.unsavedChanges){if(OpenAssessment.unsavedChanges.hasOwnProperty(xblockUsageID)){for(var key in OpenAssessment.unsavedChanges[xblockUsageID]){if(OpenAssessment.unsavedChanges[xblockUsageID].hasOwnProperty(key)){return OpenAssessment.unsavedChanges[xblockUsageID][key]}}}}}}else{if(typeof OpenAssessment.unsavedChanges[usageID]!=="undefined"){delete OpenAssessment.unsavedChanges[usageID][key];if($.isEmptyObject(OpenAssessment.unsavedChanges[usageID])){delete OpenAssessment.unsavedChanges[usageID]}if($.isEmptyObject(OpenAssessment.unsavedChanges)){window.onbeforeunload=null}}}}},buttonEnabled:function(className,enabled){var $element=$(className,this.element);if(typeof enabled==="undefined"){return!$element.prop("disabled")}else{$element.prop("disabled",!enabled);return enabled}}};function OpenAssessmentBlock(runtime,element,data){var server=new OpenAssessment.Server(runtime,element);var view=new OpenAssessment.BaseView(runtime,element,server,data);view.load()}function CourseOpenResponsesListingBlock(runtime,element,data){var view=new OpenAssessment.CourseItemsListingView(runtime,element);view.refreshGrids()}function StaffAssessmentBlock(runtime,element,data){var server=new OpenAssessment.Server(runtime,element);var view=new OpenAssessment.BaseView(runtime,element,server,data);view.staffAreaView.installHandlers()}(function(OpenAssessment){"use strict";OpenAssessment.CourseItemsListingView=function(runtime,element){var self=this;var $section=$(element);var block=$section.find(".open-response-assessment-block");var itemViewEnabled=parseInt(block.data("item-view-enabled"))===1&&XBlock;var dataRendered=parseInt(block.data("rendered"));this.$section=$section;this.runtime=runtime;this.oraData=$.parseJSON($("#open-response-assessment-items").text());if(!dataRendered){$section.find(".open-response-assessment-content").hide();$section.find(".open-response-assessment-item").hide();$section.find(".open-response-assessment-msg").show()}var AssessmentCell=Backgrid.UriCell.extend({staff:false,render:function(){this.$el.empty();var url=this.model.get(this.staff?"url_grade_available_responses":"url_base");var rawValue=this.model.get(this.column.get("name"));var staffAssessment=this.model.get("staff_assessment");var formattedValue=this.formatter.fromRaw(rawValue,this.model);var link=null;if(itemViewEnabled&&(!this.staff||this.staff&&staffAssessment)){link=$("<a>",{text:formattedValue,title:this.title||formattedValue});this.$el.append(link);link.on("click",$.proxy(self,"displayOraBlock",url))}else{this.$el.append(formattedValue)}this.delegateEvents();return this}});var StaffCell=AssessmentCell.extend({staff:true});this._columns=[{name:"parent_name",label:gettext("Unit Name"),label_summary:gettext("Units"),cell:"string",num:false,editable:false},{name:"name",label:gettext("Assessment"),label_summary:gettext("Assessments"),cell:AssessmentCell,num:false,editable:false},{name:"total",label:gettext("Total Responses"),label_summary:gettext("Total Responses"),cell:"string",num:true,editable:false},{name:"training",label:gettext("Training"),label_summary:gettext("Training"),cell:"string",num:true,editable:false},{name:"peer",label:gettext("Peer"),label_summary:gettext("Peer"),cell:"string",num:true,editable:false},{name:"self",label:gettext("Self"),label_summary:gettext("Self"),cell:"string",num:true,editable:false},{name:"waiting",label:gettext("Waiting"),label_summary:gettext("Waiting"),cell:"string",num:true,editable:false},{name:"staff",label:gettext("Staff"),label_summary:gettext("Staff"),cell:StaffCell,num:true,editable:false},{name:"done",label:gettext("Final Grade Received"),label_summary:gettext("Final Grade Received"),cell:"string",num:true,editable:false}]};OpenAssessment.CourseItemsListingView.prototype.refreshGrids=function(force){force=force||false;var self=this;var $section=this.$section;var block=$section.find(".open-response-assessment-block");var dataUrl=this.runtime.handlerUrl($section,"get_ora2_responses");var dataRendered=parseInt(block.data("rendered"));if(!dataRendered||force){return $.Deferred(function(defer){$.ajax({type:"GET",dataType:"json",url:dataUrl}).done(function(data){self.renderGrids(data);defer.resolve()}).fail(function(data,textStatus){$section.find(".open-response-assessment-msg").text(gettext("List of Open Assessments is unavailable"));defer.rejectWith(self,[textStatus])})}).promise()}};OpenAssessment.CourseItemsListingView.prototype.renderGrids=function(data){var self=this;var $section=this.$section;var block=$section.find(".open-response-assessment-block");var oraSteps=["training","peer","self","waiting","staff","done"];$.each(self.oraData,function(i,oraItem){var total=0;var itemId=oraItem.id;$.each(oraSteps,function(j,step){oraItem[step]=0});if(itemId in data){_.extend(oraItem,data[itemId]);if(oraItem.staff_assessment){oraItem.staff=oraItem.waiting;oraItem.waiting=0}}$.each(oraSteps,function(j,step){total+=oraItem[step]});oraItem.total=total});block.data("rendered",1);$section.find(".open-response-assessment-msg").hide();self.showSummaryGrid(self.oraData);self.showOpenResponsesGrid(self.oraData)};OpenAssessment.CourseItemsListingView.prototype.showSummaryGrid=function(data){var $section=this.$section;var summaryData=[];var summaryDataMap={};$section.find(".open-response-assessment-summary").empty();$.each(this._columns,function(index,v){summaryData.push({title:v.label_summary,value:0,num:v.num,class:v.name});summaryDataMap[v.name]=index});$.each(data,function(index,obj){$.each(obj,function(key,value){var idx=0;if(key in summaryDataMap){idx=summaryDataMap[key];if(summaryData[idx].num){summaryData[idx].value+=value}else{summaryData[idx].value+=1}}})});var templateData=_.template($("#open-response-assessment-summary-tpl").text());$section.find(".open-response-assessment-summary").append(templateData({oraSummary:summaryData}))};OpenAssessment.CourseItemsListingView.prototype.showOpenResponsesGrid=function(data){var $section=this.$section;$section.find(".open-response-assessment-content").show();var collection=new Backbone.Collection(data);$section.find(".open-response-assessment-main-table").empty();var grid=new Backgrid.Grid({columns:this._columns,collection:collection});$section.find(".open-response-assessment-main-table").append(grid.render().el)};OpenAssessment.CourseItemsListingView.prototype.displayOraBlock=function(url){var $section=this.$section;var self=this;$section.find(".open-response-assessment-content").hide();$section.find(".open-response-assessment-msg").text(gettext("Please wait")).show();return $.Deferred(function(defer){$.ajax({type:"GET",dataType:"json",url:url}).done(function(data){var el=$section.find(".open-response-assessment-item");var block=el.find(".open-response-assessment-item-block");$section.find(".open-response-assessment-msg").hide();el.show();self.renderBreadcrumbs();block.html(data.html);XBlock.initializeBlock($(block).find(".xblock")[0]);defer.resolve()}).fail(function(data,textStatus){$section.find(".open-response-assessment-item").show();$section.find(".open-response-assessment-msg").text(gettext("Block view is unavailable"));self.renderBreadcrumbs();defer.rejectWith(self,[textStatus])})}).promise()};OpenAssessment.CourseItemsListingView.prototype.renderBreadcrumbs=function(){var $section=this.$section;var breadcrumbs=$section.find(".open-response-assessment-item-breadcrumbs");var text=gettext("Back to Full List");var fullListItem=$("<a>",{html:"&larr;&nbsp;"+text,title:text});breadcrumbs.append(fullListItem);fullListItem.on("click",$.proxy(this,"backToOpenResponsesGrid"))};OpenAssessment.CourseItemsListingView.prototype.backToOpenResponsesGrid=function(){var $section=this.$section;$section.find(".open-response-assessment-item-breadcrumbs").empty();$section.find(".open-response-assessment-item-block").empty();$section.find(".open-response-assessment-item").hide();$section.find(".open-response-assessment-msg").text(gettext("Please wait")).show();this.refreshGrids(true)}})(OpenAssessment);OpenAssessment.DateTimeFactory=function(element){this.element=element};OpenAssessment.DateTimeFactory.prototype={apply:function(){var dtFactory=this;$(".ora-datetime",this.element).each(function(){dtFactory.elementApply($(this))})},determineContext:function(el){var context;context={datetime:el.data("datetime"),timezone:el.data("timezone"),language:el.data("language"),format:""};return context},determineDateToken:function(el){var dtFactory=this;var dateToken="date";if(dtFactory.isValid(el.data("datetoken"))){dateToken=el.data("datetoken")}return dateToken},elementApply:function(el){var dtFactory=this;(function(require){require(["jquery","edx-ui-toolkit/js/utils/date-utils","edx-ui-toolkit/js/utils/string-utils"],function($,DateUtils,StringUtils){var context;var localTimeString;var displayDatetime;var interpolateDict={};if(dtFactory.isValid(el.data("datetime"))){context=dtFactory.determineContext(el);if(dtFactory.isValid(el.data("format"))){context.format=DateUtils.dateFormatEnum[el.data("format")]}localTimeString=DateUtils.localize(context);interpolateDict[dtFactory.determineDateToken(el)]=localTimeString;if(dtFactory.isValid(el.data("string"))){displayDatetime=StringUtils.interpolate(el.data("string"),interpolateDict)}else{displayDatetime=localTimeString}}else{displayDatetime=StringUtils.interpolate(el.data("string"),interpolateDict)}el.text(displayDatetime)})}).call(this,require||RequireJS.require)},isValid:function(candidateVariable){return candidateVariable!==undefined&&candidateVariable!==""&&candidateVariable!=="Invalid date"&&candidateVariable!=="None"}};OpenAssessment.FileUploader=function(){this.upload=function(url,file){return $.Deferred(function(defer){$.ajax({url:url,type:"PUT",data:file,async:false,processData:false,contentType:file.type}).done(function(){Logger.log("openassessment.upload_file",{fileName:file.name,fileSize:file.size,fileType:file.type});defer.resolve()}).fail(function(data,textStatus){defer.rejectWith(this,[textStatus])})}).promise()}};OpenAssessment.GradeView=function(element,server,baseView){this.element=element;this.server=server;this.baseView=baseView;this.announceStatus=false;this.isRendering=false;this.dateFactory=new OpenAssessment.DateTimeFactory(this.element)};OpenAssessment.GradeView.prototype={load:function(usageID){var view=this;var baseView=this.baseView;var stepID=".step--grade";var focusID="[id='oa_grade_"+usageID+"']";view.isRendering=true;this.server.render("grade").done(function(html){$(stepID,view.element).replaceWith(html);view.server.renderLatex($(stepID,view.element));view.isRendering=false;view.installHandlers();view.baseView.announceStatusChangeToSRandFocus(stepID,usageID,true,view,focusID);view.dateFactory.apply()}).fail(function(errMsg){baseView.showLoadError("grade",errMsg)})},installHandlers:function(){var sel=$(".step--grade",this.element);this.baseView.setUpCollapseExpand(sel);var view=this;sel.find(".feedback__submit").click(function(eventObject){eventObject.preventDefault();view.submitFeedbackOnAssessment()})},feedbackText:function(text){var usageID=this.baseView.getUsageID()||"";if(typeof text==="undefined"){return $("[id='feedback__remarks__value__"+usageID+"']",this.element).val()}else{$("[id='feedback__remarks__value__"+usageID+"']",this.element).val(text)}},feedbackOptions:function(options){var view=this;var usageID=this.baseView.getUsageID()||"";if(typeof options==="undefined"){return $.map($(".feedback__overall__value:checked",view.element),function(element){return $(element).val()})}else{$(".feedback__overall__value",this.element).prop("checked",false);$.each(options,function(index,opt){$("[id='feedback__overall__value--"+opt+"__"+usageID+"']",view.element).prop("checked",true)})}},setHidden:function(selector,hidden){selector.toggleClass("is--hidden",hidden);selector.attr("aria-hidden",hidden?"true":"false")},isHidden:function(selector){return selector.hasClass("is--hidden")&&selector.attr("aria-hidden")==="true"},feedbackState:function(newState){var containerSel=$(".submission__feedback__content",this.element);var instructionsSel=containerSel.find(".submission__feedback__instructions");var fieldsSel=containerSel.find(".submission__feedback__fields");var actionsSel=containerSel.find(".submission__feedback__actions");var transitionSel=containerSel.find(".transition__status");var messageSel=containerSel.find(".message--complete");if(typeof newState==="undefined"){var isSubmitting=containerSel.hasClass("is--transitioning")&&containerSel.hasClass("is--submitting")&&!this.isHidden(transitionSel)&&this.isHidden(messageSel)&&this.isHidden(instructionsSel)&&this.isHidden(fieldsSel)&&this.isHidden(actionsSel);var hasSubmitted=containerSel.hasClass("is--submitted")&&this.isHidden(transitionSel)&&!this.isHidden(messageSel)&&this.isHidden(instructionsSel)&&this.isHidden(fieldsSel)&&this.isHidden(actionsSel);var isOpen=!containerSel.hasClass("is--submitted")&&!containerSel.hasClass("is--transitioning")&&!containerSel.hasClass("is--submitting")&&this.isHidden(transitionSel)&&this.isHidden(messageSel)&&!this.isHidden(instructionsSel)&&!this.isHidden(fieldsSel)&&!this.isHidden(actionsSel);if(isOpen){return"open"}else if(isSubmitting){return"submitting"}else if(hasSubmitted){return"submitted"}else{throw new Error("Invalid feedback state")}}else{if(newState==="open"){containerSel.toggleClass("is--transitioning",false);containerSel.toggleClass("is--submitting",false);containerSel.toggleClass("is--submitted",false);this.setHidden(instructionsSel,false);this.setHidden(fieldsSel,false);this.setHidden(actionsSel,false);this.setHidden(transitionSel,true);this.setHidden(messageSel,true)}else if(newState==="submitting"){containerSel.toggleClass("is--transitioning",true);containerSel.toggleClass("is--submitting",true);containerSel.toggleClass("is--submitted",false);this.setHidden(instructionsSel,true);this.setHidden(fieldsSel,true);this.setHidden(actionsSel,true);this.setHidden(transitionSel,false);this.setHidden(messageSel,true)}else if(newState==="submitted"){containerSel.toggleClass("is--transitioning",false);containerSel.toggleClass("is--submitting",false);containerSel.toggleClass("is--submitted",true);this.setHidden(instructionsSel,true);this.setHidden(fieldsSel,true);this.setHidden(actionsSel,true);this.setHidden(transitionSel,true);this.setHidden(messageSel,false)}}},submitFeedbackOnAssessment:function(){var view=this;var baseView=this.baseView;$(".feedback__submit",this.element).prop("disabled",true);view.feedbackState("submitting");this.server.submitFeedbackOnAssessment(this.feedbackText(),this.feedbackOptions()).done(function(){view.feedbackState("submitted")}).fail(function(errMsg){baseView.toggleActionError("feedback_assess",errMsg)})}};OpenAssessment.LeaderboardView=function(element,server,baseView){this.element=element;this.server=server;this.baseView=baseView};OpenAssessment.LeaderboardView.prototype={load:function(usageID){var view=this;var baseView=this.baseView;var stepID=".step--leaderboard";this.server.render("leaderboard").done(function(html){$(stepID,view.element).replaceWith(html);view.server.renderLatex($(stepID,view.element));view.installHandlers();if(typeof usageID!=="undefined"&&$(stepID,view.element).hasClass("is--showing")){$("[id='oa_leaderboard_"+usageID+"']",view.element).focus()}}).fail(function(errMsg){baseView.showLoadError("leaderboard",errMsg)})},installHandlers:function(){this.baseView.setUpCollapseExpand($(".step--leaderboard",this.element))}};OpenAssessment.MessageView=function(element,server,baseView){this.element=element;this.server=server;this.baseView=baseView};OpenAssessment.MessageView.prototype={load:function(){var view=this;var baseView=this.baseView;this.server.render("message").done(function(html){$(".openassessment__message",view.element).replaceWith(html);view.server.renderLatex($(".openassessment__message",view.element))}).fail(function(errMsg){baseView.showLoadError("message",errMsg)})}};OpenAssessment.PeerView=function(element,server,baseView){this.element=element;this.server=server;this.baseView=baseView;this.rubric=null;this.isRendering=false;this.announceStatus=false;this.dateFactory=new OpenAssessment.DateTimeFactory(this.element)};OpenAssessment.PeerView.prototype={UNSAVED_WARNING_KEY:"peer-assessment",load:function(usageID){var view=this;var stepID=".step--peer-assessment";var focusID="[id='oa_peer_"+usageID+"']";view.isRendering=true;this.server.render("peer_assessment").done(function(html){$(stepID,view.element).replaceWith(html);view.isRendering=false;view.server.renderLatex($(stepID,view.element));view.installHandlers(false);view.baseView.announceStatusChangeToSRandFocus(stepID,usageID,false,view,focusID);view.announceStatus=false;view.dateFactory.apply()}).fail(function(){view.baseView.showLoadError("peer-assessment")});view.baseView.loadMessageView()},loadContinuedAssessment:function(usageID){var view=this;var stepID=".step--peer-assessment";var focusID="[id='oa_peer_"+usageID+"']";view.continueAssessmentEnabled(false);view.isRendering=true;this.server.renderContinuedPeer().done(function(html){$(".step--peer-assessment",view.element).replaceWith(html);view.server.renderLatex($(".step--peer-assessment",view.element));view.isRendering=false;view.installHandlers(true);view.baseView.announceStatusChangeToSRandFocus(stepID,usageID,false,view,focusID)}).fail(function(){view.baseView.showLoadError("peer-assessment");view.continueAssessmentEnabled(true)})},continueAssessmentEnabled:function(enabled){return this.baseView.buttonEnabled(".action--continue--grading",enabled)},installHandlers:function(isContinuedAssessment){var sel=$(".step--peer-assessment",this.element);var view=this;this.baseView.setUpCollapseExpand(sel);this.baseView.bindLatexPreview(sel);var rubricSelector=$(".peer-assessment--001__assessment",this.element);if(rubricSelector.size()>0){var rubricElement=rubricSelector.get(0);this.rubric=new OpenAssessment.Rubric(rubricElement)}else{this.rubric=null}if(this.rubric!==null){this.rubric.canSubmitCallback($.proxy(view.peerSubmitEnabled,view));this.rubric.changesExistCallback($.proxy(view.assessmentRubricChanges,view))}sel.find(".peer-assessment--001__assessment__submit").click(function(eventObject){eventObject.preventDefault();view.announceStatus=true;if(!isContinuedAssessment){view.peerAssess()}else{view.continuedPeerAssess()}});sel.find(".action--continue--grading").click(function(eventObject){eventObject.preventDefault();view.loadContinuedAssessment(view.baseView.getUsageID())})},peerSubmitEnabled:function(enabled){return this.baseView.buttonEnabled(".peer-assessment--001__assessment__submit",enabled)},assessmentRubricChanges:function(changesExist){if(changesExist){this.baseView.unsavedWarningEnabled(true,this.UNSAVED_WARNING_KEY,gettext("If you leave this page without submitting your peer assessment, you will lose any work you have done."))}},peerAssess:function(){var view=this;var baseView=view.baseView;var usageID=baseView.getUsageID();this.peerAssessRequest(function(){baseView.unsavedWarningEnabled(false,view.UNSAVED_WARNING_KEY);baseView.loadAssessmentModules(usageID);baseView.scrollToTop(".step--peer-assessment")})},continuedPeerAssess:function(){var view=this;var gradeView=this.baseView.gradeView;var baseView=view.baseView;var usageID=baseView.getUsageID();view.peerAssessRequest(function(){baseView.unsavedWarningEnabled(false,view.UNSAVED_WARNING_KEY);view.loadContinuedAssessment(usageID);gradeView.load();baseView.scrollToTop(".step--peer-assessment")})},peerAssessRequest:function(successFunction){var view=this;var uuid=this.getUUID();view.baseView.toggleActionError("peer",null);view.peerSubmitEnabled(false);this.server.peerAssess(this.rubric.optionsSelected(),this.rubric.criterionFeedback(),this.rubric.overallFeedback(),uuid).done(successFunction).fail(function(errMsg){view.baseView.toggleActionError("peer",errMsg);view.peerSubmitEnabled(true)})},getUUID:function(){var xBlockElement=$("div[data-usage-id='"+this.baseView.getUsageID()+"']");return xBlockElement.find(".step--peer-assessment").data("submission-uuid")}};OpenAssessment.ResponseView=function(element,server,fileUploader,baseView,data){this.element=element;this.server=server;this.fileUploader=fileUploader;this.baseView=baseView;this.savedResponse=[];this.textResponse="required";this.fileUploadResponse="";this.files=null;this.filesDescriptions=[];this.fileNames=[];this.filesType=null;this.lastChangeTime=Date.now();this.errorOnLastSave=false;this.autoSaveTimerId=null;this.data=data;this.filesUploaded=false;this.announceStatus=false;this.isRendering=false;this.fileCountBeforeUpload=0;this.dateFactory=new OpenAssessment.DateTimeFactory(this.element)};OpenAssessment.ResponseView.prototype={AUTO_SAVE_POLL_INTERVAL:2e3,AUTO_SAVE_WAIT:3e4,MAX_FILE_SIZE:500*Math.pow(1024,2),MAX_FILES_MB:500,UNSAVED_WARNING_KEY:"learner-response",load:function(usageID){var view=this;var stepID=".step--response";var focusID="[id='oa_response_"+usageID+"']";view.isRendering=true;this.server.render("submission").done(function(html){$(stepID,view.element).replaceWith(html);view.server.renderLatex($(stepID,view.element));view.installHandlers();view.setAutoSaveEnabled(true);view.isRendering=false;view.baseView.announceStatusChangeToSRandFocus(stepID,usageID,false,view,focusID);view.announceStatus=false;view.dateFactory.apply();view.checkSubmissionAbility()}).fail(function(){view.baseView.showLoadError("response")})},installHandlers:function(){var sel=$(".step--response",this.element);var view=this;var uploadType="";if(sel.find(".submission__answer__display__file").length){uploadType=sel.find(".submission__answer__display__file").data("upload-type")}this.baseView.setUpCollapseExpand(sel);this.savedResponse=this.response();var handleChange=function(){view.handleResponseChanged()};sel.find(".submission__answer__part__text__value").on("change keyup drop paste",handleChange);var handlePrepareUpload=function(eventData){view.prepareUpload(eventData.target.files,uploadType)};sel.find("input[type=file]").on("change",handlePrepareUpload);var submit=$(".step--response__submit",this.element);this.textResponse=$(submit).attr("text_response");this.fileUploadResponse=$(submit).attr("file_upload_response");sel.find(".step--response__submit").click(function(eventObject){eventObject.preventDefault();view.submit()});sel.find(".submission__save").click(function(eventObject){eventObject.preventDefault();view.save()});this.baseView.bindLatexPreview(sel);sel.find(".file__upload").click(function(eventObject){eventObject.preventDefault();$(".submission__answer__display__file",view.element).removeClass("is--hidden");if(view.hasAllUploadFiles()){view.uploadFiles()}});sel.find(".delete__uploaded__file").click(this.handleDeleteFileClick());sel.find("#team_text_response_warning_closebtn").click(function(eventObject){eventObject.preventDefault();sel.find("#team_text_response_warning").remove()})},handleDeleteFileClick:function(){var view=this;return function(eventObject){eventObject.preventDefault();var filenum=$(eventObject.target).attr("filenum");view.removeUploadedFile(filenum)}},setAutoSaveEnabled:function(enabled){if(enabled){if(this.autoSaveTimerId===null){this.autoSaveTimerId=setInterval($.proxy(this.autoSave,this),this.AUTO_SAVE_POLL_INTERVAL)}}else{if(this.autoSaveTimerId!==null){clearInterval(this.autoSaveTimerId)}}},checkSubmissionAbility:function(filesFiledIsNotBlank){var textFieldsIsNotBlank=!this.response().every(function(element){return $.trim(element)===""});filesFiledIsNotBlank=filesFiledIsNotBlank||false;$(".submission__answer__file",this.element).each(function(){if($(this).prop("tagName")==="IMG"&&$(this).attr("src")!==""){filesFiledIsNotBlank=true}if($(this).prop("tagName")==="A"&&$(this).attr("href")!==""){filesFiledIsNotBlank=true}});var readyToSubmit=true;if(this.textResponse==="required"&&!textFieldsIsNotBlank){readyToSubmit=false}if(this.fileUploadResponse==="required"&&!filesFiledIsNotBlank){readyToSubmit=false}if(this.textResponse==="optional"&&this.fileUploadResponse==="optional"&&!textFieldsIsNotBlank&&!filesFiledIsNotBlank){readyToSubmit=false}if(this.hasPendingUploadFiles()&&!this.collectFilesDescriptions()){readyToSubmit=false}this.submitEnabled(readyToSubmit)},checkSaveAbility:function(){var textFieldsIsNotBlank=!this.response().every(function(element){return $.trim(element)===""});return!(this.textResponse==="required"&&!textFieldsIsNotBlank)},submitEnabled:function(enabled){return this.baseView.buttonEnabled(".step--response__submit",enabled)},saveEnabled:function(enabled){return this.baseView.buttonEnabled(".submission__save",enabled)},uploadEnabled:function(enabled){return this.baseView.buttonEnabled(".file__upload",enabled)},previewEnabled:function(enabled){return this.baseView.buttonEnabled(".submission__preview",enabled)},hasPendingUploadFiles:function(){return this.files!==null&&!this.filesUploaded},hasAllUploadFiles:function(){for(var i=0;i<this.files.length;i++){var file=this.files[i];if(file.size===0){this.baseView.toggleActionError("upload",gettext("Your file "+file.name+" has been deleted or path has been changed."));this.submitEnabled(true);return false}}return true},saveStatus:function(msg){var sel=$(".save__submission__label",this.element);if(typeof msg==="undefined"){return sel.text()}else{var label=gettext("Status of Your Response");sel.html('<span class="sr">'+_.escape(label)+":"+"</span>\n"+msg)}},response:function(texts){var sel=$(".response__submission .submission__answer__part__text__value",this.element);if(typeof texts==="undefined"){return sel.map(function(){return $.trim($(this).val())}).get()}else{sel.map(function(index){$(this).val(texts[index])})}},responseChanged:function(){var savedResponse=this.savedResponse;return this.response().some(function(element,index){return element!==savedResponse[index]})},autoSave:function(){var timeSinceLastChange=Date.now()-this.lastChangeTime;if(this.responseChanged()&&timeSinceLastChange>this.AUTO_SAVE_WAIT&&!this.errorOnLastSave){this.save()}},handleResponseChanged:function(){this.checkSubmissionAbility();if(this.responseChanged()){var saveAbility=this.checkSaveAbility();this.saveEnabled(saveAbility);this.previewEnabled(saveAbility);this.saveStatus(gettext("This response has not been saved."));this.baseView.unsavedWarningEnabled(true,this.UNSAVED_WARNING_KEY,gettext("If you leave this page without saving or submitting your response, you will lose any work you have done on the response."))}this.lastChangeTime=Date.now()},save:function(){this.errorOnLastSave=false;this.saveStatus(gettext("Saving..."));this.baseView.toggleActionError("save",null);this.baseView.unsavedWarningEnabled(false,this.UNSAVED_WARNING_KEY);var view=this;var savedResponse=this.response();this.server.save(savedResponse).done(function(){view.savedResponse=savedResponse;view.checkSubmissionAbility();var currentResponse=view.response();var currentResponseEqualsSaved=currentResponse.every(function(element,index){return element===savedResponse[index]});if(currentResponseEqualsSaved){view.saveEnabled(false);var msg=gettext("This response has been saved but not submitted.");view.saveStatus(msg);view.baseView.srReadTexts([msg])}}).fail(function(errMsg){view.saveStatus(gettext("Error"));view.baseView.toggleActionError("save",errMsg);view.errorOnLastSave=true})},submit:function(){this.submitEnabled(false);var view=this;var baseView=this.baseView;var fileDefer=$.Deferred();if(view.hasPendingUploadFiles()){if(!view.hasAllUploadFiles()){return}else{var msg=gettext("Do you want to upload your file before submitting?");if(confirm(msg)){fileDefer=view.uploadFiles();if(fileDefer===false){return}}}}else{fileDefer.resolve()}fileDefer.pipe(function(){return view.confirmSubmission().pipe(function(){var submission=view.response();baseView.toggleActionError("response",null);return view.server.submit(submission)})}).done($.proxy(view.moveToNextStep,view)).fail(function(errCode,errMsg){if(errCode==="ENOMULTI"){view.moveToNextStep()}else{if(errMsg){baseView.toggleActionError("submit",errMsg)}view.submitEnabled(true)}})},moveToNextStep:function(){var baseView=this.baseView;var usageID=baseView.getUsageID();var view=this;this.load(usageID);baseView.loadAssessmentModules(usageID);view.announceStatus=true;baseView.unsavedWarningEnabled(false,this.UNSAVED_WARNING_KEY)},confirmSubmission:function(){var msg=gettext("You're about to submit your response for this assignment. After you submit this response, you can't change it or submit a new response.");return $.Deferred(function(defer){if(confirm(msg)){defer.resolve()}else{defer.reject()}})},prepareUpload:function(files,uploadType,descriptions){this.files=null;this.filesType=uploadType;this.filesUploaded=false;var ext=null;var fileType=null;var errorCheckerTriggered=false;for(var i=0;i<files.length;i++){ext=files[i].name.split(".").pop().toLowerCase();fileType=files[i].type;if(files[i].size>this.MAX_FILE_SIZE){this.baseView.toggleActionError("upload",gettext("Individual file size must be {max_files_mb}MB or less.").replace("{max_files_mb}",this.MAX_FILES_MB));errorCheckerTriggered=true;break}else if(uploadType==="image"&&this.data.ALLOWED_IMAGE_MIME_TYPES.indexOf(fileType)===-1){this.baseView.toggleActionError("upload",gettext("You can upload files with these file types: ")+"JPG, PNG or GIF");errorCheckerTriggered=true;break}else if(uploadType==="pdf-and-image"&&this.data.ALLOWED_FILE_MIME_TYPES.indexOf(fileType)===-1){this.baseView.toggleActionError("upload",gettext("You can upload files with these file types: ")+"JPG, PNG, GIF or PDF");errorCheckerTriggered=true;break}else if(uploadType==="custom"&&this.data.FILE_TYPE_WHITE_LIST.indexOf(ext)===-1){this.baseView.toggleActionError("upload",gettext("You can upload files with these file types: ")+this.data.FILE_TYPE_WHITE_LIST.join(", "));errorCheckerTriggered=true;break}else if(this.data.FILE_EXT_BLACK_LIST.indexOf(ext)!==-1){this.baseView.toggleActionError("upload",gettext("File type is not allowed."));errorCheckerTriggered=true;break}}if(this.getSavedFileCount(false)+files.length>this.data.MAXIMUM_FILE_UPLOAD_COUNT){var msg=gettext("Only "+this.data.MAXIMUM_FILE_UPLOAD_COUNT+" files can be saved.");this.baseView.toggleActionError("upload",gettext(msg));errorCheckerTriggered=true}if(!errorCheckerTriggered){this.baseView.toggleActionError("upload",null);if(files.length>0){this.files=files}this.updateFilesDescriptionsFields(files,descriptions,uploadType)}if(this.files===null){$(this.element).find(".file__upload").prop("disabled",true)}},updateFilesDescriptionsFields:function(files,descriptions,uploadType){var filesDescriptions=$(this.element).find(".files__descriptions").first();var mainDiv=null;var divLabel=null;var divTextarea=null;var divImage=null;var img=null;var textarea=null;var descriptionsExists=true;this.filesDescriptions=descriptions||[];this.fileNames=[];$(filesDescriptions).show().html("");for(var i=0;i<files.length;i++){mainDiv=$("<div/>");divLabel=$("<div/>");divLabel.addClass("submission__file__description__label");divLabel.text(gettext("Describe ")+files[i].name+" "+gettext("(required):"));divLabel.appendTo(mainDiv);divTextarea=$("<div/>");divTextarea.addClass("submission__file__description");textarea=$("<textarea />",{"aria-label":gettext("Describe ")+files[i].name});if(this.filesDescriptions.indexOf(i)!==-1&&this.filesDescriptions[i]!==""){textarea.val(this.filesDescriptions[i])}else{descriptionsExists=false}textarea.addClass("file__description file__description__"+i);textarea.appendTo(divTextarea);if(uploadType==="image"){img=$("<img/>",{src:window.URL.createObjectURL(files[i]),height:80,alt:gettext("Thumbnail view of ")+files[i].name});img.onload=function(){window.URL.revokeObjectURL(this.src)};divImage=$("<div/>");divImage.addClass("submission__img__preview");img.appendTo(divImage);divImage.appendTo(mainDiv)}divTextarea.appendTo(mainDiv);mainDiv.appendTo(filesDescriptions);textarea.on("change keyup drop paste",$.proxy(this,"checkSubmissionAbility"))}this.uploadEnabled(descriptionsExists);this.submitEnabled(descriptionsExists&&this.checkSubmissionAbility())},collectFilesDescriptions:function(){var isError=false;var filesDescriptions=[];$(this.element).find(".file__description").each(function(){var filesDescriptionVal=$.trim($(this).val());if(filesDescriptionVal){filesDescriptions.push(filesDescriptionVal)}else{isError=true}});this.uploadEnabled(!isError);if(!isError){this.filesDescriptions=filesDescriptions}return!isError},removeFilesDescriptions:function(){var filesDescriptions=$(this.element).find(".files__descriptions").first();$(filesDescriptions).hide().html("")},getSavedFileCount:function(includeDeleted){if(includeDeleted){return $(this.baseView.element).find(".submission__answer__file__block").length}else{return $(this.baseView.element).find(".submission__answer__file__block").filter(":parent").length}},removeUploadedFile:function(filenum){var view=this;return view.confirmRemoveUploadedFile(filenum).done(function(){return view.server.removeUploadedFile(filenum).done(function(){var sel=$(".step--response",view.element);var block=sel.find(".submission__answer__file__block__"+filenum);block.html("");block.prop("deleted",true);view.checkSubmissionAbility()}).fail(function(errMsg){view.baseView.toggleActionError("delete",errMsg)})})},confirmRemoveUploadedFile:function(filenum){var msg=gettext("Are you sure you want to delete the following file? It cannot be restored.\nFile: ");msg+=this.getFileNameAndDescription(filenum);return $.Deferred(function(defer){if(confirm(msg)){defer.resolve()}else{defer.reject()}})},getFileNameAndDescription:function(filenum){var fileBlock=$(this.baseView.element).find(".submission__answer__file__block__"+filenum+" > a");if(fileBlock.length){return fileBlock[0].text.trim()}else{return""}},saveFilesDescriptions:function(){var view=this;var sel=$(".step--response",this.element);var fileMetaData=[];for(var i=0;i<this.filesDescriptions.length;i++){this.fileNames.push(this.files[i].name);var entry={description:this.filesDescriptions[i],fileName:this.files[i].name,fileSize:this.files[i].size};fileMetaData.push(entry)}return this.server.saveFilesDescriptions(fileMetaData).done(function(){view.removeFilesDescriptions()}).fail(function(errMsg){view.baseView.toggleActionError("upload",errMsg);sel.find(".file__upload").prop("disabled",false)})},uploadFiles:function(){var view=this;var promise=null;var fileCount=view.files.length;var sel=$(".step--response",this.element);sel.find(".file__upload").prop("disabled",true);promise=view.saveFilesDescriptions();view.fileCountBeforeUpload=view.getSavedFileCount(true);$.each(view.files,function(index,file){promise=promise.then(function(){return view.fileUpload(view,file.type,file.name,view.fileCountBeforeUpload+index,file,fileCount===index+1)})});return promise},fileUpload:function(view,filetype,filename,filenum,file,finalUpload){var sel=$(".step--response",this.element);var handleError=function(errMsg){view.baseView.toggleActionError("upload",errMsg);sel.find(".file__upload").prop("disabled",false)};return view.server.getUploadUrl(filetype,filename,filenum).done(function(url){view.fileUploader.upload(url,file).done(function(){view.fileUrl(filenum);view.baseView.toggleActionError("upload",null);if(finalUpload){sel.find("input[type=file]").val("");view.filesUploaded=true;view.checkSubmissionAbility(true)}}).fail(handleError)}).fail(handleError)},fileUrl:function(filenum){var view=this;var sel=$(".step--response",this.element);view.server.getDownloadUrl(filenum).done(function(url){var className="submission__answer__file__block__"+filenum;var file=null;var img=null;var fileBlock=null;var fileBlockExists=sel.find("."+className).length?true:false;var div1=null;var div2=null;var ariaLabelledBy=null;var button=null;if(!fileBlockExists){fileBlock=$("<div/>");fileBlock.addClass("submission__answer__file__block "+className);fileBlock.appendTo(sel.find(".submission__answer__files").first())}if(view.filesType==="image"){ariaLabelledBy="file_description_"+Math.random().toString(36).substr(2,9);div1=$("<div/>",{id:ariaLabelledBy});div1.addClass("submission__file__description__label");div1.text(view.filesDescriptions[filenum-view.fileCountBeforeUpload]+":");div1.appendTo(fileBlock);img=$("<img />");img.addClass("submission__answer__file submission--image");img.attr("aria-labelledby",ariaLabelledBy);img.attr("src",url);div2=$("<div/>");div2.html(img);div2.appendTo(fileBlock)}else{var description=view.filesDescriptions[filenum-view.fileCountBeforeUpload];var fileName=view.fileNames[filenum-view.fileCountBeforeUpload];file=$("<a />",{href:url,text:description+" ("+fileName+")"});file.addClass("submission__answer__file submission--file");file.attr("target","_blank");file.appendTo(fileBlock)}button=$("<button />");button.text("Delete File");button.addClass("delete__uploaded__file");button.attr("filenum",filenum);button.click(view.handleDeleteFileClick());button.appendTo(fileBlock);return url})}};OpenAssessment.Rubric=function(element){this.element=element};OpenAssessment.Rubric.prototype={criterionFeedback:function(criterionFeedback){var selector="textarea.answer__value";var feedback={};var rubric=this;$(selector,this.element).each(function(index,sel){var criterionName=rubric.getCriterionName(sel);if(typeof criterionFeedback!=="undefined"){$(sel).val(criterionFeedback[criterionName]);feedback[criterionName]=criterionFeedback[criterionName]}else{feedback[criterionName]=$(sel).val()}});return feedback},overallFeedback:function(overallFeedback){var selector=".assessment__rubric__question--feedback__value";if(typeof overallFeedback==="undefined"){return $(selector,this.element).val()}else{$(selector,this.element).val(overallFeedback)}},optionsSelected:function(optionsSelected){var selector="input[type=radio]";var rubric=this;if(typeof optionsSelected==="undefined"){var options={};$(selector+":checked",this.element).each(function(index,sel){options[rubric.getCriterionName(sel)]=sel.value});return options}else{$(selector,this.element).prop("checked",false);$(selector,this.element).each(function(index,sel){var criterionName=rubric.getCriterionName(sel);if(optionsSelected.hasOwnProperty(criterionName)){if(sel.value===optionsSelected[criterionName]){$(sel).prop("checked",true)}}})}},canSubmitCallback:function(callback){var rubric=this;callback(rubric.canSubmit());$(this.element).on("change keyup drop paste",function(){callback(rubric.canSubmit())})},canSubmit:function(){var numChecked=$("input[type=radio]:checked",this.element).length;var numAvailable=$(".field--radio.assessment__rubric__question.has--options",this.element).length;var completedRequiredComments=true;$("textarea[required]",this.element).each(function(){var trimmedText=$.trim($(this).val());if(trimmedText===""){completedRequiredComments=false}});return numChecked===numAvailable&&completedRequiredComments},changesExistCallback:function(callback){var rubric=this;callback(rubric.changesExist());$(this.element).on("change keyup drop paste",function(){callback(rubric.changesExist())})},changesExist:function(){var numChecked=$("input[type=radio]:checked",this.element).length;var textExists=false;$("textarea",this.element).each(function(){var trimmedText=$.trim($(this).val());if(trimmedText!==""){textExists=true}});return numChecked>0||textExists},showCorrections:function(corrections){var selector="input[type=radio]";var hasErrors=false;var rubric=this;$(selector,this.element).each(function(index,sel){var listItem=$(sel).parents(".assessment__rubric__question");if(corrections.hasOwnProperty(rubric.getCriterionName(sel))){hasErrors=true;listItem.find(".message--incorrect").removeClass("is--hidden");listItem.find(".message--correct").addClass("is--hidden")}else{listItem.find(".message--correct").removeClass("is--hidden");listItem.find(".message--incorrect").addClass("is--hidden")}});return hasErrors},getCriterionName:function(element){return $(element).data("criterion-name")}};OpenAssessment.SelfView=function(element,server,baseView){this.element=element;this.server=server;this.baseView=baseView;this.rubric=null;this.isRendering=false;this.announceStatus=false;this.dateFactory=new OpenAssessment.DateTimeFactory(this.element)};OpenAssessment.SelfView.prototype={UNSAVED_WARNING_KEY:"self-assessment",load:function(usageID){var view=this;var stepID=".step--self-assessment";var focusID="[id='oa_self_"+usageID+"']";view.isRendering=true;this.server.render("self_assessment").done(function(html){$(stepID,view.element).replaceWith(html);view.isRendering=false;view.server.renderLatex($(stepID,view.element));view.installHandlers();view.baseView.announceStatusChangeToSRandFocus(stepID,usageID,false,view,focusID);view.dateFactory.apply()}).fail(function(){view.showLoadError("self-assessment")})},installHandlers:function(){var view=this;var sel=$(".step--self-assessment",view.element);this.baseView.setUpCollapseExpand(sel);this.baseView.bindLatexPreview(sel);var rubricSelector=$(".self-assessment--001__assessment",this.element);if(rubricSelector.size()>0){var rubricElement=rubricSelector.get(0);this.rubric=new OpenAssessment.Rubric(rubricElement)}else{this.rubric=null}if(this.rubric!==null){this.rubric.canSubmitCallback($.proxy(this.selfSubmitEnabled,this));this.rubric.changesExistCallback($.proxy(this.assessmentRubricChanges,this))}sel.find(".self-assessment--001__assessment__submit").click(function(eventObject){eventObject.preventDefault();view.selfAssess()})},selfSubmitEnabled:function(enabled){return this.baseView.buttonEnabled(".self-assessment--001__assessment__submit",enabled)},assessmentRubricChanges:function(changesExist){if(changesExist){this.baseView.unsavedWarningEnabled(true,this.UNSAVED_WARNING_KEY,gettext("If you leave this page without submitting your self assessment, you will lose any work you have done."))}},selfAssess:function(){var view=this;var baseView=this.baseView;var usageID=baseView.getUsageID();baseView.toggleActionError("self",null);view.selfSubmitEnabled(false);this.server.selfAssess(this.rubric.optionsSelected(),this.rubric.criterionFeedback(),this.rubric.overallFeedback()).done(function(){baseView.unsavedWarningEnabled(false,view.UNSAVED_WARNING_KEY);view.announceStatus=true;baseView.loadAssessmentModules(usageID)}).fail(function(errMsg){baseView.toggleActionError("self",errMsg);view.selfSubmitEnabled(true)})}};OpenAssessment.StaffView=function(element,server,baseView){this.element=element;this.server=server;this.baseView=baseView;this.isRendering=false;this.announceStatus=false};OpenAssessment.StaffView.prototype={load:function(usageID){var view=this;var stepID=".step--staff-assessment";var focusID="[id='oa_staff_grade_"+usageID+"']";view.isRendering=true;this.server.render("staff_assessment").done(function(html){$(".step--staff-assessment",view.element).replaceWith(html);view.isRendering=false;view.installHandlers();view.baseView.announceStatusChangeToSRandFocus(stepID,usageID,false,view,focusID)}).fail(function(){view.baseView.showLoadError("staff-assessment")})},installHandlers:function(){this.baseView.setUpCollapseExpand($(".step--staff-assessment",this.element))}};(function(OpenAssessment){"use strict";OpenAssessment.StaffAreaView=function(element,server,baseView){this.element=element;this.server=server;this.baseView=baseView};OpenAssessment.StaffAreaView.prototype={FULL_GRADE_UNSAVED_WARNING_KEY:"staff-grade",OVERRIDE_UNSAVED_WARNING_KEY:"staff-override",load:function(){var view=this;if($(".openassessment__staff-area",view.element).length>0){this.server.render("staff_area").done(function(html){$(".openassessment__staff-area",view.element).replaceWith(html);view.server.renderLatex($(".openassessment__staff-area",view.element));view.installHandlers()}).fail(function(){view.baseView.showLoadError("staff_area")})}},loadStudentInfo:function(classToExpand){var view=this;var $manageLearnersTab=$(".openassessment__staff-tools",this.element);var $form=$manageLearnersTab.find(".openassessment_student_info_form");var studentUsername=$manageLearnersTab.find(".openassessment__student_username").val();var showFormError=function(errorMessage){$form.find(".form--error").text(errorMessage).focus()};var deferred=$.Deferred();$(".openassessment__student-info",view.element).text("");if(studentUsername.trim()){this.server.studentInfo(studentUsername).done(function(html){showFormError("");$(".openassessment__student-info",view.element).replaceWith(html);$manageLearnersTab.on("click",".action--submit-cancel-submission",function(eventObject){eventObject.preventDefault();view.cancelSubmission($(this).data("submission-uuid"))});var handleChange=function(eventData){view.handleCommentChanged(eventData)};$manageLearnersTab.find(".cancel_submission_comments").on("change keyup drop paste",handleChange);var $rubric=$manageLearnersTab.find(".staff-assessment__assessment");if($rubric.size()>0){var rubricElement=$rubric.get(0);var rubric=new OpenAssessment.Rubric(rubricElement);rubric.canSubmitCallback($.proxy(view.staffSubmitEnabled,view,$manageLearnersTab));rubric.changesExistCallback($.proxy(view.assessmentRubricChanges,view,view.OVERRIDE_UNSAVED_WARNING_KEY));$manageLearnersTab.find(".wrapper--staff-assessment .action--submit",view.element).click(function(eventObject){var target=$(eventObject.currentTarget),rootElement=target.closest(".openassessment__student-info"),submissionID=rootElement.data("submission-uuid");eventObject.preventDefault();view.submitStaffOverride(submissionID,rubric,$manageLearnersTab)})}view.baseView.setUpCollapseExpand($manageLearnersTab);$manageLearnersTab.find(".staff-info__student__report__summary").focus();if(classToExpand){$manageLearnersTab.find("."+classToExpand+" ."+view.baseView.SLIDABLE_CONTENT_CLASS).slideDown();$manageLearnersTab.find("."+classToExpand+" ."+view.baseView.SLIDABLE_CLASS).addClass(view.baseView.IS_SHOWING_CLASS).attr("aria-expanded","true").focus()}deferred.resolve()}).fail(function(){showFormError(gettext("Unexpected server error."));deferred.reject()})}else{showFormError(gettext("You must provide a learner name."));deferred.reject()}return deferred.promise()},confirmSubmitGradeForTeam:function(){var msg=gettext("This grade will be applied to all members of the team. "+"Do you want to continue?");return confirm(msg)},loadStaffGradeForm:function(){var view=this;var $staffGradeTab=$(".openassessment__staff-grading",this.element);var $staffGradeControl=$staffGradeTab.find("."+view.baseView.SLIDABLE_CLASS);var $staffGradeContent=$staffGradeTab.find("."+view.baseView.SLIDABLE_CONTENT_CLASS);var $staffGradeContainer=$staffGradeTab.find("."+view.baseView.SLIDABLE_CONTAINER_CLASS);var deferred=$.Deferred();var showFormError=function(errorMessage){$staffGradeTab.find(".staff__grade__form--error").text(errorMessage).focus()};$staffGradeControl.attr("aria-expanded","true");if(this.staffGradeFormLoaded){$staffGradeContent.slideDown();$staffGradeContainer.addClass(view.baseView.IS_SHOWING_CLASS);deferred.resolve()}else{this.staffGradeFormLoaded=true;this.server.staffGradeForm().done(function(html){showFormError("");$staffGradeTab.find(".staff__grade__form").replaceWith(html);view.updateStaffGradeCounts();var $rubric=$staffGradeTab.find(".staff-assessment__assessment");if($rubric.size()>0){var rubricElement=$rubric.get(0);var rubric=new OpenAssessment.Rubric(rubricElement);rubric.canSubmitCallback($.proxy(view.staffSubmitEnabled,view,$staffGradeTab));rubric.changesExistCallback($.proxy(view.assessmentRubricChanges,view,view.FULL_GRADE_UNSAVED_WARNING_KEY));$staffGradeTab.find(".wrapper--staff-assessment .action--submit").click(function(eventObject){var submissionID=$staffGradeTab.find(".staff__grade__form").data("submission-uuid");var teamSubmissionEnabled=$staffGradeTab.find(".staff__grade__form").data("team-submission")==="True";eventObject.preventDefault();if(teamSubmissionEnabled&&!view.confirmSubmitGradeForTeam()){return}view.submitStaffGrade(submissionID,rubric,$staffGradeTab,$(eventObject.currentTarget).hasClass("continue_grading--action"))})}$staffGradeContent.slideDown(function(){$staffGradeControl.focus();view.baseView.setUpCollapseExpand($(".staff__grade__form",view.element))});$staffGradeContainer.addClass(view.baseView.IS_SHOWING_CLASS);deferred.resolve()}).fail(function(){showFormError(gettext("Unexpected server error."));view.staffGradeFormLoaded=false;deferred.reject()})}return deferred.promise()},closeStaffGradeForm:function(clear){var view=this;var $staffGradeTab=$(".openassessment__staff-grading",view.element);var $staffGradeControl=$staffGradeTab.find("."+view.baseView.SLIDABLE_CLASS).first();var $staffGradeContent=$staffGradeTab.find("."+view.baseView.SLIDABLE_CONTENT_CLASS);var $staffGradeContainer=$staffGradeTab.find("."+view.baseView.SLIDABLE_CONTAINER_CLASS);$staffGradeControl.attr("aria-expanded","false");if(clear){$staffGradeTab.find(".staff__grade__form").replaceWith('<div class="staff__grade__form"></div>');this.updateStaffGradeCounts()}else{$staffGradeContent.slideUp()}$staffGradeContainer.removeClass(view.baseView.IS_SHOWING_CLASS);$staffGradeControl.focus()},updateStaffGradeCounts:function(){var view=this;var $staffGradeTab=$(".openassessment__staff-grading",this.element);view.server.staffGradeCounts().done(function(html){$staffGradeTab.find(".staff__grade__status").replaceWith(html)}).fail(function(){$staffGradeTab.find(".staff__grade__status").replaceWith('<span class="staff__grade__status"><span class="staff__grade__value"><span class="copy">'+gettext("Error getting the number of ungraded responses")+"</span></span></span>")})},installHandlers:function(){var view=this;var $staffArea=$(".openassessment__staff-area",this.element);var $manageLearnersTab=$(".openassessment__staff-tools",$staffArea);var $staffGradeTool=$(".openassessment__staff-grading",$staffArea);if($staffArea.length<=0){return}$staffArea.find(".ui-staff__button").click(function(eventObject){$staffArea.find(".ui-staff__button").each(function(index,button){if(button!==eventObject.currentTarget){var $panel=$staffArea.find("."+$(button).data("panel")).first();$panel.slideUp(0)}});var $button=$(eventObject.currentTarget),$panel=$staffArea.find("."+$button.data("panel")).first();if($button.hasClass("is--active")){$button.removeClass("is--active").attr("aria-expanded","false");$panel.slideUp()}else{$staffArea.find(".ui-staff__button").removeClass("is--active").attr("aria-expanded","false");$button.addClass("is--active").attr("aria-expanded","true");$panel.slideDown()}$panel.find(".ui-staff_close_button").focus()});$staffArea.find(".ui-staff_close_button").click(function(eventObject){var $button=$(eventObject.currentTarget),$panel=$button.closest(".wrapper--ui-staff");$staffArea.find(".ui-staff__button").removeClass("is--active").attr("aria-expanded","false");$panel.slideUp();$staffArea.find(".ui-staff__button").each(function(index,button){var $staffPanel=$staffArea.find("."+$(button).data("panel")).first();if($staffPanel[0]===$panel[0]){$(button).focus()}})});$manageLearnersTab.find(".openassessment_student_info_form").submit(function(eventObject){eventObject.preventDefault();view.loadStudentInfo()});$manageLearnersTab.find(".action--submit-username").click(function(eventObject){eventObject.preventDefault();view.loadStudentInfo()});$manageLearnersTab.find(".action--submit-training").click(function(eventObject){eventObject.preventDefault();view.scheduleTraining()});$manageLearnersTab.find(".action--submit-unfinished-tasks").click(function(eventObject){eventObject.preventDefault();view.rescheduleUnfinishedTasks()});$staffGradeTool.find(".staff__grade__show-form").click(function(event){var $container=$(event.currentTarget).closest("."+view.baseView.SLIDABLE_CONTAINER_CLASS);var wasShowing=$container.hasClass(view.baseView.IS_SHOWING_CLASS);if(wasShowing){view.closeStaffGradeForm(false)}else{view.loadStaffGradeForm()}})},scheduleTraining:function(){var view=this;this.server.scheduleTraining().done(function(msg){$(".schedule_training_message",view.element).text(msg)}).fail(function(errMsg){$(".schedule_training_message",view.element).text(errMsg)})},rescheduleUnfinishedTasks:function(){var view=this;this.server.rescheduleUnfinishedTasks().done(function(msg){$(".reschedule_unfinished_tasks_message",view.element).text(msg)}).fail(function(errMsg){$(".reschedule_unfinished_tasks_message",view.element).text(errMsg)})},cancelSubmission:function(submissionUUID){this.cancelSubmissionEnabled(false);var view=this;var comments=$(".cancel_submission_comments",this.element).val();this.server.cancelSubmission(submissionUUID,comments).done(function(){view.loadStudentInfo("staff-info__student__grade")}).fail(function(errorMessage){$(".cancel-submission-error").html(_.escape(errorMessage))})},cancelSubmissionEnabled:function(enabled){return this.baseView.buttonEnabled(".action--submit-cancel-submission",enabled)},comment:function(text){var $submissionComments=$(".cancel_submission_comments",this.element);if(typeof text==="undefined"){return $submissionComments.val()}else{$submissionComments.val(text)}},handleCommentChanged:function(){var isBlank=$.trim(this.comment())!=="";this.cancelSubmissionEnabled(isBlank)},staffSubmitEnabled:function(scope,enabled){return this.baseView.buttonEnabled(".wrapper--staff-assessment .action--submit",enabled)},assessmentRubricChanges:function(key,changesExist){if(changesExist){this.baseView.unsavedWarningEnabled(true,key,gettext("If you leave this page without submitting your staff assessment, you will lose any work you have done."))}},submitStaffOverride:function(submissionID,rubric,scope){var view=this;var successCallback=function(){view.baseView.unsavedWarningEnabled(false,view.OVERRIDE_UNSAVED_WARNING_KEY);view.loadStudentInfo("staff-info__student__grade")};this.callStaffAssess(submissionID,rubric,scope,successCallback,".staff-override-error","regrade")},submitStaffGrade:function(submissionID,rubric,scope,continueGrading){var view=this;var successCallback=function(){view.baseView.unsavedWarningEnabled(false,view.FULL_GRADE_UNSAVED_WARNING_KEY);view.staffGradeFormLoaded=false;if(continueGrading){view.loadStaffGradeForm();view.baseView.scrollToTop(".openassessment__staff-area")}else{view.closeStaffGradeForm(true)}};this.callStaffAssess(submissionID,rubric,scope,successCallback,".staff-grade-error","full-grade")},callStaffAssess:function(submissionID,rubric,scope,successCallback,errorSelector,assessType){var view=this;view.staffSubmitEnabled(scope,false);this.server.staffAssess(rubric.optionsSelected(),rubric.criterionFeedback(),rubric.overallFeedback(),submissionID,assessType).done(successCallback).fail(function(errorMessage){scope.find(errorSelector).html(_.escape(errorMessage));view.staffSubmitEnabled(scope,true)})}}})(OpenAssessment);OpenAssessment.StudentTrainingView=function(element,server,baseView){this.element=element;this.server=server;this.baseView=baseView;this.rubric=null;this.isRendering=false;this.announceStatus=false;this.dateFactory=new OpenAssessment.DateTimeFactory(this.element)};OpenAssessment.StudentTrainingView.prototype={load:function(usageID){var view=this;var stepID=".step--student-training";var focusID="[id='oa_training_"+usageID+"']";view.isRendering=true;this.server.render("student_training").done(function(html){$(stepID,view.element).replaceWith(html);view.isRendering=false;view.server.renderLatex($(stepID,view.element));view.installHandlers();view.baseView.announceStatusChangeToSRandFocus(stepID,usageID,false,view,focusID);view.announceStatus=false;view.dateFactory.apply()}).fail(function(){view.baseView.showLoadError("student-training")})},installHandlers:function(){var sel=$(".step--student-training",this.element);var view=this;this.baseView.setUpCollapseExpand(sel);var rubricSelector=$(".student-training--001__assessment",this.element);if(rubricSelector.size()>0){var rubricElement=rubricSelector.get(0);this.rubric=new OpenAssessment.Rubric(rubricElement)}if(this.rubric!==null){this.rubric.canSubmitCallback($.proxy(this.assessButtonEnabled,this))}sel.find(".student-training--001__assessment__submit").click(function(eventObject){eventObject.preventDefault();view.assess();view.announceStatus=true})},assess:function(){this.assessButtonEnabled(false);var options={};if(this.rubric!==null){options=this.rubric.optionsSelected()}var view=this;var baseView=this.baseView;var usageID=baseView.getUsageID();this.server.trainingAssess(options).done(function(corrections){var incorrect=$(".openassessment__student-training--incorrect",view.element);var instructions=$(".openassessment__student-training--instructions",view.element);var $questionAnswers=$(".question__answers",view.rubric.element);if(!view.rubric.showCorrections(corrections)){view.load(usageID);baseView.loadAssessmentModules(usageID);incorrect.addClass("is--hidden");instructions.removeClass("is--hidden")}else{instructions.addClass("is--hidden");incorrect.removeClass("is--hidden");$questionAnswers.each(function(index,answer){var $notification=$(".step__message.message",view.rubric.element).not(".is--hidden");$(answer).attr("aria-describedby",$($notification[index]).attr("id"))});baseView.srReadTexts([gettext("Feedback available for selection.")])}baseView.scrollToTop(".step--student-training")}).fail(function(errMsg){baseView.toggleActionError("student-training",errMsg);view.assessButtonEnabled(true)})},assessButtonEnabled:function(isEnabled){return this.baseView.buttonEnabled(".student-training--001__assessment__submit",isEnabled)}};!function(a,b){"function"==typeof define&&define.amd?define(["underscore","backbone"],function(c,d){return a.Backgrid=b(c,d)}):"object"==typeof exports?module.exports=b(require("underscore"),require("backbone")):a.Backgrid=b(a._,a.Backbone)}(this,function(a,b){"use strict";function c(a,b,c){var d=b-(a+"").length;d=d<0?0:d;for(var e="",f=0;f<d;f++)e+=c;return e+a}var d="\t\n\v\f\r   ᠎             　\u2028\u2029\ufeff";if(!String.prototype.trim||d.trim()){d="["+d+"]";var e=new RegExp("^"+d+d+"*"),f=new RegExp(d+d+"*$");String.prototype.trim=function(){if(void 0===this||null===this)throw new TypeError("can't convert "+this+" to object");return String(this).replace(e,"").replace(f,"")}}var g=b.$,h={Extension:{},resolveNameToClass:function(b,c){if(a.isString(b)){var d=a.map(b.split("-"),function(a){return a.slice(0,1).toUpperCase()+a.slice(1)}).join("")+c,e=h[d]||h.Extension[d];if(a.isUndefined(e))throw new ReferenceError("Class '"+d+"' not found");return e}return b},callByNeed:function(){var b=arguments[0];if(!a.isFunction(b))return b;var c=arguments[1],d=[].slice.call(arguments,2);return b.apply(c,d+""?d:[])}};a.extend(h,b.Events);var i=h.Command=function(b){a.extend(this,{altKey:!!b.altKey,char:b.char,charCode:b.charCode,ctrlKey:!!b.ctrlKey,key:b.key,keyCode:b.keyCode,locale:b.locale,location:b.location,metaKey:!!b.metaKey,repeat:!!b.repeat,shiftKey:!!b.shiftKey,which:b.which})};a.extend(i.prototype,{moveUp:function(){return 38==this.keyCode},moveDown:function(){return 40===this.keyCode},moveLeft:function(){return this.shiftKey&&9===this.keyCode},moveRight:function(){return!this.shiftKey&&9===this.keyCode},save:function(){return 13===this.keyCode},cancel:function(){return 27===this.keyCode},passThru:function(){return!(this.moveUp()||this.moveDown()||this.moveLeft()||this.moveRight()||this.save()||this.cancel())}});var j=h.CellFormatter=function(){};a.extend(j.prototype,{fromRaw:function(a,b){return a},toRaw:function(a,b){return a}});var k=h.NumberFormatter=function(b){if(a.extend(this,this.defaults,b||{}),this.decimals<0||this.decimals>20)throw new RangeError("decimals must be between 0 and 20")};k.prototype=new j,a.extend(k.prototype,{defaults:{decimals:2,decimalSeparator:".",orderSeparator:","},HUMANIZED_NUM_RE:/(\d)(?=(?:\d{3})+$)/g,fromRaw:function(b,c){if(a.isNull(b)||a.isUndefined(b))return"";b=parseFloat(b).toFixed(~~this.decimals);var d=b.split("."),e=d[0],f=d[1]?(this.decimalSeparator||".")+d[1]:"";return e.replace(this.HUMANIZED_NUM_RE,"$1"+this.orderSeparator)+f},toRaw:function(b,c){if(b=b.trim(),""===b)return null;for(var d="",e=b.split(this.orderSeparator),f=0;f<e.length;f++)d+=e[f];var g=d.split(this.decimalSeparator);d="";for(var f=0;f<g.length;f++)d=d+g[f]+".";"."===d[d.length-1]&&(d=d.slice(0,d.length-1));var h=1*(1*d).toFixed(~~this.decimals);return a.isNumber(h)&&!a.isNaN(h)?h:void 0}});var l=h.PercentFormatter=function(){h.NumberFormatter.apply(this,arguments)};l.prototype=new h.NumberFormatter,a.extend(l.prototype,{defaults:a.extend({},k.prototype.defaults,{multiplier:1,symbol:"%"}),fromRaw:function(a,b){var c=[].slice.call(arguments,1);return c.unshift(a*this.multiplier),(k.prototype.fromRaw.apply(this,c)||"0")+this.symbol},toRaw:function(b,c){var d=b.split(this.symbol);if(d&&d[0]&&""===d[1]||null==d[1]){var e=k.prototype.toRaw.call(this,d[0]);return a.isUndefined(e)?e:e/this.multiplier}}});var m=h.DatetimeFormatter=function(b){if(a.extend(this,this.defaults,b||{}),!this.includeDate&&!this.includeTime)throw new Error("Either includeDate or includeTime must be true")};m.prototype=new j,a.extend(m.prototype,{defaults:{includeDate:!0,includeTime:!0,includeMilli:!1},DATE_RE:/^([+\-]?\d{4})-(\d{2})-(\d{2})$/,TIME_RE:/^(\d{2}):(\d{2}):(\d{2})(\.(\d{3}))?$/,ISO_SPLITTER_RE:/T|Z| +/,_convert:function(b,d){if(""===(b+"").trim())return null;var e,f=null;if(a.isNumber(b)){var g=new Date(b);e=c(g.getUTCFullYear(),4,0)+"-"+c(g.getUTCMonth()+1,2,0)+"-"+c(g.getUTCDate(),2,0),f=c(g.getUTCHours(),2,0)+":"+c(g.getUTCMinutes(),2,0)+":"+c(g.getUTCSeconds(),2,0)}else{b=b.trim();var h=b.split(this.ISO_SPLITTER_RE)||[];e=this.DATE_RE.test(h[0])?h[0]:"",f=e&&h[1]?h[1]:this.TIME_RE.test(h[0])?h[0]:""}var i=this.DATE_RE.exec(e)||[],j=this.TIME_RE.exec(f)||[];if(d){if(this.includeDate&&a.isUndefined(i[0]))return;if(this.includeTime&&a.isUndefined(j[0]))return;if(!this.includeDate&&e)return;if(!this.includeTime&&f)return}var g=new Date(Date.UTC(1*i[1]||0,1*i[2]-1||0,1*i[3]||0,1*j[1]||null,1*j[2]||null,1*j[3]||null,1*j[5]||null)),k="";return this.includeDate&&(k=c(g.getUTCFullYear(),4,0)+"-"+c(g.getUTCMonth()+1,2,0)+"-"+c(g.getUTCDate(),2,0)),this.includeTime&&(k=k+(this.includeDate?"T":"")+c(g.getUTCHours(),2,0)+":"+c(g.getUTCMinutes(),2,0)+":"+c(g.getUTCSeconds(),2,0),this.includeMilli&&(k=k+"."+c(g.getUTCMilliseconds(),3,0))),this.includeDate&&this.includeTime&&(k+="Z"),k},fromRaw:function(b,c){return a.isNull(b)||a.isUndefined(b)?"":this._convert(b)},toRaw:function(a,b){return this._convert(a,!0)}});var n=h.StringFormatter=function(){};n.prototype=new j,a.extend(n.prototype,{fromRaw:function(b,c){return a.isUndefined(b)||a.isNull(b)?"":b+""}});var o=h.EmailFormatter=function(){};o.prototype=new j,a.extend(o.prototype,{toRaw:function(b,c){var d=b.trim().split("@");if(2===d.length&&a.all(d))return b}});var p=h.SelectFormatter=function(){};p.prototype=new j,a.extend(p.prototype,{fromRaw:function(b,c){return a.isArray(b)?b:null!=b?[b]:[]}});var q=h.CellEditor=b.View.extend({initialize:function(a){this.formatter=a.formatter,this.column=a.column,this.column instanceof B||(this.column=new B(this.column)),this.listenTo(this.model,"backgrid:editing",this.postRender)},postRender:function(a,b){return null!=b&&b.get("name")!=this.column.get("name")||this.$el.focus(),this}}),r=h.InputCellEditor=q.extend({tagName:"input",attributes:{type:"text"},events:{blur:"saveOrCancel",keydown:"saveOrCancel"},initialize:function(a){r.__super__.initialize.apply(this,arguments),a.placeholder&&this.$el.attr("placeholder",a.placeholder)},render:function(){var a=this.model;return this.$el.val(this.formatter.fromRaw(a.get(this.column.get("name")),a)),this},saveOrCancel:function(b){var c=this.formatter,d=this.model,e=this.column,f=new i(b),g="blur"===b.type;if(f.moveUp()||f.moveDown()||f.moveLeft()||f.moveRight()||f.save()||g){b.preventDefault(),b.stopPropagation();var h=this.$el.val(),j=c.toRaw(h,d);a.isUndefined(j)?d.trigger("backgrid:error",d,e,h):(d.set(e.get("name"),j),d.trigger("backgrid:edited",d,e,f))}else f.cancel()&&(b.stopPropagation(),d.trigger("backgrid:edited",d,e,f))},postRender:function(a,b){if(null==b||b.get("name")==this.column.get("name"))if("right"===this.$el.css("text-align")){var c=this.$el.val();this.$el.focus().val(null).val(c)}else this.$el.focus();return this}}),s=h.Cell=b.View.extend({tagName:"td",formatter:j,editor:r,events:{click:"enterEditMode"},initialize:function(b){this.column=b.column,this.column instanceof B||(this.column=new B(this.column));var c=this.column,d=this.model,e=this.$el,f=h.resolveNameToClass(c.get("formatter")||this.formatter,"Formatter");a.isFunction(f.fromRaw)||a.isFunction(f.toRaw)||(f=new f),this.formatter=f,this.editor=h.resolveNameToClass(this.editor,"CellEditor"),this.listenTo(d,"change:"+c.get("name"),function(){e.hasClass("editor")||this.render()}),this.listenTo(d,"backgrid:error",this.renderError),this.listenTo(c,"change:editable change:sortable change:renderable",function(a){var b=a.changedAttributes();for(var c in b)b.hasOwnProperty(c)&&e.toggleClass(c,b[c])}),this.updateStateClassesMaybe()},updateStateClassesMaybe:function(){var a=this.model,b=this.column,c=this.$el;c.toggleClass("editable",h.callByNeed(b.editable(),b,a)),c.toggleClass("sortable",h.callByNeed(b.sortable(),b,a)),c.toggleClass("renderable",h.callByNeed(b.renderable(),b,a))},render:function(){var a=this.$el;a.empty();var b=this.model,c=this.column.get("name");return a.text(this.formatter.fromRaw(b.get(c),b)),a.addClass(c),this.updateStateClassesMaybe(),this.delegateEvents(),this},enterEditMode:function(){var a=this.model,b=this.column,c=h.callByNeed(b.editable(),b,a);c&&(this.currentEditor=new this.editor({column:this.column,model:this.model,formatter:this.formatter}),a.trigger("backgrid:edit",a,b,this,this.currentEditor),this.undelegateEvents(),this.$el.empty(),this.$el.append(this.currentEditor.$el),this.currentEditor.render(),this.$el.addClass("editor"),a.trigger("backgrid:editing",a,b,this,this.currentEditor))},renderError:function(a,b){null!=b&&b.get("name")!=this.column.get("name")||this.$el.addClass("error")},exitEditMode:function(){this.$el.removeClass("error"),this.currentEditor.remove(),this.stopListening(this.currentEditor),delete this.currentEditor,this.$el.removeClass("editor"),this.render()},remove:function(){return this.currentEditor&&(this.currentEditor.remove.apply(this.currentEditor,arguments),delete this.currentEditor),s.__super__.remove.apply(this,arguments)}}),t=h.StringCell=s.extend({className:"string-cell",formatter:n}),u=h.UriCell=s.extend({className:"uri-cell",title:null,target:"_blank",initialize:function(a){u.__super__.initialize.apply(this,arguments),this.title=a.title||this.title,this.target=a.target||this.target},render:function(){this.$el.empty();var a=this.model.get(this.column.get("name")),b=this.formatter.fromRaw(a,this.model);return this.$el.append(g("<a>",{tabIndex:-1,href:a,title:this.title||b,target:this.target}).text(b)),this.delegateEvents(),this}}),v=(h.EmailCell=t.extend({className:"email-cell",formatter:o,render:function(){this.$el.empty();var a=this.model,b=this.formatter.fromRaw(a.get(this.column.get("name")),a);return this.$el.append(g("<a>",{tabIndex:-1,href:"mailto:"+b,title:b}).text(b)),this.delegateEvents(),this}}),h.NumberCell=s.extend({className:"number-cell",decimals:k.prototype.defaults.decimals,decimalSeparator:k.prototype.defaults.decimalSeparator,orderSeparator:k.prototype.defaults.orderSeparator,formatter:k,initialize:function(a){v.__super__.initialize.apply(this,arguments);var b=this.formatter;b.decimals=this.decimals,b.decimalSeparator=this.decimalSeparator,b.orderSeparator=this.orderSeparator}})),w=(h.IntegerCell=v.extend({className:"integer-cell",decimals:0}),h.PercentCell=v.extend({className:"percent-cell",multiplier:l.prototype.defaults.multiplier,symbol:l.prototype.defaults.symbol,formatter:l,initialize:function(){w.__super__.initialize.apply(this,arguments);var a=this.formatter;a.multiplier=this.multiplier,a.symbol=this.symbol}})),x=h.DatetimeCell=s.extend({className:"datetime-cell",includeDate:m.prototype.defaults.includeDate,includeTime:m.prototype.defaults.includeTime,includeMilli:m.prototype.defaults.includeMilli,formatter:m,initialize:function(b){x.__super__.initialize.apply(this,arguments);var c=this.formatter;c.includeDate=this.includeDate,c.includeTime=this.includeTime,c.includeMilli=this.includeMilli;var d=this.includeDate?"YYYY-MM-DD":"";d+=this.includeDate&&this.includeTime?"T":"",d+=this.includeTime?"HH:mm:ss":"",d+=this.includeTime&&this.includeMilli?".SSS":"",this.editor=this.editor.extend({attributes:a.extend({},this.editor.prototype.attributes,this.editor.attributes,{placeholder:d})})}}),y=(h.DateCell=x.extend({className:"date-cell",includeTime:!1}),h.TimeCell=x.extend({className:"time-cell",includeDate:!1}),h.BooleanCellEditor=q.extend({tagName:"input",attributes:{tabIndex:-1,type:"checkbox"},events:{mousedown:function(){this.mouseDown=!0},blur:"enterOrExitEditMode",mouseup:function(){this.mouseDown=!1},change:"saveOrCancel",keydown:"saveOrCancel"},render:function(){var a=this.model,b=this.formatter.fromRaw(a.get(this.column.get("name")),a);return this.$el.prop("checked",b),this},enterOrExitEditMode:function(a){if(!this.mouseDown){var b=this.model;b.trigger("backgrid:edited",b,this.column,new i(a))}},saveOrCancel:function(a){var b=this.model,c=this.column,d=this.formatter,e=new i(a);if(e.passThru()&&"change"!=a.type)return!0;e.cancel()&&(a.stopPropagation(),b.trigger("backgrid:edited",b,c,e));var f=this.$el;if(e.save()||e.moveLeft()||e.moveRight()||e.moveUp()||e.moveDown()){a.preventDefault(),a.stopPropagation();var g=d.toRaw(f.prop("checked"),b);b.set(c.get("name"),g),b.trigger("backgrid:edited",b,c,e)}else if("change"==a.type){var g=d.toRaw(f.prop("checked"),b);b.set(c.get("name"),g),f.focus()}}})),z=(h.BooleanCell=s.extend({className:"boolean-cell",editor:y,events:{click:"enterEditMode"},render:function(){this.$el.empty();var a=this.model,b=this.column,c=h.callByNeed(b.editable(),b,a);return this.$el.append(g("<input>",{tabIndex:-1,type:"checkbox",checked:this.formatter.fromRaw(a.get(b.get("name")),a),disabled:!c})),this.delegateEvents(),this}}),h.SelectCellEditor=q.extend({tagName:"select",events:{change:"save",blur:"close",keydown:"close"},template:a.template('<option value="<%- value %>" <%= selected ? \'selected="selected"\' : "" %>><%- text %></option>',null,{variable:null,evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g}),setOptionValues:function(b){this.optionValues=b,this.optionValues=a.result(this,"optionValues")},setMultiple:function(a){this.multiple=a,this.$el.prop("multiple",a)},_renderOptions:function(b,c){for(var d="",e=0;e<b.length;e++)d+=this.template({text:b[e][0],value:b[e][1],selected:a.indexOf(c,b[e][1])>-1});return d},render:function(){this.$el.empty();var b=a.result(this,"optionValues"),c=this.model,d=this.formatter.fromRaw(c.get(this.column.get("name")),c);if(!a.isArray(b))throw new TypeError("optionValues must be an array");for(var e=null,f=null,e=null,h=null,i=null,j=0;j<b.length;j++){var e=b[j];if(a.isArray(e))f=e[0],e=e[1],this.$el.append(this.template({text:f,value:e,selected:a.indexOf(d,e)>-1}));else{if(!a.isObject(e))throw new TypeError("optionValues elements must be a name-value pair or an object hash of { name: 'optgroup label', value: [option name-value pairs] }");h=e.name,i=g("<optgroup></optgroup>",{label:h}),i.append(this._renderOptions.call(this,e.values,d)),this.$el.append(i)}}return this.delegateEvents(),this},save:function(a){var b=this.model,c=this.column;b.set(c.get("name"),this.formatter.toRaw(this.$el.val(),b))},close:function(a){var b=this.model,c=this.column,d=new i(a);d.cancel()?(a.stopPropagation(),b.trigger("backgrid:edited",b,c,new i(a))):(d.save()||d.moveLeft()||d.moveRight()||d.moveUp()||d.moveDown()||"blur"==a.type)&&(a.preventDefault(),a.stopPropagation(),this.save(a),b.trigger("backgrid:edited",b,c,new i(a)))}})),A=h.SelectCell=s.extend({className:"select-cell",editor:z,multiple:!1,formatter:p,optionValues:void 0,delimiter:", ",initialize:function(a){A.__super__.initialize.apply(this,arguments),this.listenTo(this.model,"backgrid:edit",function(a,b,c,d){b.get("name")==this.column.get("name")&&(d.setOptionValues(this.optionValues),d.setMultiple(this.multiple))})},render:function(){this.$el.empty();var b=a.result(this,"optionValues"),c=this.model,d=this.formatter.fromRaw(c.get(this.column.get("name")),c),e=[];try{if(!a.isArray(b)||a.isEmpty(b))throw new TypeError;for(var f=0;f<d.length;f++)for(var g=d[f],h=0;h<b.length;h++){var i=b[h];if(a.isArray(i)){var j=i[0],i=i[1];i==g&&e.push(j)}else{if(!a.isObject(i))throw new TypeError;for(var k=i.values,l=0;l<k.length;l++){var m=k[l];m[1]==g&&e.push(m[0])}}}this.$el.append(e.join(this.delimiter))}catch(a){if(a instanceof TypeError)throw new TypeError("'optionValues' must be of type {Array.<Array>|Array.<{name: string, values: Array.<Array>}>}");throw a}return this.delegateEvents(),this}}),B=h.Column=b.Model.extend({defaults:{name:void 0,label:void 0,sortable:!0,editable:!0,renderable:!0,formatter:void 0,sortType:"cycle",sortValue:void 0,direction:null,cell:void 0,headerCell:void 0},initialize:function(){this.has("label")||this.set({label:this.get("name")},{silent:!0});var a=h.resolveNameToClass(this.get("headerCell"),"HeaderCell"),b=h.resolveNameToClass(this.get("cell"),"Cell");this.set({cell:b,headerCell:a},{silent:!0})},sortValue:function(){var b=this.get("sortValue");return a.isString(b)?this[b]:a.isFunction(b)?b:function(a,b){return a.get(b)}}});a.each(["sortable","renderable","editable"],function(b){B.prototype[b]=function(){var c=this.get(b);return a.isString(c)?this[c]:a.isFunction(c)?c:!!c}});var C=h.Columns=b.Collection.extend({model:B}),D=h.Row=b.View.extend({tagName:"tr",initialize:function(a){var c=this.columns=a.columns;c instanceof b.Collection||(c=this.columns=new C(c));for(var d=this.cells=[],e=0;e<c.length;e++)d.push(this.makeCell(c.at(e),a));this.listenTo(c,"add",function(b,c){var e=c.indexOf(b),f=this.makeCell(b,a);d.splice(e,0,f);var g=this.$el;0===e?g.prepend(f.render().$el):e===c.length-1?g.append(f.render().$el):g.children().eq(e).before(f.render().$el)}),this.listenTo(c,"remove",function(a,b,c){d[c.index].remove(),d.splice(c.index,1)})},makeCell:function(a){return new(a.get("cell"))({column:a,model:this.model})},render:function(){this.$el.empty();for(var a=document.createDocumentFragment(),b=0;b<this.cells.length;b++)a.appendChild(this.cells[b].render().el);return this.el.appendChild(a),this.delegateEvents(),this},remove:function(){for(var a=0;a<this.cells.length;a++){var c=this.cells[a];c.remove.apply(c,arguments)}return b.View.prototype.remove.apply(this,arguments)}}),E=h.EmptyRow=b.View.extend({tagName:"tr",emptyText:null,initialize:function(a){this.emptyText=a.emptyText,this.columns=a.columns},render:function(){this.$el.empty();var b=document.createElement("td");b.setAttribute("colspan",this.columns.length);var c=document.createElement("span");return c.innerHTML=a.result(this,"emptyText"),b.appendChild(c),this.el.className="empty",this.el.appendChild(b),this}}),F=h.HeaderCell=b.View.extend({tagName:"th",events:{"click button":"onClick"},initialize:function(a){this.column=a.column,this.column instanceof B||(this.column=new B(this.column));var b=this.column,c=this.collection,d=this.$el;this.listenTo(b,"change:editable change:sortable change:renderable",function(a){var b=a.changedAttributes();for(var c in b)b.hasOwnProperty(c)&&d.toggleClass(c,b[c])}),this.listenTo(b,"change:direction",this.setCellDirection),this.listenTo(b,"change:name change:label",this.render),h.callByNeed(b.editable(),b,c)&&d.addClass("editable"),h.callByNeed(b.sortable(),b,c)&&d.addClass("sortable"),h.callByNeed(b.renderable(),b,c)&&d.addClass("renderable"),this.listenTo(c.fullCollection||c,"backgrid:sorted",this.removeCellDirection)},removeCellDirection:function(){this.$el.removeClass("ascending").removeClass("descending"),this.column.set("direction",null)},setCellDirection:function(a,b){this.$el.removeClass("ascending").removeClass("descending"),a.cid==this.column.cid&&this.$el.addClass(b)},onClick:function(a){function b(a,b){"ascending"===d.get("direction")?e.trigger(f,b,"descending"):"descending"===d.get("direction")?e.trigger(f,b,null):e.trigger(f,b,"ascending")}function c(a,b){"ascending"===d.get("direction")?e.trigger(f,b,"descending"):e.trigger(f,b,"ascending")}a.preventDefault();var d=this.column,e=this.collection,f="backgrid:sort",g=h.callByNeed(d.sortable(),d,this.collection);if(g){var i=d.get("sortType");"toggle"===i?c(this,d):b(this,d)}},render:function(){this.$el.empty();var a,b=this.column,c=h.callByNeed(b.sortable(),b,this.collection);return a=c?g("<button>").text(b.get("label")).append("<span class='sort-caret' aria-hidden='true'></span>"):document.createTextNode(b.get("label")),this.$el.append(a),this.$el.addClass(b.get("name")),this.$el.addClass(b.get("direction")),this.delegateEvents(),this}}),G=(h.HeaderRow=h.Row.extend({initialize:function(){h.Row.prototype.initialize.apply(this,arguments)},makeCell:function(a,b){var c=a.get("headerCell")||b.headerCell||F;return c=new c({column:a,collection:this.collection})}}),h.Header=b.View.extend({tagName:"thead",initialize:function(a){this.columns=a.columns,this.columns instanceof b.Collection||(this.columns=new C(this.columns)),this.row=new h.HeaderRow({columns:this.columns,collection:this.collection})},render:function(){return this.$el.append(this.row.render().$el),this.delegateEvents(),this},remove:function(){return this.row.remove.apply(this.row,arguments),b.View.prototype.remove.apply(this,arguments)}})),H=h.Body=b.View.extend({tagName:"tbody",initialize:function(a){this.columns=a.columns,this.columns instanceof b.Collection||(this.columns=new C(this.columns)),this.row=a.row||this.row||D,this.rows=this.collection.map(function(a){var b=new this.row({columns:this.columns,model:a});return b},this),this.emptyText=a.emptyText,this._unshiftEmptyRowMayBe();var c=this.collection;this.listenTo(c,"add",this.insertRow),this.listenTo(c,"remove",this.removeRow),this.listenTo(c,"sort",this.refresh),this.listenTo(c,"reset",this.refresh),this.listenTo(c,"backgrid:sort",this.sort),this.listenTo(c,"backgrid:edited",this.moveToNextCell),this.listenTo(this.columns,"add remove",this.updateEmptyRow)},_unshiftEmptyRowMayBe:function(){if(0===this.rows.length&&null!=this.emptyText)return this.emptyRow=new E({emptyText:this.emptyText,columns:this.columns}),this.rows.unshift(this.emptyRow),!0},insertRow:function(a,c,d){if(this.rows[0]instanceof E&&this.rows.pop().remove(),!(c instanceof b.Collection||d))return void this.collection.add(a,d=c);var e=new this.row({columns:this.columns,model:a}),f=c.indexOf(a);this.rows.splice(f,0,e);var g=this.$el,h=g.children(),i=e.render().$el;return f>=h.length?g.append(i):h.eq(f).before(i),this},removeRow:function(b,c,d){return d?((a.isUndefined(d.render)||d.render)&&this.rows[d.index].remove(),this.rows.splice(d.index,1),this._unshiftEmptyRowMayBe()&&this.render(),this):(this.collection.remove(b,d=c),void(this._unshiftEmptyRowMayBe()&&this.render()))},updateEmptyRow:function(){null!=this.emptyRow&&this.emptyRow.render()},refresh:function(){for(var a=0;a<this.rows.length;a++)this.rows[a].remove();return this.rows=this.collection.map(function(a){var b=new this.row({columns:this.columns,model:a});return b},this),this._unshiftEmptyRowMayBe(),this.render(),this.collection.trigger("backgrid:refresh",this),this},render:function(){this.$el.empty();for(var a=document.createDocumentFragment(),b=0;b<this.rows.length;b++){var c=this.rows[b];a.appendChild(c.render().el)}return this.el.appendChild(a),this.delegateEvents(),this},remove:function(){for(var a=0;a<this.rows.length;a++){var c=this.rows[a];c.remove.apply(c,arguments)}return b.View.prototype.remove.apply(this,arguments)},sort:function(c,d){if(!a.contains(["ascending","descending",null],d))throw new RangeError('direction must be one of "ascending", "descending" or `null`');a.isString(c)&&(c=this.columns.findWhere({name:c}));var e,f=this.collection;e="ascending"===d?-1:"descending"===d?1:null;var g=this.makeComparator(c.get("name"),e,e?c.sortValue():function(a){return 1*a.cid.replace("c","")});return b.PageableCollection&&f instanceof b.PageableCollection?(f.setSorting(e&&c.get("name"),e,{sortValue:c.sortValue()}),f.fullCollection?(null==f.fullCollection.comparator&&(f.fullCollection.comparator=g),f.fullCollection.sort(),f.trigger("backgrid:sorted",c,d,f),c.set("direction",d)):f.fetch({reset:!0,success:function(){f.trigger("backgrid:sorted",c,d,f),c.set("direction",d)}})):(f.comparator=g,f.sort(),f.trigger("backgrid:sorted",c,d,f),c.set("direction",d)),this},makeComparator:function(a,b,c){return function(d,e){var f,g=c(d,a),h=c(e,a);return 1===b&&(f=g,g=h,h=f),g===h?0:g<h?-1:1}},moveToNextCell:function(a,b,c){var d,e,f,g,i,j=this.collection.indexOf(a),k=this.columns.indexOf(b);if(k===-1)return this;if(this.rows[j].cells[k].exitEditMode(),c.moveUp()||c.moveDown()||c.moveLeft()||c.moveRight()||c.save()){var l=this.columns.length,m=l*this.collection.length;if(c.moveUp()||c.moveDown()){g=j+(c.moveUp()?-1:1);var n=this.rows[g];n?(d=n.cells[k],h.callByNeed(d.column.editable(),d.column,a)&&(d.enterEditMode(),a.trigger("backgrid:next",g,k,!1))):a.trigger("backgrid:next",g,k,!0)}else if(c.moveLeft()||c.moveRight()){for(var o=c.moveRight(),p=j*l+k+(o?1:-1);p>=0&&p<m;o?p++:p--)if(g=~~(p/l),i=p-g*l,d=this.rows[g].cells[i],e=h.callByNeed(d.column.renderable(),d.column,d.model),f=h.callByNeed(d.column.editable(),d.column,a),e&&f){d.enterEditMode(),a.trigger("backgrid:next",g,i,!1);break}p==m&&a.trigger("backgrid:next",~~(p/l),p-g*l,!0)}}return this}});h.Footer=b.View.extend({tagName:"tfoot",initialize:function(a){this.columns=a.columns,this.columns instanceof b.Collection||(this.columns=new h.Columns(this.columns))}}),h.Grid=b.View.extend({tagName:"table",className:"backgrid",header:G,body:H,footer:null,initialize:function(c){c.columns instanceof b.Collection||(c.columns=new C(c.columns||this.columns)),this.columns=c.columns,this.caption=c.caption;var d=a.omit(c,["el","id","attributes","className","tagName","events"]);this.body=c.body||this.body,this.body=new this.body(d),this.header=c.header||this.header,this.header&&(this.header=new this.header(d)),this.footer=c.footer||this.footer,this.footer&&(this.footer=new this.footer(d)),this.listenTo(this.columns,"reset",function(){this.header&&(this.header=new(this.header.remove().constructor)(d)),this.body=new(this.body.remove().constructor)(d),this.footer&&(this.footer=new(this.footer.remove().constructor)(d)),this.render()})},insertRow:function(){return this.body.insertRow.apply(this.body,arguments),this},removeRow:function(){return this.body.removeRow.apply(this.body,arguments),this},insertColumn:function(){return this.columns.add.apply(this.columns,arguments),this},removeColumn:function(){return this.columns.remove.apply(this.columns,arguments),this},sort:function(){return this.body.sort.apply(this.body,arguments),this},render:function(){return this.$el.empty(),this.caption&&this.$el.append(g("<caption>").text(this.caption)),this.header&&this.$el.append(this.header.render().$el),this.footer&&this.$el.append(this.footer.render().$el),this.$el.append(this.body.render().$el),this.delegateEvents(),this.trigger("backgrid:rendered",this),this},remove:function(){return this.header&&this.header.remove.apply(this.header,arguments),this.body.remove.apply(this.body,arguments),this.footer&&this.footer.remove.apply(this.footer,arguments),b.View.prototype.remove.apply(this,arguments)}});return h});
