import { DOMWidgetModel, DOMWidgetView, WidgetModel, ISerializers, Dict } from '@jupyter-widgets/base';
import { RoughCanvas } from 'roughjs/bin/canvas';
export declare class Path2DModel extends WidgetModel {
    defaults(): {
        _model_name: string;
        _model_module: any;
        _model_module_version: any;
        _view_name: string;
        _view_module: any;
        _view_module_version: any;
        value: string;
        _view_count: number;
    };
    initialize(attributes: any, options: any): void;
    value: Path2D;
    static model_name: string;
    static model_module: any;
    static model_module_version: any;
    static view_name: string;
    static view_module: any;
    static view_module_version: any;
}
export declare class CanvasModel extends DOMWidgetModel {
    defaults(): any;
    static serializers: ISerializers;
    initialize(attributes: any, options: any): void;
    private drawImageData;
    private onCommand;
    private processCommand;
    protected fillRect(x: number, y: number, width: number, height: number): void;
    protected strokeRect(x: number, y: number, width: number, height: number): void;
    private drawRects;
    protected fillArc(x: number, y: number, radius: number, startAngle: number, endAngle: number, anticlockwise: boolean): void;
    protected strokeArc(x: number, y: number, radius: number, startAngle: number, endAngle: number, anticlockwise: boolean): void;
    private drawArcs;
    protected fillCircle(x: number, y: number, radius: number): void;
    protected strokeCircle(x: number, y: number, radius: number): void;
    private drawCircles;
    protected strokeLine(args: any[], buffers: any): void;
    protected fillPath(args: any[], buffers: any): Promise<void>;
    private drawImage;
    private _drawImage;
    private putImageData;
    protected setAttr(attr: string, value: any): void;
    private clearCanvas;
    protected executeCommand(name: string, args?: any[]): void;
    private forEachView;
    private resizeCanvas;
    private syncImageData;
    static model_name: string;
    static model_module: any;
    static model_module_version: any;
    static view_name: string;
    static view_module: any;
    static view_module_version: any;
    canvas: HTMLCanvasElement;
    ctx: CanvasRenderingContext2D;
    views: Dict<Promise<CanvasView>>;
}
export declare class RoughCanvasModel extends CanvasModel {
    defaults(): any;
    initialize(attributes: any, options: any): void;
    protected fillRect(x: number, y: number, width: number, height: number): void;
    protected strokeRect(x: number, y: number, width: number, height: number): void;
    protected fillCircle(x: number, y: number, radius: number): void;
    protected strokeCircle(x: number, y: number, radius: number): void;
    protected strokeLine(args: any[], buffers: any): void;
    protected fillPath(args: any[], buffers: any): Promise<void>;
    protected fillArc(x: number, y: number, radius: number, startAngle: number, endAngle: number, anticlockwise: boolean): void;
    protected strokeArc(x: number, y: number, radius: number, startAngle: number, endAngle: number, anticlockwise: boolean): void;
    protected setAttr(attr: string, value: any): void;
    private getRoughFillStyle;
    private getRoughStrokeStyle;
    static model_name: string;
    roughCanvas: RoughCanvas;
    roughFillStyle: string;
    roughness: number;
    bowing: number;
}
export declare class CanvasView extends DOMWidgetView {
    render(): void;
    clear(): void;
    updateCanvas(): void;
    protected resizeCanvas(): void;
    private onMouseMove;
    private onMouseDown;
    private onMouseUp;
    private onMouseOut;
    private onTouchStart;
    private onTouchEnd;
    private onTouchMove;
    private onTouchCancel;
    protected getCoordinates(event: MouseEvent | Touch): {
        x: number;
        y: number;
    };
    get tagName(): string;
    el: HTMLCanvasElement;
    ctx: CanvasRenderingContext2D;
    model: CanvasModel | MultiCanvasModel;
}
export declare class MultiCanvasModel extends DOMWidgetModel {
    defaults(): any;
    static serializers: ISerializers;
    initialize(attributes: any, options: any): void;
    get canvasModels(): CanvasModel[];
    private updateCanvasModels;
    private updateCanvas;
    private resizeCanvas;
    private syncImageData;
    private forEachView;
    canvas: HTMLCanvasElement;
    ctx: CanvasRenderingContext2D;
    views: Dict<Promise<MultiCanvasView>>;
    static model_name: string;
    static model_module: any;
    static model_module_version: any;
    static view_name: string;
    static view_module: any;
    static view_module_version: any;
}
export declare class MultiCanvasView extends CanvasView {
    model: MultiCanvasModel;
}
