define("ipycanvas",["@jupyter-widgets/base"],(function(t){return function(t){var e={};function s(n){if(e[n])return e[n].exports;var i=e[n]={i:n,l:!1,exports:{}};return t[n].call(i.exports,i,i.exports,s),i.l=!0,i.exports}return s.m=t,s.c=e,s.d=function(t,e,n){s.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:n})},s.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},s.t=function(t,e){if(1&e&&(t=s(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var n=Object.create(null);if(s.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var i in t)s.d(n,i,function(e){return t[e]}.bind(null,i));return n},s.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return s.d(e,"a",e),e},s.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},s.p="",s(s.s=1)}([function(t,e,s){"use strict";Object.defineProperty(e,"__esModule",{value:!0});const n=s(2);e.MODULE_VERSION=n.version,e.MODULE_NAME=n.name},function(t,e,s){"use strict";function n(t){for(var s in t)e.hasOwnProperty(s)||(e[s]=t[s])}Object.defineProperty(e,"__esModule",{value:!0}),n(s(0)),n(s(3))},function(t){t.exports=JSON.parse('{"name":"ipycanvas","version":"0.6.1","description":"Interactive widgets library exposing the browser\'s Canvas API","keywords":["jupyter","jupyterlab","jupyterlab-extension","widgets"],"files":["lib/**/*.js","lib/**/*.d.ts","dist/*.js","dist/*.d.ts"],"homepage":"https://github.com/martinRenou/ipycanvas","bugs":{"url":"https://github.com/martinRenou/ipycanvas/issues"},"license":"BSD-3-Clause","author":{"name":"Martin Renou","email":"martin.renou@gmail.com"},"main":"lib/index.js","types":"./lib/index.d.ts","repository":{"type":"git","url":"https://github.com/martinRenou/ipycanvas"},"scripts":{"build":"npm run build:lib && npm run build:nbextension","build:labextension":"npm run clean:labextension && mkdirp ipycanvas/labextension && cd ipycanvas/labextension && npm pack ../..","build:lib":"tsc","build:nbextension":"webpack -p","build:all":"npm run build:lib && npm run build:labextension && npm run build:nbextension","clean":"npm run clean:lib && npm run clean:nbextension","clean:lib":"rimraf lib","clean:labextension":"rimraf ipycanvas/labextension","clean:nbextension":"rimraf ipycanvas/nbextension/static/index.js","prepack":"npm run build","watch":"npm-run-all -p watch:*","watch:lib":"tsc -w","watch:nbextension":"webpack --watch"},"dependencies":{"@jupyter-widgets/base":"^2.0.1 || ^3","lodash":">=4.17.13","roughjs":"^4.3.1"},"devDependencies":{"@phosphor/application":"^1.6.0","@phosphor/widgets":"^1.6.0","@types/node":"^10.11.6","@types/webpack-env":"^1.13.6","expect.js":"^0.3.1","fs-extra":"^7.0.0","mkdirp":"^0.5.1","npm-run-all":"^4.1.3","rimraf":"^2.6.2","source-map-loader":"^0.2.4","ts-loader":"^5.2.1","typescript":"~3.8","webpack":"^4.20.2","webpack-cli":"^3.1.2","acorn":"^6.2.0"},"jupyterlab":{"extension":"lib/plugin"}}')},function(t,e,s){"use strict";var n=this&&this.__awaiter||function(t,e,s,n){return new(s||(s=Promise))((function(i,a){function o(t){try{h(n.next(t))}catch(t){a(t)}}function r(t){try{h(n.throw(t))}catch(t){a(t)}}function h(t){var e;t.done?i(t.value):(e=t.value,e instanceof s?e:new s((function(t){t(e)}))).then(o,r)}h((n=n.apply(t,e||[])).next())}))};Object.defineProperty(e,"__esModule",{value:!0});const i=s(4),a=s(6),o=s(0),r=s(5);function h(t){const e=t.getContext("2d");if(null===e)throw"Could not create 2d context.";return e}class c extends i.WidgetModel{defaults(){return Object.assign(Object.assign({},super.defaults()),{_model_name:c.model_name,_model_module:c.model_module,_model_module_version:c.model_module_version,_view_name:c.view_name,_view_module:c.view_module,_view_module_version:c.view_module_version,value:""})}initialize(t,e){super.initialize(t,e),this.value=new Path2D(this.get("value"))}}e.Path2DModel=c,c.model_name="Path2DModel",c.model_module=o.MODULE_NAME,c.model_module_version=o.MODULE_VERSION,c.view_name="Path2DView",c.view_module=o.MODULE_NAME,c.view_module_version=o.MODULE_VERSION;class l extends i.DOMWidgetModel{defaults(){return Object.assign(Object.assign({},super.defaults()),{_model_name:l.model_name,_model_module:l.model_module,_model_module_version:l.model_module_version,_view_name:l.view_name,_view_module:l.view_module,_view_module_version:l.view_module_version,width:700,height:500,sync_image_data:!1,image_data:null})}initialize(t,e){super.initialize(t,e),this.canvas=document.createElement("canvas"),this.ctx=h(this.canvas),this.resizeCanvas(),this.drawImageData(),this.on_some_change(["width","height"],this.resizeCanvas,this),this.on("change:sync_image_data",this.syncImageData.bind(this)),this.on("msg:custom",this.onCommand.bind(this)),this.send({event:"client_ready"},{})}drawImageData(){return n(this,void 0,void 0,(function*(){if(null!==this.get("image_data")){const t=yield r.fromBytes(this.get("image_data"));this.ctx.drawImage(t,0,0),this.trigger("new-frame")}}))}onCommand(t,e){return n(this,void 0,void 0,(function*(){yield this.processCommand(t,e),this.forEachView(t=>{t.updateCanvas()}),this.trigger("new-frame"),this.syncImageData()}))}processCommand(t,e){return n(this,void 0,void 0,(function*(){if(t instanceof Array){let s=e;for(const e of t){let t=[];e.n_buffers&&(t=s.slice(0,e.n_buffers),s=s.slice(e.n_buffers)),yield this.processCommand(e,t)}return}const s=t.args;switch(t.name){case"fillRect":this.fillRect(s[0],s[1],s[2],s[3]);break;case"strokeRect":this.strokeRect(s[0],s[1],s[2],s[3]);break;case"fillRects":this.drawRects(t.args,e,this.fillRect.bind(this));break;case"strokeRects":this.drawRects(t.args,e,this.strokeRect.bind(this));break;case"fillArc":this.fillArc(s[0],s[1],s[2],s[3],s[4],s[5]);break;case"strokeArc":this.strokeArc(s[0],s[1],s[2],s[3],s[4],s[5]);break;case"fillArcs":this.drawArcs(t.args,e,this.fillArc.bind(this));break;case"strokeArcs":this.drawArcs(t.args,e,this.strokeArc.bind(this));break;case"fillCircle":this.fillCircle(s[0],s[1],s[2]);break;case"strokeCircle":this.strokeCircle(s[0],s[1],s[2]);break;case"fillCircles":this.drawCircles(t.args,e,this.fillCircle.bind(this));break;case"strokeCircles":this.drawCircles(t.args,e,this.strokeCircle.bind(this));break;case"strokeLine":this.strokeLine(t.args,e);break;case"fillPath":yield this.fillPath(t.args,e);break;case"drawImage":yield this.drawImage(t.args,e);break;case"putImageData":this.putImageData(t.args,e);break;case"set":this.setAttr(t.attr,t.value);break;case"clear":this.clearCanvas();break;default:this.executeCommand(t.name,t.args)}}))}fillRect(t,e,s,n){this.ctx.fillRect(t,e,s,n)}strokeRect(t,e,s,n){this.ctx.strokeRect(t,e,s,n)}drawRects(t,e,s){const n=r.getArg(t[0],e),i=r.getArg(t[1],e),a=r.getArg(t[2],e),o=r.getArg(t[3],e),h=Math.min(n.length,i.length,a.length,o.length);for(let t=0;t<h;++t)s(n.getItem(t),i.getItem(t),a.getItem(t),o.getItem(t))}fillArc(t,e,s,n,i,a){this.ctx.beginPath(),this.ctx.moveTo(t,e),this.ctx.lineTo(t+s*Math.cos(n),e+s*Math.sin(n)),this.ctx.arc(t,e,s,n,i,a),this.ctx.lineTo(t,e),this.ctx.fill(),this.ctx.closePath()}strokeArc(t,e,s,n,i,a){this.ctx.beginPath(),this.ctx.arc(t,e,s,n,i,a),this.ctx.stroke(),this.ctx.closePath()}drawArcs(t,e,s){const n=r.getArg(t[0],e),i=r.getArg(t[1],e),a=r.getArg(t[2],e),o=r.getArg(t[3],e),h=r.getArg(t[4],e),c=r.getArg(t[5],e),l=Math.min(n.length,i.length,a.length,o.length,h.length);for(let t=0;t<l;++t)s(n.getItem(t),i.getItem(t),a.getItem(t),o.getItem(t),h.getItem(t),c.getItem(t))}fillCircle(t,e,s){this.ctx.beginPath(),this.ctx.arc(t,e,s,0,2*Math.PI),this.ctx.fill(),this.ctx.closePath()}strokeCircle(t,e,s){this.ctx.beginPath(),this.ctx.arc(t,e,s,0,2*Math.PI),this.ctx.stroke(),this.ctx.closePath()}drawCircles(t,e,s){const n=r.getArg(t[0],e),i=r.getArg(t[1],e),a=r.getArg(t[2],e),o=Math.min(n.length,i.length,a.length);for(let t=0;t<o;++t)s(n.getItem(t),i.getItem(t),a.getItem(t))}strokeLine(t,e){this.ctx.beginPath(),this.ctx.moveTo(t[0],t[1]),this.ctx.lineTo(t[2],t[3]),this.ctx.stroke(),this.ctx.closePath()}fillPath(t,e){return n(this,void 0,void 0,(function*(){const[e]=t,s=yield i.unpack_models(e,this.widget_manager);this.ctx.fill(s.value)}))}drawImage(t,e){return n(this,void 0,void 0,(function*(){const[e,s,n,a,o]=t,r=yield i.unpack_models(e,this.widget_manager);if(r instanceof l||r instanceof f)this._drawImage(r.canvas,s,n,a,o);else if("ImageModel"==r.get("_model_name")){let t;const e=r.get("format"),i=r.get("value");if("url"!==e){const s=new Blob([i],{type:"image/"+e});t=URL.createObjectURL(s)}else t=new TextDecoder("utf-8").decode(i.buffer);const h=new Image;return new Promise(e=>{h.onload=()=>{this._drawImage(h,s,n,a,o),e()},h.src=t})}}))}_drawImage(t,e,s,n,i){void 0===n||void 0===i?this.ctx.drawImage(t,e,s):this.ctx.drawImage(t,e,s,n,i)}putImageData(t,e){const[s,n,i]=t,a=s.shape[1],o=s.shape[0],r=new Uint8ClampedArray(e[0].buffer),c=new ImageData(r,a,o),l=document.createElement("canvas");l.width=a,l.height=o,h(l).putImageData(c,0,0),this.ctx.drawImage(l,n,i)}setAttr(t,e){this.ctx[t]=e}clearCanvas(){this.forEachView(t=>{t.clear()}),this.ctx.clearRect(0,0,this.canvas.width,this.canvas.height)}executeCommand(t,e=[]){this.ctx[t](...e)}forEachView(t){for(const e in this.views)this.views[e].then(e=>{t(e)})}resizeCanvas(){this.canvas.setAttribute("width",this.get("width")),this.canvas.setAttribute("height",this.get("height"))}syncImageData(){return n(this,void 0,void 0,(function*(){if(!this.get("sync_image_data"))return;const t=yield r.toBytes(this.canvas);this.set("image_data",t),this.save_changes()}))}}e.CanvasModel=l,l.serializers=Object.assign(Object.assign({},i.DOMWidgetModel.serializers),{image_data:{serialize:function(t){return new DataView(t.buffer.slice(0))},deserialize:function(t){return null===t?null:new Uint8ClampedArray(t.buffer)}}}),l.model_name="CanvasModel",l.model_module=o.MODULE_NAME,l.model_module_version=o.MODULE_VERSION,l.view_name="CanvasView",l.view_module=o.MODULE_NAME,l.view_module_version=o.MODULE_VERSION;class u extends l{constructor(){super(...arguments),this.roughFillStyle="hachure",this.roughness=1,this.bowing=1}defaults(){return Object.assign(Object.assign({},super.defaults()),{_model_name:u.model_name})}initialize(t,e){super.initialize(t,e),this.roughCanvas=new a.RoughCanvas(this.canvas)}fillRect(t,e,s,n){this.roughCanvas.rectangle(t,e,s,n,this.getRoughFillStyle())}strokeRect(t,e,s,n){this.roughCanvas.rectangle(t,e,s,n,this.getRoughStrokeStyle())}fillCircle(t,e,s){this.roughCanvas.circle(t,e,s,this.getRoughFillStyle())}strokeCircle(t,e,s){this.roughCanvas.circle(t,e,s,this.getRoughStrokeStyle())}strokeLine(t,e){this.roughCanvas.line(t[0],t[1],t[2],t[3],this.getRoughStrokeStyle())}fillPath(t,e){return n(this,void 0,void 0,(function*(){const[e]=t,s=yield i.unpack_models(e,this.widget_manager);this.roughCanvas.path(s.get("value"),this.getRoughFillStyle())}))}fillArc(t,e,s,n,i,a){const o=2*s,r=a?i:n,h=a?n+2*Math.PI:i;this.roughCanvas.arc(t,e,o,o,r,h,!0,this.getRoughFillStyle())}strokeArc(t,e,s,n,i,a){const o=2*s,r=a?i:n,h=a?n+2*Math.PI:i;this.roughCanvas.arc(t,e,o,o,r,h,!1,this.getRoughStrokeStyle())}setAttr(t,e){switch(t){case"roughFillStyle":this.roughFillStyle=e;break;case"roughness":this.roughness=e;break;case"bowing":this.bowing=e;break;default:super.setAttr(t,e)}}getRoughFillStyle(){const t=this.ctx.fillStyle,e=this.ctx.lineWidth;return{fill:t,fillStyle:this.roughFillStyle,fillWeight:e/2,hachureGap:4*e,curveStepCount:18,strokeWidth:.001,roughness:this.roughness,bowing:this.bowing}}getRoughStrokeStyle(){return{stroke:this.ctx.strokeStyle,strokeWidth:this.ctx.lineWidth,roughness:this.roughness,bowing:this.bowing,curveStepCount:18}}}e.RoughCanvasModel=u,u.model_name="RoughCanvasModel";class d extends i.DOMWidgetView{render(){this.ctx=h(this.el),this.resizeCanvas(),this.model.on_some_change(["width","height"],this.resizeCanvas,this),this.el.addEventListener("mousemove",{handleEvent:this.onMouseMove.bind(this)}),this.el.addEventListener("mousedown",{handleEvent:this.onMouseDown.bind(this)}),this.el.addEventListener("mouseup",{handleEvent:this.onMouseUp.bind(this)}),this.el.addEventListener("mouseout",{handleEvent:this.onMouseOut.bind(this)}),this.el.addEventListener("touchstart",{handleEvent:this.onTouchStart.bind(this)}),this.el.addEventListener("touchend",{handleEvent:this.onTouchEnd.bind(this)}),this.el.addEventListener("touchmove",{handleEvent:this.onTouchMove.bind(this)}),this.el.addEventListener("touchcancel",{handleEvent:this.onTouchCancel.bind(this)}),this.updateCanvas()}clear(){this.ctx.clearRect(0,0,this.el.width,this.el.height)}updateCanvas(){this.clear(),this.ctx.drawImage(this.model.canvas,0,0)}resizeCanvas(){this.el.setAttribute("width",this.model.get("width")),this.el.setAttribute("height",this.model.get("height"))}onMouseMove(t){this.model.send(Object.assign({event:"mouse_move"},this.getCoordinates(t)),{})}onMouseDown(t){this.model.send(Object.assign({event:"mouse_down"},this.getCoordinates(t)),{})}onMouseUp(t){this.model.send(Object.assign({event:"mouse_up"},this.getCoordinates(t)),{})}onMouseOut(t){this.model.send(Object.assign({event:"mouse_out"},this.getCoordinates(t)),{})}onTouchStart(t){const e=Array.from(t.touches);this.model.send({event:"touch_start",touches:e.map(this.getCoordinates.bind(this))},{})}onTouchEnd(t){const e=Array.from(t.touches);this.model.send({event:"touch_end",touches:e.map(this.getCoordinates.bind(this))},{})}onTouchMove(t){const e=Array.from(t.touches);this.model.send({event:"touch_move",touches:e.map(this.getCoordinates.bind(this))},{})}onTouchCancel(t){const e=Array.from(t.touches);this.model.send({event:"touch_cancel",touches:e.map(this.getCoordinates.bind(this))},{})}getCoordinates(t){const e=this.el.getBoundingClientRect();return{x:this.el.width*(t.clientX-e.left)/e.width,y:this.el.height*(t.clientY-e.top)/e.height}}get tagName(){return"canvas"}}e.CanvasView=d;class f extends i.DOMWidgetModel{defaults(){return Object.assign(Object.assign({},super.defaults()),{_model_name:f.model_name,_model_module:f.model_module,_model_module_version:f.model_module_version,_view_name:f.view_name,_view_module:f.view_module,_view_module_version:f.view_module_version,_canvases:[],sync_image_data:!1,image_data:null,width:700,height:500})}initialize(t,e){super.initialize(t,e),this.canvas=document.createElement("canvas"),this.ctx=h(this.canvas),this.resizeCanvas(),this.on_some_change(["width","height"],this.resizeCanvas,this),this.on("change:_canvases",this.updateCanvasModels.bind(this)),this.on("change:sync_image_data",this.syncImageData.bind(this)),this.updateCanvasModels()}get canvasModels(){return this.get("_canvases")}updateCanvasModels(){for(const t of this.canvasModels)t.on("new-frame",this.updateCanvas,this);this.updateCanvas()}updateCanvas(){this.ctx.clearRect(0,0,this.get("width"),this.get("height"));for(const t of this.canvasModels)this.ctx.drawImage(t.canvas,0,0);this.forEachView(t=>{t.updateCanvas()}),this.syncImageData()}resizeCanvas(){this.canvas.setAttribute("width",this.get("width")),this.canvas.setAttribute("height",this.get("height"))}syncImageData(){return n(this,void 0,void 0,(function*(){if(!this.get("sync_image_data"))return;const t=yield r.toBytes(this.canvas);this.set("image_data",t),this.save_changes()}))}forEachView(t){for(const e in this.views)this.views[e].then(e=>{t(e)})}}e.MultiCanvasModel=f,f.serializers=Object.assign(Object.assign({},i.DOMWidgetModel.serializers),{_canvases:{deserialize:i.unpack_models},image_data:{serialize:t=>new DataView(t.buffer.slice(0))}}),f.model_name="MultiCanvasModel",f.model_module=o.MODULE_NAME,f.model_module_version=o.MODULE_VERSION,f.view_name="MultiCanvasView",f.view_module=o.MODULE_NAME,f.view_module_version=o.MODULE_VERSION;e.MultiCanvasView=class extends d{}},function(e,s){e.exports=t},function(t,e,s){"use strict";var n,i=this&&this.__awaiter||function(t,e,s,n){return new(s||(s=Promise))((function(i,a){function o(t){try{h(n.next(t))}catch(t){a(t)}}function r(t){try{h(n.throw(t))}catch(t){a(t)}}function h(t){var e;t.done?i(t.value):(e=t.value,e instanceof s?e:new s((function(t){t(e)}))).then(o,r)}h((n=n.apply(t,e||[])).next())}))};Object.defineProperty(e,"__esModule",{value:!0}),function(t){t.isScalar=function(t){return null===t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t}}(n||(n={}));class a{}e.Arg=a;class o extends a{constructor(t){super(),this.value=t,this.length=1/0}getItem(t){return this.value}}class r extends a{constructor(t,e){super(),this.value=function(t,e){switch(e.dtype){case"int8":return new Int8Array(t.buffer);case"int16":return new Int16Array(t.buffer);case"int32":return new Int32Array(t.buffer);case"float32":return new Float32Array(t.buffer);case"float64":return new Float64Array(t.buffer);default:throw"Unknown dtype "+e.dtype}}(e,t),this.length=this.value.length}getItem(t){return this.value[t]}}function h(t){return i(this,void 0,void 0,(function*(){return new Promise((e,s)=>{t.toBlob(t=>{if(null==t)return s("Unable to create blob");e(t)})})}))}e.getArg=function(t,e){if(n.isScalar(t))return new o(t);if(void 0!==t.idx)return new r(t,e[t.idx]);throw"Could not process argument "+t},e.toBlob=h,e.toBytes=function(t){return i(this,void 0,void 0,(function*(){const e=yield h(t);return new Promise((t,s)=>{const n=new FileReader;n.onloadend=()=>{if("string"==typeof n.result||null==n.result)return s("Unable to read blob");const e=new Uint8ClampedArray(n.result);t(e)},n.readAsArrayBuffer(e)})}))},e.fromBytes=function(t){return i(this,void 0,void 0,(function*(){const e=new Blob([t]);return new Promise((t,s)=>{const n=new Image;n.onload=()=>{t(n)},n.src=URL.createObjectURL(e)})}))}},function(t,e,s){"use strict";function n(t,e,s){if(t&&t.length){const[n,i]=e,a=Math.PI/180*s,o=Math.cos(a),r=Math.sin(a);t.forEach(t=>{const[e,s]=t;t[0]=(e-n)*o-(s-i)*r+n,t[1]=(e-n)*r+(s-i)*o+i})}}function i(t){const e=t[0],s=t[1];return Math.sqrt(Math.pow(e[0]-s[0],2)+Math.pow(e[1]-s[1],2))}function a(t,e,s,n){const i=e[1]-t[1],a=t[0]-e[0],o=i*t[0]+a*t[1],r=n[1]-s[1],h=s[0]-n[0],c=r*s[0]+h*s[1],l=i*h-r*a;return l?[(h*o-a*c)/l,(i*c-r*o)/l]:null}function o(t,e,s){const n=t.length;if(n<3)return!1;const i=[Number.MAX_SAFE_INTEGER,s],a=[e,s];let o=0;for(let e=0;e<n;e++){const s=t[e],l=t[(e+1)%n];if(c(s,l,a,i)){if(0===h(s,a,l))return r(s,a,l);o++}}return o%2==1}function r(t,e,s){return e[0]<=Math.max(t[0],s[0])&&e[0]>=Math.min(t[0],s[0])&&e[1]<=Math.max(t[1],s[1])&&e[1]>=Math.min(t[1],s[1])}function h(t,e,s){const n=(e[1]-t[1])*(s[0]-e[0])-(e[0]-t[0])*(s[1]-e[1]);return 0===n?0:n>0?1:2}function c(t,e,s,n){const i=h(t,e,s),a=h(t,e,n),o=h(s,n,t),c=h(s,n,e);return i!==a&&o!==c||(!(0!==i||!r(t,s,e))||(!(0!==a||!r(t,n,e))||(!(0!==o||!r(s,t,n))||!(0!==c||!r(s,e,n)))))}function l(t,e){const s=[0,0],i=Math.round(e.hachureAngle+90);i&&n(t,s,i);const a=function(t,e){const s=[...t];s[0].join(",")!==s[s.length-1].join(",")&&s.push([s[0][0],s[0][1]]);const n=[];if(s&&s.length>2){let t=e.hachureGap;t<0&&(t=4*e.strokeWidth),t=Math.max(t,.1);const i=[];for(let t=0;t<s.length-1;t++){const e=s[t],n=s[t+1];if(e[1]!==n[1]){const t=Math.min(e[1],n[1]);i.push({ymin:t,ymax:Math.max(e[1],n[1]),x:t===e[1]?e[0]:n[0],islope:(n[0]-e[0])/(n[1]-e[1])})}}if(i.sort((t,e)=>t.ymin<e.ymin?-1:t.ymin>e.ymin?1:t.x<e.x?-1:t.x>e.x?1:t.ymax===e.ymax?0:(t.ymax-e.ymax)/Math.abs(t.ymax-e.ymax)),!i.length)return n;let a=[],o=i[0].ymin;for(;a.length||i.length;){if(i.length){let t=-1;for(let e=0;e<i.length&&!(i[e].ymin>o);e++)t=e;i.splice(0,t+1).forEach(t=>{a.push({s:o,edge:t})})}if(a=a.filter(t=>!(t.edge.ymax<=o)),a.sort((t,e)=>t.edge.x===e.edge.x?0:(t.edge.x-e.edge.x)/Math.abs(t.edge.x-e.edge.x)),a.length>1)for(let t=0;t<a.length;t+=2){const e=t+1;if(e>=a.length)break;const s=a[t].edge,i=a[e].edge;n.push([[Math.round(s.x),o],[Math.round(i.x),o]])}o+=t,a.forEach(e=>{e.edge.x=e.edge.x+t*e.edge.islope})}}return n}(t,e);return i&&(n(t,s,-i),function(t,e,s){const i=[];t.forEach(t=>i.push(...t)),n(i,e,s)}(a,s,-i)),a}s.r(e),s.d(e,"RoughCanvas",(function(){return st}));class u{constructor(t){this.helper=t}fillPolygon(t,e){return this._fillPolygon(t,e)}_fillPolygon(t,e,s=!1){let n=l(t,e);if(s){const e=this.connectingLines(t,n);n=n.concat(e)}return{type:"fillSketch",ops:this.renderLines(n,e)}}renderLines(t,e){const s=[];for(const n of t)s.push(...this.helper.doubleLineOps(n[0][0],n[0][1],n[1][0],n[1][1],e));return s}connectingLines(t,e){const s=[];if(e.length>1)for(let n=1;n<e.length;n++){const a=e[n-1];if(i(a)<3)continue;const o=[e[n][0],a[1]];if(i(o)>3){const e=this.splitOnIntersections(t,o);s.push(...e)}}return s}midPointInPolygon(t,e){return o(t,(e[0][0]+e[1][0])/2,(e[0][1]+e[1][1])/2)}splitOnIntersections(t,e){const s=Math.max(5,.1*i(e)),n=[];for(let o=0;o<t.length;o++){const r=t[o],h=t[(o+1)%t.length];if(c(r,h,...e)){const t=a(r,h,e[0],e[1]);if(t){const a=i([t,e[0]]),o=i([t,e[1]]);a>s&&o>s&&n.push({point:t,distance:a})}}}if(n.length>1){const s=n.sort((t,e)=>t.distance-e.distance).map(t=>t.point);if(o(t,...e[0])||s.shift(),o(t,...e[1])||s.pop(),s.length<=1)return this.midPointInPolygon(t,e)?[e]:[];const i=[e[0],...s,e[1]],a=[];for(let e=0;e<i.length-1;e+=2){const s=[i[e],i[e+1]];this.midPointInPolygon(t,s)&&a.push(s)}return a}return this.midPointInPolygon(t,e)?[e]:[]}}class d extends u{fillPolygon(t,e){return this._fillPolygon(t,e,!0)}}class f extends u{fillPolygon(t,e){const s=this._fillPolygon(t,e),n=Object.assign({},e,{hachureAngle:e.hachureAngle+90}),i=this._fillPolygon(t,n);return s.ops=s.ops.concat(i.ops),s}}class p{constructor(t){this.helper=t}fillPolygon(t,e){const s=l(t,e=Object.assign({},e,{curveStepCount:4,hachureAngle:0,roughness:1}));return this.dotsOnLines(s,e)}dotsOnLines(t,e){const s=[];let n=e.hachureGap;n<0&&(n=4*e.strokeWidth),n=Math.max(n,.1);let a=e.fillWeight;a<0&&(a=e.strokeWidth/2);const o=n/4;for(const r of t){const t=i(r),h=t/n,c=Math.ceil(h)-1,l=t-c*n,u=(r[0][0]+r[1][0])/2-n/4,d=Math.min(r[0][1],r[1][1]);for(let t=0;t<c;t++){const i=d+l+t*n,r=this.helper.randOffsetWithRange(u-o,u+o,e),h=this.helper.randOffsetWithRange(i-o,i+o,e),c=this.helper.ellipse(r,h,a,a,e);s.push(...c.ops)}}return{type:"fillSketch",ops:s}}}class g{constructor(t){this.helper=t}fillPolygon(t,e){const s=l(t,e);return{type:"fillSketch",ops:this.dashedLine(s,e)}}dashedLine(t,e){const s=e.dashOffset<0?e.hachureGap<0?4*e.strokeWidth:e.hachureGap:e.dashOffset,n=e.dashGap<0?e.hachureGap<0?4*e.strokeWidth:e.hachureGap:e.dashGap,a=[];return t.forEach(t=>{const o=i(t),r=Math.floor(o/(s+n)),h=(o+n-r*(s+n))/2;let c=t[0],l=t[1];c[0]>l[0]&&(c=t[1],l=t[0]);const u=Math.atan((l[1]-c[1])/(l[0]-c[0]));for(let t=0;t<r;t++){const i=t*(s+n),o=i+s,r=[c[0]+i*Math.cos(u)+h*Math.cos(u),c[1]+i*Math.sin(u)+h*Math.sin(u)],l=[c[0]+o*Math.cos(u)+h*Math.cos(u),c[1]+o*Math.sin(u)+h*Math.sin(u)];a.push(...this.helper.doubleLineOps(r[0],r[1],l[0],l[1],e))}}),a}}class m{constructor(t){this.helper=t}fillPolygon(t,e){const s=e.hachureGap<0?4*e.strokeWidth:e.hachureGap,n=e.zigzagOffset<0?s:e.zigzagOffset,i=l(t,e=Object.assign({},e,{hachureGap:s+n}));return{type:"fillSketch",ops:this.zigzagLines(i,n,e)}}zigzagLines(t,e,s){const n=[];return t.forEach(t=>{const a=i(t),o=Math.round(a/(2*e));let r=t[0],h=t[1];r[0]>h[0]&&(r=t[1],h=t[0]);const c=Math.atan((h[1]-r[1])/(h[0]-r[0]));for(let t=0;t<o;t++){const i=2*t*e,a=2*(t+1)*e,o=Math.sqrt(2*Math.pow(e,2)),h=[r[0]+i*Math.cos(c),r[1]+i*Math.sin(c)],l=[r[0]+a*Math.cos(c),r[1]+a*Math.sin(c)],u=[h[0]+o*Math.cos(c+Math.PI/4),h[1]+o*Math.sin(c+Math.PI/4)];n.push(...this.helper.doubleLineOps(h[0],h[1],u[0],u[1],s),...this.helper.doubleLineOps(u[0],u[1],l[0],l[1],s))}}),n}}const v={};class b{constructor(t){this.seed=t}next(){return this.seed?(2**31-1&(this.seed=Math.imul(48271,this.seed)))/2**31:Math.random()}}const M={A:7,a:7,C:6,c:6,H:1,h:1,L:2,l:2,M:2,m:2,Q:4,q:4,S:4,s:4,T:2,t:2,V:1,v:1,Z:0,z:0};function y(t,e){return t.type===e}function w(t){const e=[],s=function(t){const e=new Array;for(;""!==t;)if(t.match(/^([ \t\r\n,]+)/))t=t.substr(RegExp.$1.length);else if(t.match(/^([aAcChHlLmMqQsStTvVzZ])/))e[e.length]={type:0,text:RegExp.$1},t=t.substr(RegExp.$1.length);else{if(!t.match(/^(([-+]?[0-9]+(\.[0-9]*)?|[-+]?\.[0-9]+)([eE][-+]?[0-9]+)?)/))return[];e[e.length]={type:1,text:""+parseFloat(RegExp.$1)},t=t.substr(RegExp.$1.length)}return e[e.length]={type:2,text:""},e}(t);let n="BOD",i=0,a=s[i];for(;!y(a,2);){let o=0;const r=[];if("BOD"===n){if("M"!==a.text&&"m"!==a.text)return w("M0,0"+t);i++,o=M[a.text],n=a.text}else y(a,1)?o=M[n]:(i++,o=M[a.text],n=a.text);if(!(i+o<s.length))throw new Error("Path data ended short");for(let t=i;t<i+o;t++){const e=s[t];if(!y(e,1))throw new Error("Param not a number: "+n+","+e.text);r[r.length]=+e.text}if("number"!=typeof M[n])throw new Error("Bad segment: "+n);{const t={key:n,data:r};e.push(t),i+=o,a=s[i],"M"===n&&(n="L"),"m"===n&&(n="l")}}return e}function _(t){let e=0,s=0,n=0,i=0;const a=[];for(const{key:o,data:r}of t)switch(o){case"M":a.push({key:"M",data:[...r]}),[e,s]=r,[n,i]=r;break;case"m":e+=r[0],s+=r[1],a.push({key:"M",data:[e,s]}),n=e,i=s;break;case"L":a.push({key:"L",data:[...r]}),[e,s]=r;break;case"l":e+=r[0],s+=r[1],a.push({key:"L",data:[e,s]});break;case"C":a.push({key:"C",data:[...r]}),e=r[4],s=r[5];break;case"c":{const t=r.map((t,n)=>n%2?t+s:t+e);a.push({key:"C",data:t}),e=t[4],s=t[5];break}case"Q":a.push({key:"Q",data:[...r]}),e=r[2],s=r[3];break;case"q":{const t=r.map((t,n)=>n%2?t+s:t+e);a.push({key:"Q",data:t}),e=t[2],s=t[3];break}case"A":a.push({key:"A",data:[...r]}),e=r[5],s=r[6];break;case"a":e+=r[5],s+=r[6],a.push({key:"A",data:[r[0],r[1],r[2],r[3],r[4],e,s]});break;case"H":a.push({key:"H",data:[...r]}),e=r[0];break;case"h":e+=r[0],a.push({key:"H",data:[e]});break;case"V":a.push({key:"V",data:[...r]}),s=r[0];break;case"v":s+=r[0],a.push({key:"V",data:[s]});break;case"S":a.push({key:"S",data:[...r]}),e=r[2],s=r[3];break;case"s":{const t=r.map((t,n)=>n%2?t+s:t+e);a.push({key:"S",data:t}),e=t[2],s=t[3];break}case"T":a.push({key:"T",data:[...r]}),e=r[0],s=r[1];break;case"t":e+=r[0],s+=r[1],a.push({key:"T",data:[e,s]});break;case"Z":case"z":a.push({key:"Z",data:[]}),e=n,s=i}return a}function k(t){const e=[];let s="",n=0,i=0,a=0,o=0,r=0,h=0;for(const{key:c,data:l}of t){switch(c){case"M":e.push({key:"M",data:[...l]}),[n,i]=l,[a,o]=l;break;case"C":e.push({key:"C",data:[...l]}),n=l[4],i=l[5],r=l[2],h=l[3];break;case"L":e.push({key:"L",data:[...l]}),[n,i]=l;break;case"H":n=l[0],e.push({key:"L",data:[n,i]});break;case"V":i=l[0],e.push({key:"L",data:[n,i]});break;case"S":{let t=0,a=0;"C"===s||"S"===s?(t=n+(n-r),a=i+(i-h)):(t=n,a=i),e.push({key:"C",data:[t,a,...l]}),r=l[0],h=l[1],n=l[2],i=l[3];break}case"T":{const[t,a]=l;let o=0,c=0;"Q"===s||"T"===s?(o=n+(n-r),c=i+(i-h)):(o=n,c=i);const u=n+2*(o-n)/3,d=i+2*(c-i)/3,f=t+2*(o-t)/3,p=a+2*(c-a)/3;e.push({key:"C",data:[u,d,f,p,t,a]}),r=o,h=c,n=t,i=a;break}case"Q":{const[t,s,a,o]=l,c=n+2*(t-n)/3,u=i+2*(s-i)/3,d=a+2*(t-a)/3,f=o+2*(s-o)/3;e.push({key:"C",data:[c,u,d,f,a,o]}),r=t,h=s,n=a,i=o;break}case"A":{const t=Math.abs(l[0]),s=Math.abs(l[1]),a=l[2],o=l[3],r=l[4],h=l[5],c=l[6];if(0===t||0===s)e.push({key:"C",data:[n,i,h,c,h,c]}),n=h,i=c;else if(n!==h||i!==c){C(n,i,h,c,t,s,a,o,r).forEach((function(t){e.push({key:"C",data:t})})),n=h,i=c}break}case"Z":e.push({key:"Z",data:[]}),n=a,i=o}s=c}return e}function x(t,e,s){return[t*Math.cos(s)-e*Math.sin(s),t*Math.sin(s)+e*Math.cos(s)]}function C(t,e,s,n,i,a,o,r,h,c){const l=(u=o,Math.PI*u/180);var u;let d=[],f=0,p=0,g=0,m=0;if(c)[f,p,g,m]=c;else{[t,e]=x(t,e,-l),[s,n]=x(s,n,-l);const o=(t-s)/2,c=(e-n)/2;let u=o*o/(i*i)+c*c/(a*a);u>1&&(u=Math.sqrt(u),i*=u,a*=u);const d=i*i,v=a*a,b=d*v-d*c*c-v*o*o,M=d*c*c+v*o*o,y=(r===h?-1:1)*Math.sqrt(Math.abs(b/M));g=y*i*c/a+(t+s)/2,m=y*-a*o/i+(e+n)/2,f=Math.asin(parseFloat(((e-m)/a).toFixed(9))),p=Math.asin(parseFloat(((n-m)/a).toFixed(9))),t<g&&(f=Math.PI-f),s<g&&(p=Math.PI-p),f<0&&(f=2*Math.PI+f),p<0&&(p=2*Math.PI+p),h&&f>p&&(f-=2*Math.PI),!h&&p>f&&(p-=2*Math.PI)}let v=p-f;if(Math.abs(v)>120*Math.PI/180){const t=p,e=s,r=n;p=h&&p>f?f+120*Math.PI/180*1:f+120*Math.PI/180*-1,d=C(s=g+i*Math.cos(p),n=m+a*Math.sin(p),e,r,i,a,o,0,h,[p,t,g,m])}v=p-f;const b=Math.cos(f),M=Math.sin(f),y=Math.cos(p),w=Math.sin(p),_=Math.tan(v/4),k=4/3*i*_,O=4/3*a*_,P=[t,e],I=[t+k*M,e-O*b],S=[s+k*w,n-O*y],A=[s,n];if(I[0]=2*P[0]-I[0],I[1]=2*P[1]-I[1],c)return[I,S,A].concat(d);{d=[I,S,A].concat(d);const t=[];for(let e=0;e<d.length;e+=3){const s=x(d[e][0],d[e][1],l),n=x(d[e+1][0],d[e+1][1],l),i=x(d[e+2][0],d[e+2][1],l);t.push([s[0],s[1],n[0],n[1],i[0],i[1]])}return t}}const O={randOffset:function(t,e){return W(t,e)},randOffsetWithRange:function(t,e,s){return j(t,e,s)},ellipse:function(t,e,s,n,i){const a=E(s,n,i);return R(t,e,i,a).opset},doubleLineOps:function(t,e,s,n,i){return U(t,e,s,n,i,!0)}};function P(t,e,s,n,i){return{type:"path",ops:U(t,e,s,n,i)}}function I(t,e,s){const n=(t||[]).length;if(n>2){const i=[];for(let e=0;e<n-1;e++)i.push(...U(t[e][0],t[e][1],t[e+1][0],t[e+1][1],s));return e&&i.push(...U(t[n-1][0],t[n-1][1],t[0][0],t[0][1],s)),{type:"path",ops:i}}return 2===n?P(t[0][0],t[0][1],t[1][0],t[1][1],s):{type:"path",ops:[]}}function S(t,e,s,n,i){return function(t,e){return I(t,!0,e)}([[t,e],[t+s,e],[t+s,e+n],[t,e+n]],i)}function A(t,e){let s=F(t,1*(1+.2*e.roughness),e);if(!e.disableMultiStroke){const n=F(t,1.5*(1+.22*e.roughness),function(t){const e=Object.assign({},t);e.randomizer=void 0,t.seed&&(e.seed=t.seed+1);return e}(e));s=s.concat(n)}return{type:"path",ops:s}}function E(t,e,s){const n=Math.sqrt(2*Math.PI*Math.sqrt((Math.pow(t/2,2)+Math.pow(e/2,2))/2)),i=Math.max(s.curveStepCount,s.curveStepCount/Math.sqrt(200)*n),a=2*Math.PI/i;let o=Math.abs(t/2),r=Math.abs(e/2);const h=1-s.curveFitting;return o+=W(o*h,s),r+=W(r*h,s),{increment:a,rx:o,ry:r}}function R(t,e,s,n){const[i,a]=B(n.increment,t,e,n.rx,n.ry,1,n.increment*j(.1,j(.4,1,s),s),s);let o=N(i,null,s);if(!s.disableMultiStroke){const[i]=B(n.increment,t,e,n.rx,n.ry,1.5,0,s),a=N(i,null,s);o=o.concat(a)}return{estimatedPoints:a,opset:{type:"path",ops:o}}}function L(t,e,s,n,i,a,o,r,h){const c=t,l=e;let u=Math.abs(s/2),d=Math.abs(n/2);u+=W(.01*u,h),d+=W(.01*d,h);let f=i,p=a;for(;f<0;)f+=2*Math.PI,p+=2*Math.PI;p-f>2*Math.PI&&(f=0,p=2*Math.PI);const g=2*Math.PI/h.curveStepCount,m=Math.min(g/2,(p-f)/2),v=G(m,c,l,u,d,f,p,1,h);if(!h.disableMultiStroke){const t=G(m,c,l,u,d,f,p,1.5,h);v.push(...t)}return o&&(r?v.push(...U(c,l,c+u*Math.cos(f),l+d*Math.sin(f),h),...U(c,l,c+u*Math.cos(p),l+d*Math.sin(p),h)):v.push({op:"lineTo",data:[c,l]},{op:"lineTo",data:[c+u*Math.cos(f),l+d*Math.sin(f)]})),{type:"path",ops:v}}function D(t,e){const s=[];if(t.length){const n=e.maxRandomnessOffset||0,i=t.length;if(i>2){s.push({op:"move",data:[t[0][0]+W(n,e),t[0][1]+W(n,e)]});for(let a=1;a<i;a++)s.push({op:"lineTo",data:[t[a][0]+W(n,e),t[a][1]+W(n,e)]})}}return{type:"fillPath",ops:s}}function T(t,e){return function(t,e){let s=t.fillStyle||"hachure";if(!v[s])switch(s){case"zigzag":v[s]||(v[s]=new d(e));break;case"cross-hatch":v[s]||(v[s]=new f(e));break;case"dots":v[s]||(v[s]=new p(e));break;case"dashed":v[s]||(v[s]=new g(e));break;case"zigzag-line":v[s]||(v[s]=new m(e));break;case"hachure":default:s="hachure",v[s]||(v[s]=new u(e))}return v[s]}(e,O).fillPolygon(t,e)}function z(t){return t.randomizer||(t.randomizer=new b(t.seed||0)),t.randomizer.next()}function j(t,e,s,n=1){return s.roughness*n*(z(s)*(e-t)+t)}function W(t,e,s=1){return j(-t,t,e,s)}function U(t,e,s,n,i,a=!1){const o=a?i.disableMultiStrokeFill:i.disableMultiStroke,r=V(t,e,s,n,i,!0,!1);if(o)return r;const h=V(t,e,s,n,i,!0,!0);return r.concat(h)}function V(t,e,s,n,i,a,o){const r=Math.pow(t-s,2)+Math.pow(e-n,2),h=Math.sqrt(r);let c=1;c=h<200?1:h>500?.4:-.0016668*h+1.233334;let l=i.maxRandomnessOffset||0;l*l*100>r&&(l=h/10);const u=l/2,d=.2+.2*z(i);let f=i.bowing*i.maxRandomnessOffset*(n-e)/200,p=i.bowing*i.maxRandomnessOffset*(t-s)/200;f=W(f,i,c),p=W(p,i,c);const g=[],m=()=>W(u,i,c),v=()=>W(l,i,c);return a&&(o?g.push({op:"move",data:[t+m(),e+m()]}):g.push({op:"move",data:[t+W(l,i,c),e+W(l,i,c)]})),o?g.push({op:"bcurveTo",data:[f+t+(s-t)*d+m(),p+e+(n-e)*d+m(),f+t+2*(s-t)*d+m(),p+e+2*(n-e)*d+m(),s+m(),n+m()]}):g.push({op:"bcurveTo",data:[f+t+(s-t)*d+v(),p+e+(n-e)*d+v(),f+t+2*(s-t)*d+v(),p+e+2*(n-e)*d+v(),s+v(),n+v()]}),g}function F(t,e,s){const n=[];n.push([t[0][0]+W(e,s),t[0][1]+W(e,s)]),n.push([t[0][0]+W(e,s),t[0][1]+W(e,s)]);for(let i=1;i<t.length;i++)n.push([t[i][0]+W(e,s),t[i][1]+W(e,s)]),i===t.length-1&&n.push([t[i][0]+W(e,s),t[i][1]+W(e,s)]);return N(n,null,s)}function N(t,e,s){const n=t.length,i=[];if(n>3){const a=[],o=1-s.curveTightness;i.push({op:"move",data:[t[1][0],t[1][1]]});for(let e=1;e+2<n;e++){const s=t[e];a[0]=[s[0],s[1]],a[1]=[s[0]+(o*t[e+1][0]-o*t[e-1][0])/6,s[1]+(o*t[e+1][1]-o*t[e-1][1])/6],a[2]=[t[e+1][0]+(o*t[e][0]-o*t[e+2][0])/6,t[e+1][1]+(o*t[e][1]-o*t[e+2][1])/6],a[3]=[t[e+1][0],t[e+1][1]],i.push({op:"bcurveTo",data:[a[1][0],a[1][1],a[2][0],a[2][1],a[3][0],a[3][1]]})}if(e&&2===e.length){const t=s.maxRandomnessOffset;i.push({op:"lineTo",data:[e[0]+W(t,s),e[1]+W(t,s)]})}}else 3===n?(i.push({op:"move",data:[t[1][0],t[1][1]]}),i.push({op:"bcurveTo",data:[t[1][0],t[1][1],t[2][0],t[2][1],t[2][0],t[2][1]]})):2===n&&i.push(...U(t[0][0],t[0][1],t[1][0],t[1][1],s));return i}function B(t,e,s,n,i,a,o,r){const h=[],c=[],l=W(.5,r)-Math.PI/2;c.push([W(a,r)+e+.9*n*Math.cos(l-t),W(a,r)+s+.9*i*Math.sin(l-t)]);for(let o=l;o<2*Math.PI+l-.01;o+=t){const t=[W(a,r)+e+n*Math.cos(o),W(a,r)+s+i*Math.sin(o)];h.push(t),c.push(t)}return c.push([W(a,r)+e+n*Math.cos(l+2*Math.PI+.5*o),W(a,r)+s+i*Math.sin(l+2*Math.PI+.5*o)]),c.push([W(a,r)+e+.98*n*Math.cos(l+o),W(a,r)+s+.98*i*Math.sin(l+o)]),c.push([W(a,r)+e+.9*n*Math.cos(l+.5*o),W(a,r)+s+.9*i*Math.sin(l+.5*o)]),[c,h]}function G(t,e,s,n,i,a,o,r,h){const c=a+W(.1,h),l=[];l.push([W(r,h)+e+.9*n*Math.cos(c-t),W(r,h)+s+.9*i*Math.sin(c-t)]);for(let a=c;a<=o;a+=t)l.push([W(r,h)+e+n*Math.cos(a),W(r,h)+s+i*Math.sin(a)]);return l.push([e+n*Math.cos(o),s+i*Math.sin(o)]),l.push([e+n*Math.cos(o),s+i*Math.sin(o)]),N(l,null,h)}function $(t,e,s,n,i,a,o,r){const h=[],c=[r.maxRandomnessOffset||1,(r.maxRandomnessOffset||1)+.3];let l=[0,0];const u=r.disableMultiStroke?1:2;for(let d=0;d<u;d++)0===d?h.push({op:"move",data:[o[0],o[1]]}):h.push({op:"move",data:[o[0]+W(c[0],r),o[1]+W(c[0],r)]}),l=[i+W(c[d],r),a+W(c[d],r)],h.push({op:"bcurveTo",data:[t+W(c[d],r),e+W(c[d],r),s+W(c[d],r),n+W(c[d],r),l[0],l[1]]});return h}function q(t){return[...t]}function Z(t,e){return Math.pow(t[0]-e[0],2)+Math.pow(t[1]-e[1],2)}function Q(t,e,s){const n=Z(e,s);if(0===n)return Z(t,e);let i=((t[0]-e[0])*(s[0]-e[0])+(t[1]-e[1])*(s[1]-e[1]))/n;return i=Math.max(0,Math.min(1,i)),Z(t,H(e,s,i))}function H(t,e,s){return[t[0]+(e[0]-t[0])*s,t[1]+(e[1]-t[1])*s]}function X(t,e,s,n){const i=n||[];if(function(t,e){const s=t[e+0],n=t[e+1],i=t[e+2],a=t[e+3];let o=3*n[0]-2*s[0]-a[0];o*=o;let r=3*n[1]-2*s[1]-a[1];r*=r;let h=3*i[0]-2*a[0]-s[0];h*=h;let c=3*i[1]-2*a[1]-s[1];return c*=c,o<h&&(o=h),r<c&&(r=c),o+r}(t,e)<s){const s=t[e+0];if(i.length){(a=i[i.length-1],o=s,Math.sqrt(Z(a,o)))>1&&i.push(s)}else i.push(s);i.push(t[e+3])}else{const n=.5,a=t[e+0],o=t[e+1],r=t[e+2],h=t[e+3],c=H(a,o,n),l=H(o,r,n),u=H(r,h,n),d=H(c,l,n),f=H(l,u,n),p=H(d,f,n);X([a,c,d,p],0,s,i),X([p,f,u,h],0,s,i)}var a,o;return i}function J(t,e){return Y(t,0,t.length,e)}function Y(t,e,s,n,i){const a=i||[],o=t[e],r=t[s-1];let h=0,c=1;for(let n=e+1;n<s-1;++n){const e=Q(t[n],o,r);e>h&&(h=e,c=n)}return Math.sqrt(h)>n?(Y(t,e,c+1,n,a),Y(t,c,s,n,a)):(a.length||a.push(o),a.push(r)),a}function K(t,e=.15,s){const n=[],i=(t.length-1)/3;for(let s=0;s<i;s++){X(t,3*s,e,n)}return s&&s>0?Y(n,0,n.length,s):n}const tt="none";class et{constructor(t){this.defaultOptions={maxRandomnessOffset:2,roughness:1,bowing:1,stroke:"#000",strokeWidth:1,curveTightness:0,curveFitting:.95,curveStepCount:9,fillStyle:"hachure",fillWeight:-1,hachureAngle:-41,hachureGap:-1,dashOffset:-1,dashGap:-1,zigzagOffset:-1,seed:0,combineNestedSvgPaths:!1,disableMultiStroke:!1,disableMultiStrokeFill:!1},this.config=t||{},this.config.options&&(this.defaultOptions=this._o(this.config.options))}static newSeed(){return Math.floor(Math.random()*2**31)}_o(t){return t?Object.assign({},this.defaultOptions,t):this.defaultOptions}_d(t,e,s){return{shape:t,sets:e||[],options:s||this.defaultOptions}}line(t,e,s,n,i){const a=this._o(i);return this._d("line",[P(t,e,s,n,a)],a)}rectangle(t,e,s,n,i){const a=this._o(i),o=[],r=S(t,e,s,n,a);if(a.fill){const i=[[t,e],[t+s,e],[t+s,e+n],[t,e+n]];"solid"===a.fillStyle?o.push(D(i,a)):o.push(T(i,a))}return a.stroke!==tt&&o.push(r),this._d("rectangle",o,a)}ellipse(t,e,s,n,i){const a=this._o(i),o=[],r=E(s,n,a),h=R(t,e,a,r);if(a.fill)if("solid"===a.fillStyle){const s=R(t,e,a,r).opset;s.type="fillPath",o.push(s)}else o.push(T(h.estimatedPoints,a));return a.stroke!==tt&&o.push(h.opset),this._d("ellipse",o,a)}circle(t,e,s,n){const i=this.ellipse(t,e,s,s,n);return i.shape="circle",i}linearPath(t,e){const s=this._o(e);return this._d("linearPath",[I(t,!1,s)],s)}arc(t,e,s,n,i,a,o=!1,r){const h=this._o(r),c=[],l=L(t,e,s,n,i,a,o,!0,h);if(o&&h.fill)if("solid"===h.fillStyle){const o=L(t,e,s,n,i,a,!0,!1,h);o.type="fillPath",c.push(o)}else c.push(function(t,e,s,n,i,a,o){const r=t,h=e;let c=Math.abs(s/2),l=Math.abs(n/2);c+=W(.01*c,o),l+=W(.01*l,o);let u=i,d=a;for(;u<0;)u+=2*Math.PI,d+=2*Math.PI;d-u>2*Math.PI&&(u=0,d=2*Math.PI);const f=(d-u)/o.curveStepCount,p=[];for(let t=u;t<=d;t+=f)p.push([r+c*Math.cos(t),h+l*Math.sin(t)]);return p.push([r+c*Math.cos(d),h+l*Math.sin(d)]),p.push([r,h]),T(p,o)}(t,e,s,n,i,a,h));return h.stroke!==tt&&c.push(l),this._d("arc",c,h)}curve(t,e){const s=this._o(e),n=[],i=A(t,s);if(s.fill&&s.fill!==tt&&t.length>=3){const e=K(function(t,e=0){const s=t.length;if(s<3)throw new Error("A curve must have at least three points.");const n=[];if(3===s)n.push(q(t[0]),q(t[1]),q(t[2]),q(t[2]));else{const s=[];s.push(t[0],t[0]);for(let e=1;e<t.length;e++)s.push(t[e]),e===t.length-1&&s.push(t[e]);const i=[],a=1-e;n.push(q(s[0]));for(let t=1;t+2<s.length;t++){const e=s[t];i[0]=[e[0],e[1]],i[1]=[e[0]+(a*s[t+1][0]-a*s[t-1][0])/6,e[1]+(a*s[t+1][1]-a*s[t-1][1])/6],i[2]=[s[t+1][0]+(a*s[t][0]-a*s[t+2][0])/6,s[t+1][1]+(a*s[t][1]-a*s[t+2][1])/6],i[3]=[s[t+1][0],s[t+1][1]],n.push(i[1],i[2],i[3])}}return n}(t),10,(1+s.roughness)/2);"solid"===s.fillStyle?n.push(D(e,s)):n.push(T(e,s))}return s.stroke!==tt&&n.push(i),this._d("curve",n,s)}polygon(t,e){const s=this._o(e),n=[],i=I(t,!0,s);return s.fill&&("solid"===s.fillStyle?n.push(D(t,s)):n.push(T(t,s))),s.stroke!==tt&&n.push(i),this._d("polygon",n,s)}path(t,e){const s=this._o(e),n=[];if(!t)return this._d("path",n,s);t=(t||"").replace(/\n/g," ").replace(/(-\s)/g,"-").replace("/(ss)/g"," ");const i=s.fill&&"transparent"!==s.fill&&s.fill!==tt,a=s.stroke!==tt,o=!!(s.simplification&&s.simplification<1),r=function(t,e,s){const n=k(_(w(t))),i=[];let a=[],o=[0,0],r=[];const h=()=>{r.length>=4&&a.push(...K(r,e)),r=[]},c=()=>{h(),a.length&&(i.push(a),a=[])};for(const{key:t,data:e}of n)switch(t){case"M":c(),o=[e[0],e[1]],a.push(o);break;case"L":h(),a.push([e[0],e[1]]);break;case"C":if(!r.length){const t=a.length?a[a.length-1]:o;r.push([t[0],t[1]])}r.push([e[0],e[1]]),r.push([e[2],e[3]]),r.push([e[4],e[5]]);break;case"Z":h(),a.push([o[0],o[1]])}if(c(),!s)return i;const l=[];for(const t of i){const e=J(t,s);e.length&&l.push(e)}return l}(t,1,o?4-4*s.simplification:(1+s.roughness)/2);if(i)if(s.combineNestedSvgPaths){const t=[];r.forEach(e=>t.push(...e)),"solid"===s.fillStyle?n.push(D(t,s)):n.push(T(t,s))}else r.forEach(t=>{"solid"===s.fillStyle?n.push(D(t,s)):n.push(T(t,s))});return a&&(o?r.forEach(t=>{n.push(I(t,!1,s))}):n.push(function(t,e){const s=k(_(w(t))),n=[];let i=[0,0],a=[0,0];for(const{key:t,data:o}of s)switch(t){case"M":{const t=1*(e.maxRandomnessOffset||0);n.push({op:"move",data:o.map(s=>s+W(t,e))}),a=[o[0],o[1]],i=[o[0],o[1]];break}case"L":n.push(...U(a[0],a[1],o[0],o[1],e)),a=[o[0],o[1]];break;case"C":{const[t,s,i,r,h,c]=o;n.push(...$(t,s,i,r,h,c,a,e)),a=[h,c];break}case"Z":n.push(...U(a[0],a[1],i[0],i[1],e)),a=[i[0],i[1]]}return{type:"path",ops:n}}(t,s))),this._d("path",n,s)}opsToPath(t){let e="";for(const s of t.ops){const t=s.data;switch(s.op){case"move":e+=`M${t[0]} ${t[1]} `;break;case"bcurveTo":e+=`C${t[0]} ${t[1]}, ${t[2]} ${t[3]}, ${t[4]} ${t[5]} `;break;case"lineTo":e+=`L${t[0]} ${t[1]} `}}return e.trim()}toPaths(t){const e=t.sets||[],s=t.options||this.defaultOptions,n=[];for(const t of e){let e=null;switch(t.type){case"path":e={d:this.opsToPath(t),stroke:s.stroke,strokeWidth:s.strokeWidth,fill:tt};break;case"fillPath":e={d:this.opsToPath(t),stroke:tt,strokeWidth:0,fill:s.fill||tt};break;case"fillSketch":e=this.fillSketch(t,s)}e&&n.push(e)}return n}fillSketch(t,e){let s=e.fillWeight;return s<0&&(s=e.strokeWidth/2),{d:this.opsToPath(t),stroke:e.fill||tt,strokeWidth:s,fill:tt}}}class st{constructor(t,e){this.canvas=t,this.ctx=this.canvas.getContext("2d"),this.gen=new et(e)}draw(t){const e=t.sets||[],s=t.options||this.getDefaultOptions(),n=this.ctx;for(const i of e)switch(i.type){case"path":n.save(),n.strokeStyle="none"===s.stroke?"transparent":s.stroke,n.lineWidth=s.strokeWidth,s.strokeLineDash&&n.setLineDash(s.strokeLineDash),s.strokeLineDashOffset&&(n.lineDashOffset=s.strokeLineDashOffset),this._drawToContext(n,i),n.restore();break;case"fillPath":n.save(),n.fillStyle=s.fill||"";const e="curve"===t.shape||"polygon"===t.shape?"evenodd":"nonzero";this._drawToContext(n,i,e),n.restore();break;case"fillSketch":this.fillSketch(n,i,s)}}fillSketch(t,e,s){let n=s.fillWeight;n<0&&(n=s.strokeWidth/2),t.save(),s.fillLineDash&&t.setLineDash(s.fillLineDash),s.fillLineDashOffset&&(t.lineDashOffset=s.fillLineDashOffset),t.strokeStyle=s.fill||"",t.lineWidth=n,this._drawToContext(t,e),t.restore()}_drawToContext(t,e,s="nonzero"){t.beginPath();for(const s of e.ops){const e=s.data;switch(s.op){case"move":t.moveTo(e[0],e[1]);break;case"bcurveTo":t.bezierCurveTo(e[0],e[1],e[2],e[3],e[4],e[5]);break;case"lineTo":t.lineTo(e[0],e[1])}}"fillPath"===e.type?t.fill(s):t.stroke()}get generator(){return this.gen}getDefaultOptions(){return this.gen.defaultOptions}line(t,e,s,n,i){const a=this.gen.line(t,e,s,n,i);return this.draw(a),a}rectangle(t,e,s,n,i){const a=this.gen.rectangle(t,e,s,n,i);return this.draw(a),a}ellipse(t,e,s,n,i){const a=this.gen.ellipse(t,e,s,n,i);return this.draw(a),a}circle(t,e,s,n){const i=this.gen.circle(t,e,s,n);return this.draw(i),i}linearPath(t,e){const s=this.gen.linearPath(t,e);return this.draw(s),s}polygon(t,e){const s=this.gen.polygon(t,e);return this.draw(s),s}arc(t,e,s,n,i,a,o=!1,r){const h=this.gen.arc(t,e,s,n,i,a,o,r);return this.draw(h),h}curve(t,e){const s=this.gen.curve(t,e);return this.draw(s),s}path(t,e){const s=this.gen.path(t,e);return this.draw(s),s}}}])}));
//# sourceMappingURL=embed-bundle.js.map