# -*- coding:utf-8 -*-
"""
@Author  :   g1879
@Contact :   g1879@qq.com
"""
from pathlib import Path
from queue import Queue
from threading import Lock
from typing import Union, Tuple

from DataRecorder import Recorder
from DrissionPage.base import BasePage
from requests import Session, Response

from ._funcs import FileExistsSetter, PathSetter, BlockSizeSetter, LogMode
from .mission import Task, Mission, BaseTask


class DownloadKit(object):
    file_exists: FileExistsSetter = ...
    goal_path: PathSetter = ...
    block_size: BlockSizeSetter = ...

    def __init__(self,
                 goal_path: Union[str, Path] = None,
                 roads: int = 10,
                 session: Union[Session, BasePage] = None,
                 file_exists: str = 'rename'):
        self._roads: int = ...
        self._print_mode: LogMode = ...
        self._log_mode: LogMode = ...
        self._logger: Recorder = ...
        self._retry: int = ...
        self._interval: float = ...
        self._page: Union[BasePage, None] = ...
        self._waiting_list: Queue = ...
        self._session: Session = ...
        self._running_count: int = ...
        self._missions_num: int = ...
        self._missions: dict = ...
        self._threads: dict = ...
        self.split: bool = ...
        self._timeout: Union[int, float] = ...
        self._stop_printing: bool = ...
        self._lock: Lock = ...

    def __call__(self,
                 file_url: str,
                 goal_path: Union[str, Path] = None,
                 rename: str = None,
                 file_exists: str = None,
                 post_data: Union[str, dict] = None,
                 show_msg: bool = True,
                 **kwargs) -> tuple: ...

    def set_print(self) -> LogMode: ...

    def set_log(self, log_path: [str, Path] = None) -> LogMode: ...

    @property
    def roads(self) -> int: ...

    @roads.setter
    def roads(self, val: int) -> None: ...

    @property
    def retry(self) -> int: ...

    @retry.setter
    def retry(self, times: int) -> None: ...

    @property
    def interval(self) -> float: ...

    @interval.setter
    def interval(self, seconds: Union[int, float]) -> None: ...

    @property
    def timeout(self) -> float: ...

    @timeout.setter
    def timeout(self, seconds: Union[int, float]) -> None: ...

    @property
    def waiting_list(self) -> Queue: ...

    @property
    def session(self) -> Session: ...

    @session.setter
    def session(self, session: Union[Session, BasePage]) -> None: ...

    @property
    def is_running(self) -> bool: ...

    def set_proxies(self, http: str = None, https: str = None) -> None: ...

    def add(self,
            file_url: str,
            goal_path: Union[str, Path] = None,
            rename: str = None,
            file_exists: str = None,
            post_data: Union[str, dict] = None,
            split: bool = None,
            **kwargs) -> Mission: ...

    def _run_or_wait(self, mission: BaseTask): ...

    def _run(self, ID: int, mission: BaseTask) -> None: ...

    def get_mission(self, mission_or_id: Union[int, Mission]) -> Mission: ...

    def get_failed_missions(self) -> list: ...

    def wait(self,
             mission: Union[int, Mission] = None,
             show: bool = False,
             timeout: float = None) -> Union[tuple, None]: ...

    def cancel(self): ...

    def show(self, asyn: bool = True, keep: bool = False) -> None: ...

    def _show(self, wait: float, keep: bool = False) -> None: ...

    def _connect(self,
                 url: str,
                 mode: str = 'get',
                 data: Union[dict, str] = None,
                 **kwargs) -> Tuple[Union[Response, None], str]: ...

    def _get_usable_thread(self) -> Union[int, None]: ...

    def _stop_show(self) -> None: ...

    def _when_mission_done(self, mission: Mission) -> None: ...

    def _download(self,
                  mission_or_task: Union[Mission, Task],
                  thread_id: int) -> None: ...
