# some predefined colors to use


class MaterialColors:
    Red50 = (255, 235, 238)
    Red100 = (255, 205, 210)
    Red200 = (239, 154, 154)
    Red300 = (229, 115, 115)
    Red400 = (239, 83, 80)
    Red500 = (244, 67, 54)
    Red600 = (229, 57, 53)
    Red700 = (211, 47, 47)
    Red800 = (198, 40, 40)
    Red900 = (183, 28, 28)
    RedA100 = (255, 138, 128)
    RedA200 = (255, 82, 82)
    RedA400 = (255, 23, 68)
    RedA700 = (213, 0, 0)
    Pink50 = (252, 228, 236)
    Pink100 = (248, 187, 208)
    Pink200 = (244, 143, 177)
    Pink300 = (240, 98, 146)
    Pink400 = (236, 64, 122)
    Pink500 = (233, 30, 99)
    Pink600 = (216, 27, 96)
    Pink700 = (194, 24, 91)
    Pink800 = (173, 20, 87)
    Pink900 = (136, 14, 79)
    PinkA100 = (255, 128, 171)
    PinkA200 = (255, 64, 129)
    PinkA400 = (245, 0, 87)
    PinkA700 = (197, 17, 98)
    Purple50 = (243, 229, 245)
    Purple100 = (225, 190, 231)
    Purple200 = (206, 147, 216)
    Purple300 = (186, 104, 200)
    Purple400 = (171, 71, 188)
    Purple500 = (156, 39, 176)
    Purple600 = (142, 36, 170)
    Purple700 = (123, 31, 162)
    Purple800 = (106, 27, 154)
    Purple900 = (74, 20, 140)
    PurpleA100 = (234, 128, 252)
    PurpleA200 = (224, 64, 251)
    PurpleA400 = (213, 0, 249)
    PurpleA700 = (170, 0, 255)
    DeepPurple50 = (237, 231, 246)
    DeepPurple100 = (209, 196, 233)
    DeepPurple200 = (179, 157, 219)
    DeepPurple300 = (149, 117, 205)
    DeepPurple400 = (126, 87, 194)
    DeepPurple500 = (103, 58, 183)
    DeepPurple600 = (94, 53, 177)
    DeepPurple700 = (81, 45, 168)
    DeepPurple800 = (69, 39, 160)
    DeepPurple900 = (49, 27, 146)
    DeepPurpleA100 = (179, 136, 255)
    DeepPurpleA200 = (124, 77, 255)
    DeepPurpleA400 = (101, 31, 255)
    DeepPurpleA700 = (98, 0, 234)
    Indigo50 = (232, 234, 246)
    Indigo100 = (197, 202, 233)
    Indigo200 = (159, 168, 218)
    Indigo300 = (121, 134, 203)
    Indigo400 = (92, 107, 192)
    Indigo500 = (63, 81, 181)
    Indigo600 = (57, 73, 171)
    Indigo700 = (48, 63, 159)
    Indigo800 = (40, 53, 147)
    Indigo900 = (26, 35, 126)
    IndigoA100 = (140, 158, 255)
    IndigoA200 = (83, 109, 254)
    IndigoA400 = (61, 90, 254)
    IndigoA700 = (48, 79, 254)
    Blue50 = (227, 242, 253)
    Blue100 = (187, 222, 251)
    Blue200 = (144, 202, 249)
    Blue300 = (100, 181, 246)
    Blue400 = (66, 165, 245)
    Blue500 = (33, 150, 243)
    Blue600 = (30, 136, 229)
    Blue700 = (25, 118, 210)
    Blue800 = (21, 101, 192)
    Blue900 = (13, 71, 161)
    BlueA100 = (130, 177, 255)
    BlueA200 = (68, 138, 255)
    BlueA400 = (41, 121, 255)
    BlueA700 = (41, 98, 255)
    LightBlue50 = (225, 245, 254)
    LightBlue100 = (179, 229, 252)
    LightBlue200 = (129, 212, 250)
    LightBlue300 = (79, 195, 247)
    LightBlue400 = (41, 182, 246)
    LightBlue500 = (3, 169, 244)
    LightBlue600 = (3, 155, 229)
    LightBlue700 = (2, 136, 209)
    LightBlue800 = (2, 119, 189)
    LightBlue900 = (1, 87, 155)
    LightBlueA100 = (128, 216, 255)
    LightBlueA200 = (64, 196, 255)
    LightBlueA400 = (0, 176, 255)
    LightBlueA700 = (0, 145, 234)
    Cyan50 = (224, 247, 250)
    Cyan100 = (178, 235, 242)
    Cyan200 = (128, 222, 234)
    Cyan300 = (77, 208, 225)
    Cyan400 = (38, 198, 218)
    Cyan500 = (0, 188, 212)
    Cyan600 = (0, 172, 193)
    Cyan700 = (0, 151, 167)
    Cyan800 = (0, 131, 143)
    Cyan900 = (0, 96, 100)
    CyanA100 = (132, 255, 255)
    CyanA200 = (24, 255, 255)
    CyanA400 = (0, 229, 255)
    CyanA700 = (0, 184, 212)
    Teal50 = (224, 242, 241)
    Teal100 = (178, 223, 219)
    Teal200 = (128, 203, 196)
    Teal300 = (77, 182, 172)
    Teal400 = (38, 166, 154)
    Teal500 = (0, 150, 136)
    Teal600 = (0, 137, 123)
    Teal700 = (0, 121, 107)
    Teal800 = (0, 105, 92)
    Teal900 = (0, 77, 64)
    TealA100 = (167, 255, 235)
    TealA200 = (100, 255, 218)
    TealA400 = (29, 233, 182)
    TealA700 = (0, 191, 165)
    Green50 = (232, 245, 233)
    Green100 = (200, 230, 201)
    Green200 = (165, 214, 167)
    Green300 = (129, 199, 132)
    Green400 = (102, 187, 106)
    Green500 = (76, 175, 80)
    Green600 = (67, 160, 71)
    Green700 = (56, 142, 60)
    Green800 = (46, 125, 50)
    Green900 = (27, 94, 32)
    GreenA100 = (185, 246, 202)
    GreenA200 = (105, 240, 174)
    GreenA400 = (0, 230, 118)
    GreenA700 = (0, 200, 83)
    LightGreen50 = (241, 248, 233)
    LightGreen100 = (220, 237, 200)
    LightGreen200 = (197, 225, 165)
    LightGreen300 = (174, 213, 129)
    LightGreen400 = (156, 204, 101)
    LightGreen500 = (139, 195, 74)
    LightGreen600 = (124, 179, 66)
    LightGreen700 = (104, 159, 56)
    LightGreen800 = (85, 139, 47)
    LightGreen900 = (51, 105, 30)
    LightGreenA100 = (204, 255, 144)
    LightGreenA200 = (178, 255, 89)
    LightGreenA400 = (118, 255, 3)
    LightGreenA700 = (100, 221, 23)
    Lime50 = (249, 251, 231)
    Lime100 = (240, 244, 195)
    Lime200 = (230, 238, 156)
    Lime300 = (220, 231, 117)
    Lime400 = (212, 225, 87)
    Lime500 = (205, 220, 57)
    Lime600 = (192, 202, 51)
    Lime700 = (175, 180, 43)
    Lime800 = (158, 157, 36)
    Lime900 = (130, 119, 23)
    LimeA100 = (244, 255, 129)
    LimeA200 = (238, 255, 65)
    LimeA400 = (198, 255, 0)
    LimeA700 = (174, 234, 0)
    Yellow50 = (255, 253, 231)
    Yellow100 = (255, 249, 196)
    Yellow200 = (255, 245, 157)
    Yellow300 = (255, 241, 118)
    Yellow400 = (255, 238, 88)
    Yellow500 = (255, 235, 59)
    Yellow600 = (253, 216, 53)
    Yellow700 = (251, 192, 45)
    Yellow800 = (249, 168, 37)
    Yellow900 = (245, 127, 23)
    YellowA100 = (255, 255, 141)
    YellowA200 = (255, 255, 0)
    YellowA400 = (255, 234, 0)
    YellowA700 = (255, 214, 0)
    Amber50 = (255, 248, 225)
    Amber100 = (255, 236, 179)
    Amber200 = (255, 224, 130)
    Amber300 = (255, 213, 79)
    Amber400 = (255, 202, 40)
    Amber500 = (255, 193, 7)
    Amber600 = (255, 179, 0)
    Amber700 = (255, 160, 0)
    Amber800 = (255, 143, 0)
    Amber900 = (255, 111, 0)
    AmberA100 = (255, 229, 127)
    AmberA200 = (255, 215, 64)
    AmberA400 = (255, 196, 0)
    AmberA700 = (255, 171, 0)
    Orange50 = (255, 243, 224)
    Orange100 = (255, 224, 178)
    Orange200 = (255, 204, 128)
    Orange300 = (255, 183, 77)
    Orange400 = (255, 167, 38)
    Orange500 = (255, 152, 0)
    Orange600 = (251, 140, 0)
    Orange700 = (245, 124, 0)
    Orange800 = (239, 108, 0)
    Orange900 = (230, 81, 0)
    OrangeA100 = (255, 209, 128)
    OrangeA200 = (255, 171, 64)
    OrangeA400 = (255, 145, 0)
    OrangeA700 = (255, 109, 0)
    DeepOrange50 = (251, 233, 231)
    DeepOrange100 = (255, 204, 188)
    DeepOrange200 = (255, 171, 145)
    DeepOrange300 = (255, 138, 101)
    DeepOrange400 = (255, 112, 67)
    DeepOrange500 = (255, 87, 34)
    DeepOrange600 = (244, 81, 30)
    DeepOrange700 = (230, 74, 25)
    DeepOrange800 = (216, 67, 21)
    DeepOrange900 = (191, 54, 12)
    DeepOrangeA100 = (255, 158, 128)
    DeepOrangeA200 = (255, 110, 64)
    DeepOrangeA400 = (255, 61, 0)
    DeepOrangeA700 = (221, 44, 0)
    Brown50 = (239, 235, 233)
    Brown100 = (215, 204, 200)
    Brown200 = (188, 170, 164)
    Brown300 = (161, 136, 127)
    Brown400 = (141, 110, 99)
    Brown500 = (121, 85, 72)
    Brown600 = (109, 76, 65)
    Brown700 = (93, 64, 55)
    Brown800 = (78, 52, 46)
    Brown900 = (62, 39, 35)
    Gray50 = (250, 250, 250)
    Gray100 = (245, 245, 245)
    Gray200 = (238, 238, 238)
    Gray300 = (224, 224, 224)
    Gray400 = (189, 189, 189)
    Gray500 = (158, 158, 158)
    Gray600 = (117, 117, 117)
    Gray700 = (97, 97, 97)
    Gray800 = (66, 66, 66)
    Gray900 = (33, 33, 33)
    BlueGray50 = (236, 239, 241)
    BlueGray100 = (207, 216, 220)
    BlueGray200 = (176, 190, 197)
    BlueGray300 = (144, 164, 174)
    BlueGray400 = (120, 144, 156)
    BlueGray500 = (96, 125, 139)
    BlueGray600 = (84, 110, 122)
    BlueGray700 = (69, 90, 100)
    BlueGray800 = (55, 71, 79)
    BlueGray900 = (38, 50, 56)
    Black = (0, 0, 0)
    White = (255, 255, 255)


class CssColors:
    AliceBlue = (240, 248, 255)
    AntiqueWhite = (250, 235, 215)
    Aqua = (0, 255, 255)
    AquaMarine = (127, 255, 212)
    Azure = (240, 255, 255)
    Beige = (245, 245, 220)
    Bisque = (255, 228, 196)
    Black = (0, 0, 0)
    BlanchedAlmond = (255, 235, 205)
    Blue = (0, 0, 255)
    BlueViolet = (138, 43, 226)
    Brown = (165, 42, 42)
    BurlyWood = (222, 184, 135)
    CadetBlue = (95, 158, 160)
    Chartreuse = (127, 255, 0)
    Chocolate = (210, 105, 30)
    Coral = (255, 127, 80)
    CornFlowerBlue = (100, 149, 237)
    CornSilk = (255, 248, 220)
    Crimson = (220, 20, 60)
    Cyan = (0, 255, 255)
    DarkBlue = (0, 0, 139)
    DarkCyan = (0, 139, 139)
    DarkGoldenRod = (184, 134, 11)
    DarkGray = (169, 169, 169)
    DarkGreen = (0, 100, 0)
    DarkKhaki = (189, 183, 107)
    DarkMagenta = (139, 0, 139)
    DarkOliveGreen = (85, 107, 47)
    DarkOrange = (255, 140, 0)
    DarkOrchid = (153, 50, 204)
    DarkRed = (139, 0, 0)
    DarkSalmon = (233, 150, 122)
    DarkSeaGreen = (143, 188, 143)
    DarkSlateBlue = (72, 61, 139)
    DarkSlateGray = (47, 79, 79)
    DarkTurquoise = (0, 206, 209)
    DarkViolet = (148, 0, 211)
    DeepPink = (255, 20, 147)
    DeepSkyBlue = (0, 191, 255)
    DimGray = (105, 105, 105)
    DodgerBlue = (30, 144, 255)
    Firebrick = (178, 34, 34)
    FloralWhite = (255, 250, 240)
    ForestGreen = (34, 139, 34)
    Gainsboro = (220, 220, 220)
    GhostWhite = (248, 248, 255)
    Gold = (255, 215, 0)
    GoldenRod = (218, 165, 32)
    Gray = (128, 128, 128)
    Green = (0, 128, 0)
    GreenYellow = (173, 255, 47)
    Honeydew = (240, 255, 240)
    HotPink = (255, 105, 180)
    IndianRed = (205, 92, 92)
    Indigo = (75, 0, 130)
    Ivory = (255, 255, 240)
    Khaki = (240, 230, 140)
    Lavender = (230, 230, 250)
    LavenderBlush = (255, 240, 245)
    LawnGreen = (124, 252, 0)
    LemonChiffon = (255, 250, 205)
    LightBlue = (173, 216, 230)
    LightCoral = (240, 128, 128)
    LightCyan = (224, 255, 255)
    LightGoldenRodYellow = (250, 250, 210)
    LightGray = (211, 211, 211)
    LightGreen = (144, 238, 144)
    LightPink = (255, 182, 193)
    LightSalmon = (255, 160, 122)
    LightSeaGreen = (32, 178, 170)
    LightSkyBlue = (135, 206, 250)
    LightSlateGray = (119, 136, 153)
    LightSteelBlue = (176, 196, 222)
    LightYellow = (255, 255, 224)
    Lime = (0, 255, 0)
    LimeGreen = (50, 205, 50)
    Linen = (250, 240, 230)
    Magenta = (255, 0, 255)
    Maroon = (128, 0, 0)
    MediumAquaMarine = (102, 205, 170)
    MediumBlue = (0, 0, 205)
    MediumOrchid = (186, 85, 211)
    MediumPurple = (147, 112, 219)
    MediumSeaGreen = (60, 179, 113)
    MediumSlateBlue = (123, 104, 238)
    MediumSpringGreen = (0, 250, 154)
    MediumTurquoise = (72, 209, 204)
    MediumVioletRed = (199, 21, 133)
    MidnightBlue = (25, 25, 112)
    MintCream = (245, 255, 250)
    MistyRose = (255, 228, 225)
    Moccasin = (255, 228, 181)
    NavajoWhite = (255, 222, 173)
    Navy = (0, 0, 128)
    OldLace = (253, 245, 230)
    Olive = (128, 128, 0)
    OliveDrab = (107, 142, 35)
    Orange = (255, 165, 0)
    OrangeRed = (255, 69, 0)
    Orchid = (218, 112, 214)
    PaleGoldenRod = (238, 232, 170)
    PaleGreen = (152, 251, 152)
    PaleTurquoise = (175, 238, 238)
    PaleVioletRed = (219, 112, 147)
    PapayaWhip = (255, 239, 213)
    PeachPuff = (255, 218, 185)
    Peru = (205, 133, 63)
    Pink = (255, 192, 203)
    Plum = (221, 160, 221)
    PowderBlue = (176, 224, 230)
    Purple = (128, 0, 128)
    Red = (255, 0, 0)
    RosyBrown = (188, 143, 143)
    RoyalBlue = (65, 105, 225)
    SaddleBrown = (139, 69, 19)
    Salmon = (250, 128, 114)
    SandyBrown = (244, 164, 96)
    SeaGreen = (46, 139, 87)
    SeaShell = (255, 245, 238)
    Sienna = (160, 82, 45)
    Silver = (192, 192, 192)
    SkyBlue = (135, 206, 235)
    SlateBlue = (106, 90, 205)
    SlateGray = (112, 128, 144)
    Snow = (255, 250, 250)
    SpringGreen = (0, 255, 127)
    SteelBlue = (70, 130, 180)
    Tan = (210, 180, 140)
    Teal = (0, 128, 128)
    Thistle = (216, 191, 216)
    Tomato = (255, 99, 71)
    Turquoise = (64, 224, 208)
    Violet = (238, 130, 238)
    Wheat = (245, 222, 179)
    White = (255, 255, 255)
    WhiteSmoke = (245, 245, 245)
    Yellow = (255, 255, 0)
    YellowGreen = (154, 205, 50)


def hex_to_rgb(color: str) -> tuple[int, int, int]:
    if color[0] == "#":
        r = color_value_in_range(int(color[1:3], 16))
        g = color_value_in_range(int(color[3:5], 16))
        b = color_value_in_range(int(color[5:], 16))
        return (r, g, b)
    raise ValueError(
        f"Invalid value {color}.\n"
        "Hex value must begynn with # and be 6 characters long."
    )


def color_value_in_range(color_value: int):
    if color_value >= 0 and color_value <= 256:
        return color_value
    raise ValueError(
        f"Invalid value {color_value}.\nValues for colors must be in range 0 - 255."
    )
